
#include "defs.h"
#include "ring.h"
#include "z.e"
#include "mat.h"
#include "q.e"
#include "lll.h"
#include "debug.h"

Logical
lll_int_check WITH_7_ARGS(
    t_handle,            zrng,
    t_handle,            qfld,
    rational,          delta,
    matrix,            b,
    matrix,            omu,
    matrix,            oB,
    Logical,           end
)
/*
** lll_int_check returns a value which indicates whether the matrix is
** LLL-reduced, and also the mu and B matrices are checked
*/
{
    block_declarations;
    rational          half;
    rational          h;
    matrix            bst;
    matrix            mu;
    matrix            B;
    integer_small     n;
    integer_small     k;
    integer_small     i;
    integer_small     j;
    integer_small     l;
    rational          temp;
    rational          temp2;
    rational          result;
    rational          retval;
    rational          total;

    retval = TRUE;

    half = q_make( qfld, 1, 2 );

    n = mat_row( b );		/* dimension of (space = R^n) */
    k = mat_col( b );		/* number of vectors */

    bst = mat_new( n, k );
    mat_ring_create_zero_sub( qfld, &bst );

    mu = mat_new( k, k );
    mat_ring_create_zero_sub( qfld, &mu );

    B = mat_new( 1, k );

    for ( i=1; i<=k; ++i )
    {
	if ( v3_df[LLL_DEBUG_INTER_MAX] )
	{
	    cay_print( "i=%d\n", i );
	}

	for ( j=1; j<=i-1; ++j )
	{
	    if ( v3_df[LLL_DEBUG_INTER_MAX] )
	    {
		cay_print( "  j=%d\n", j );
	    }

	    total = 0;
	    for ( l=1; l<=n; ++l )
	    {
		temp = q_int_mult( qfld, mat_elt( bst, l, j ), mat_elt( b, l, i ));
		temp2 = q_add( qfld, total, temp );
		q_delref( temp );
		q_delref( total );
		total = temp2;
	    }

	    q_delref( mat_elt( mu, i, j ));
	    mat_elt( mu, i, j ) = q_divide( qfld, total, mat_entry( B, j ));
	    q_delref( total );

	    if ( end )
	    {
		temp = q_abs( qfld, mat_elt( mu, i, j ) );

		if ( q_compare( qfld, half, temp ) < 0 )
		{
		    retval = FALSE;

		    cay_print( " error in mu's at mu_%d,%d = ", i, j );
		    q_write( mat_elt( mu, i, j ) );
		    cay_print( "\n" );
		}

		q_delref( temp );
	    }

	    if ( q_compare( qfld, mat_elt( omu, i, j ),
		mat_elt( mu, i, j ) ) != 0 )
	    {
		retval = FALSE;

		cay_print( "   mu discrepancy : mu_%d,%d,  omu = ", i, j );
		q_write( mat_elt( omu, i, j ) );
		cay_print( ",  mu = " );
		q_write( mat_elt( mu, i, j ) );
		cay_print( "\n" );
	    }
	}

	total = 0;
	for ( l=1; l<=n; ++l )
	{
	    h = q_make( qfld, mat_elt( b, l, i ), 1 );

	    for ( j=1; j<i; ++j )
	    {
		temp = q_mult( qfld, mat_elt( mu, i, j ), mat_elt( bst, l, j ) );
		temp2 = h;
		h = q_subtract( qfld, temp2, temp );
		q_delref( temp2 );
		q_delref( temp );
	    }

	    q_delref( mat_elt( bst, l, i ));
	    mat_elt( bst, l, i ) = h;

	    /*
	    ** inner product loop
	    */

	    temp = q_mult( qfld, h, h );
	    temp2 = q_add( qfld, temp, total );
	    q_delref( total );
	    q_delref( temp );
	    total = temp2;
	}

	mat_entry( B, i ) = total;

	if ( q_compare( qfld, mat_entry( B, i ),
	    mat_entry( oB, i ) ) != 0 )
	{
	    retval = FALSE;

	    cay_print( "   B discrepancy : B_%d,  oB = ", i );
	    q_write( mat_entry( oB, i ) );
	    cay_print( ",  B = " );
	    q_write( mat_entry( B, i ) );
	    cay_print( "\n" );
	}

	if ( end && i >= 2 )
	{
	    result = 0;
	    for ( l=1; l<=n; ++l )
	    {
		temp = q_mult( qfld, mat_elt( mu, i, i-1 ), mat_elt( bst, l, i-1 ) );
		temp2 = q_add( qfld, temp, mat_elt( bst, l, i ) );
		q_delref( temp );

		temp = q_mult( qfld, temp2, temp2 );
		q_delref( temp2 );

		temp2 = q_add( qfld, result, temp );
		q_delref( temp );
		q_delref( result );

		result = temp2;
	    }

	    total = 0;

	    for ( l=1; l<=n; ++l )
	    {
		temp = q_mult( qfld, mat_elt( bst, l, i-1 ), mat_elt( bst, l, i-1 ));
		temp2 = total;
		total = q_add( qfld, temp2, temp );
		q_delref( temp2 );
		q_delref( temp );
	    }

	    temp2 = q_mult( qfld, total, delta );
	    q_delref( total );

	    if ( q_compare( qfld, result, temp2 ) == -1 )
	    {
		retval = FALSE;

		cay_print( "error in b's, i=%d\n", i );
	    }

	    q_delref( result );
	    q_delref( temp2 );
	}
    }

    q_delref( half );
    mat_delref( qfld, &bst );
    mat_delref( qfld, &mu );
    mat_delref( qfld, &B );

    return  retval;
}
