#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"

void
inthdl_gcd_mult     WITH_5_ARGS(
    inthdl_handle,  ahdl,
    inthdl_handle,  bhdl,
    inthdl_handle,  gcd,
    inthdl_handle,  m1,
    inthdl_handle,  m2
)

/*
 *  Input:  ahdl, bhdl - infinite-precision integers (handles)
 *  Output: gcd - infinite-precision integer = gcd(ahdl, bhdl)
 *          m1, m2 - infinite-precision integers such that
 *              gcd = ahdl * m1 + bhdl * m2
 */

{
    register inthdl_length  llen;
    inthdl_length   alen;
    inthdl_length   blen;
    inthdl_handle   a;
    inthdl_handle   b;
    inthdl_handle   c;
    inthdl_handle   d;
    inthdl_handle   p;
    inthdl_handle   q;
    inthdl_handle   r;
    inthdl_handle   s;
    inthdl_handle   t;
    register t_int  even;
    register inthdl_handle temp;

    DEBUG_INTHDL_2("+inthdl_gcd_mult", ahdl, bhdl);

    alen = intbig_curr_size(ahdl);
    blen = intbig_curr_size(bhdl);
    llen = (alen > blen ? alen : blen) + 1;

    a = inthdl_buf_alloc(llen);
    b = inthdl_buf_alloc(llen);
    c = inthdl_buf_alloc(llen);
    d = inthdl_buf_alloc(llen);
    p = inthdl_buf_alloc(llen);
    q = inthdl_buf_alloc(llen);
    r = inthdl_buf_alloc(llen);
    s = inthdl_buf_alloc(llen);
    t = inthdl_buf_alloc(llen);

    inthdl_abs(ahdl, a);
    inthdl_abs(bhdl, b);

    intbig_sign(p) = intbig_sign(s) = 0;

    intbig_sign(q) = intbig_sign(r) = 1;
    intbig_curr_size(q) = 1;
    intbig_curr_size(r) = 1;
    intbig_digit(q, 0) = 1;
    intbig_digit(r, 0) = 1;

    even = 1;
    for (;;)
    {
	inthdl_quot_rem(a, b, c, t);
	if (intbig_sign(t) == 0)
	    break;
	temp = d;
	d = b;
	b = t;
	t = temp;
	temp = a;
	a = d;
	d = temp;
	if (even)
	{
	    inthdl_mult(c, q, m1);
	    inthdl_add(p, m1, t);
	    temp = t;
	    t = p;
	    p = temp;
	    inthdl_mult(c, s, m1);
	    inthdl_add(r, m1, t);
	    temp = t;
	    t = r;
	    r = temp;
	}
	else
	{
	    inthdl_mult(c, p, m1);
	    inthdl_add(q, m1, t);
	    temp = t;
	    t = q;
	    q = temp;
	    inthdl_mult(c, r, m1);
	    inthdl_add(s, m1, t);
	    temp = t;
	    t = s;
	    s = temp;
	}
	even = !even;
    }

    inthdl_abs(b, gcd);
    if (even)
    {
	inthdl_negate(s, m1);
	inthdl_negate(q, t);
	inthdl_negate(t, m2);
    }
    else
    {
	inthdl_negate(r, t);
	inthdl_negate(t, m1);
	inthdl_negate(p, m2);
    }

    inthdl_buf_delete(a);
    inthdl_buf_delete(b);
    inthdl_buf_delete(c);
    inthdl_buf_delete(d);
    inthdl_buf_delete(p);
    inthdl_buf_delete(q);
    inthdl_buf_delete(r);
    inthdl_buf_delete(s);
    inthdl_buf_delete(t);

    DEBUG_INTHDL(("-inthdl_gcd_mult", 3, gcd, m1, m2));
}
