#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"

void
inthdl_abs      WITH_2_ARGS(
    inthdl_handle,  ahdl,
    inthdl_handle,  result
)
/*
**  Input:  ahdl - infinite-precision integer t_handle
**  Output: result - infinite-precision integer hanle = abs(ahdl)
*/
{
    if (intbig_sign(ahdl) == 0)
	intbig_sign(result) = 0;

    else
    {
	intbig_sign(result) = 1;

	if (ahdl != result)
	{
	    inthdl_length   alen;

	    alen = intbig_curr_size(ahdl);
	    intbig_copy_digits(ahdl, 0, alen, result, 0);
	    intbig_curr_size(result) = alen;
	}
    }
}
