#include "defs.h"
#include "integer.e"

/*
 * QUICKERSORT, CACM Algorithm 271, Vol 8 1965, pp 669-670 [1988: not sighted]
 *
 * Recoded from the Old Stackhandler Fortran as recursive C functions by
 * Tim Docker and Jim Richardson, April 1988
 *
 * Note that this is sh_sortst adapted to use infinite precision integer
 * comparisions.
 *
 * John Brownie, August 1989
 *
 * Because each recursion cuts the stack to be sorted into two almost equal
 * segments, recursion depth is limited to about log2 of the number of items.
 *
 * For recursion efficiency, the following data are declared as static, i.e.,
 * accessible to all functions in this file:
 */

static t_handle	sort_hdl;
static t_int	sort_item;

/*
 * Internal subroutine declared as private to this file also.
 */

Private Void	sort_recur();

Void
integer_sort_list(hdl)
t_handle	hdl;
{
	/*  Copy into globals  */

	sort_hdl = hdl;

	/* Sort the whole stack */

	sort_recur(1, sh_items(hdl));
}

Private Void
sort_recur(lo, hi)
t_int	lo;
t_int	hi;
{
	register t_int	p, q, k;
	register Logical	swapped;
	/*
	 * Sort the segment of the stack between items lo and hi inclusive
	 * (always called with lo <= hi)
	 */

	for (;;)  /*  this outer loop is used for "tail recursion": see end  */
	{
		/*  If there are only one or two items to sort it is easy  */

		if (hi - lo <= 1)
		{
			if (lo < hi && integer_compare(sh_fitem(sort_hdl, lo), sh_fitem(sort_hdl, hi)) > 0)
				sh_swapit(sort_hdl, lo, sort_hdl, hi);
			return;
		}

		/*
		 * Since the stack contains more than two items, choose index p
		 * to split it into two halves.  If each of these halves is
		 * already approximately sorted, this is a bad choice:
		 * p = (lo+3*hi)/4 or p=random(lo,hi) would be better.
		 */

		p = (lo + hi) / 2;

		sort_item = sh_fitem(sort_hdl, p);
		sh_moveit(sort_hdl, lo, sort_hdl, p);

		q = hi;

		/* Find an item k greater than sort_item */

		for (k = lo + 1; k <= q; k++)
		{
			if (integer_compare(sh_fitem(sort_hdl, k), sort_item) > 0)
			{
				/*
				 * Having found an item k greater than
				 * sort_item, search items above it from the
				 * highest down for one less than sort_item
				 */

				swapped = FALSE;

				for (; q >= k; q--)
					if (integer_compare(sh_fitem(sort_hdl, q), sort_item) < 0)
					{
						/*
						 * Having found such an item q,
						 * swap items q and k
						 */

						sh_swapit(sort_hdl, k, sort_hdl, q);
						q--;

						/* Find another pair to swap */
						swapped = TRUE;
						break;
					}

				if (!swapped)
				{
					q = k - 1;
					break;
				}
			}
		}

		/* Arrive here when upward and downward searches meet */

		sh_moveit(sort_hdl, q, sort_hdl, lo);
		sh_sitem(sort_hdl, q, sort_item);

		/*
		 * The segment of the stack has been split into 3 parts, the
		 * middle part consisting of one element q which is now in its
		 * correct final position.  Perform recursion on the other two
		 * segments, treating the smaller first (why?).
		 */

		if (2 * q > lo + hi)
		{
			sort_recur(q + 1, hi);

			/*
			 * Now simulate the "tail recursion" sort_recur(lo, q-1)
			 * using the outer for(;;) loop: this saves an actual
			 * recursive call
			 */

			hi = q - 1;
		}
		else
		{
			sort_recur(lo, q - 1);

			/*  Simulate sort_recur(q+1, hi)  */

			lo = q + 1;
		}

	}  /*  end of for(;;)  */
}
