/*
integer_shift.c
*/

#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"


integer_big
integer_shift_right WITH_3_ARGS(
	inthdl_handle,	x,
	inthdl_length,	digits,
	inthdl_length,	bits
)
/*
Returns x shifted right by the specified number of digits and bits.
*/
{
    inthdl_handle	xhdl, yhdl;

    if (integer_is_single(x))
    {
	if (digits)
	    return 0;

	return (x >> bits);
    }

    xhdl = inthdl_big_to_handle(x);
    yhdl = inthdl_buf_alloc(intbig_curr_size(xhdl));
    inthdl_shift_right(xhdl, yhdl, digits, bits);

    return inthdl_standardize(yhdl);
}


integer_big
integer_shift_left WITH_3_ARGS(
	inthdl_handle,	x,
	inthdl_length,	digits,
	inthdl_length,	bits
)
/*
Returns x shifted left by the specified number of digits and bits.
*/
{
    inthdl_handle	xhdl, yhdl;

    if (integer_is_single(x))
    {
	if (x == 0 || digits == 0 && x < (1 << (ZETA - bits)))
	    return (x << bits);

	xhdl = inthdl_buf_alloc_1(x);
    }
    else
	xhdl = inthdl_big_to_handle(x);

    yhdl = inthdl_buf_alloc(intbig_curr_size(xhdl) + digits + 1);
    inthdl_shift_left(xhdl, yhdl, digits, bits);

    if (integer_is_single(x))
	inthdl_buf_delete(xhdl);

    return inthdl_standardize(yhdl);
}


void
integer_shift_right_maximal	WITH_3_ARGS(
	integer_big,		x,
	integer_big *,		yptr,
	t_int *,	nptr
)
/*
Sets *yptr and *n such that x = *yptr * 2^(*nptr) where *nptr is maximal.
*/
{
    if (integer_is_single(x))
    {
	if (x == 0)
	{
	    *yptr = 0;
	    *nptr = 0;
	}
	else
	{
	    t_int	n = 0;

	    while ((x & 1) == 0)
		n++, x >>= 1;

	    *yptr = x;
	    *nptr = n;
	}
    }
    else
    {
	inthdl_handle	xhdl;
	inthdl_length	i, j;
	t_int	d;

	xhdl = inthdl_big_to_handle(x);

	i = 0;
	while ((d = intbig_digit(xhdl, i)) == 0)
	    i++;

	j = 0;
	while ((d & 1) == 0)
	    j++, d >>= 1;

	*yptr = integer_shift_right(x, i, j);
	*nptr = i * ZETA + j;
    }
}
