/*  integer_mult.c
*/

#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"


integer_big
integer_mult    WITH_2_ARGS(
    integer_big, aint,
    integer_big, bint
)
/*
** Given two big integers aint and bint, return their product
*/
{
    block_declarations;
    integer_big prod;
    inthdl_handle   result;
    t_int   carry;
    inthdl_handle   ahdl;
    inthdl_handle   bhdl;

    DEBUG_INTEGER_2("+integer_mult", aint, bint);

    if (aint == 0 || bint == 0)
	result = 0;

    else if (aint == 1)
	result = integer_incref(bint);

    else if (bint == 1)
	result = integer_incref(aint);

    else if (integer_is_single(aint))
    {
	if (integer_is_single(bint))
	{
	    /*
	    aint and bint are both single-precision
	    */
    
	    t_int	sign;

	    if (aint < 0)
	    {
		aint = -aint;
		sign = -1;
	    }
	    else
		sign = 1;

	    if (bint < 0)
	    {
		bint = -bint;
		sign = -sign;
	    }

	    ib_mult(aint, bint, &carry, &prod);
    
	    if (carry == 0)
		result = sign * prod;
	    else
		result = inthdl_handle_to_big(
				inthdl_alloc_2(sign * prod, sign * carry)
			    );
	}
	else
	{
	    bhdl = inthdl_big_to_handle(bint);
	    result = inthdl_buf_alloc(intbig_curr_size(bhdl) + 1);
	    inthdl_mult_beta(bhdl, aint, result);

	    result = inthdl_standardize(result);
	}
    }
    else if ((ahdl=inthdl_big_to_handle(aint)), integer_is_single(bint))
    {
	result = inthdl_buf_alloc(intbig_curr_size(ahdl) + 1);
	inthdl_mult_beta(ahdl, bint, result);
	result = inthdl_standardize(result);
    }
    else
    {
	/*
	a and b are both multi-precision
	*/

	bhdl = inthdl_big_to_handle(bint);

	result = inthdl_buf_alloc(intbig_curr_size(ahdl) +
			       intbig_curr_size(bhdl));

	inthdl_mult(ahdl, bhdl, result);
	result = inthdl_standardize(result);
    }

    DEBUG_INTEGER_1("-integer_mult", result);

    return result;
}
