#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"


integer_big
integer_long_random WITH_1_ARG(
    t_int,    n
)
/*
Return a random integer in the range 0 to 2^n - 1
*/
{
	register t_int	nrands;
	register t_int	templength;
	inthdl_handle		reshdl;
	register t_int	i;
	register t_int	temp;

#define mod_2_to_the_n(x, n)	((x) & ((1 << (n)) - 1))

	if (n <= ZETA)
	{
	    /* Result is single-precision */
	    return mod_2_to_the_n(utl_rand_num(1), n);
	}

	nrands = n / ZETA;
	DEBUG_INTEGER((".nrands =",1,nrands));

	reshdl = inthdl_buf_alloc(nrands + 1);
	intbig_sign(reshdl) = 1;

	for (i = 0; i < nrands; i++)
	    intbig_digit(reshdl, i) = utl_rand_num(1) & BETA_MASK;

	if (n %= ZETA)
	{
	    intbig_digit(reshdl, nrands) = mod_2_to_the_n(utl_rand_num(1), n);
	}
	else
	    nrands--;

	while (intbig_digit(reshdl, nrands) == 0)
	    nrands--;

	intbig_curr_size(reshdl) = nrands + 1;

	return inthdl_standardize(reshdl);
}
