#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"

integer_small
integer_jacobi_symbol   WITH_2_ARGS(
    integer_big,    d,
    integer_big,    n
)
/*
 * Given integers d and n, n odd and (d,n) = 1, return the value of
 * the Jacobi symbol (or the Legendre symbol if n is prime) (d/n).
 *
 * Algorithm taken from H. Riesel, Prime Numbers and Computer Methods
 * for Factorization (Birkauser, 1985)
 */
{
    block_declarations;

    register integer_big    d1;
    register integer_big    n1;
    register integer_small  m;
    register integer_small  n8;
    register integer_big    i2;
    integer_big     t1;
    integer_big     t2;

    integer_incref( d );
    d1 = d;

    n1 = integer_abs(n);

    m = 0;

    n8 = integer_rem(n, 8);

    if (n8 % 2 == 0)
    {
	/*
	 * n was even
	 */

	integer_delref( d1 );
	integer_delref( n1 );

	return 0;
    }

    if (integer_sign(d1) < 0)
    {
	t1 = integer_negate( d1);
	integer_delref( d1 );
	d1 = t1;			/* transfer from t1 to d1 */

	if (n8 == 3 || n8 == 7)
	    m++;
    }

    do
    {
	if (integer_sign(d1) == 0)
	{
	    /*
	     * d and n were not coprime
	     */

	    /* integer_delref( d1 ) where d1 == 0 */
	    integer_delref( n1 );
	    return 0;
	}

	i2 = 0;
	integer_quot_rem(d1, 2, &t1, &t2);

	/* note that t2 equals 0 or 1 during the loop */

	while (t2 == 0)
	{
	    i2++;
	    integer_delref( d1 );
	    d1 = t1;			/* transfer from t1 to d1 */

	    integer_quot_rem(d1, 2, &t1, &t2);
	}

	integer_delref( t1 );
	if (i2 % 2 == 1)
	    m += (n8 * n8 - 1) / 8;
	t2 = integer_rem(d1, 4);
	m += (n8 - 1) * (t2 - 1) / 4;


	i2 = integer_rem(n1, d1);
	integer_delref( n1 );
	n1 = d1;		/* transfer from d1 to n1 */

	d1 = i2;		/* transfer from i2 to d1 */

	n8 = integer_rem(n1, 8);
    }
    while (integer_compare(n1, 1) > 0);

    integer_delref( n1 );
    integer_delref( d1 );

    if (m % 2 == 0)
	return 1;
    else
	return -1;
}
