#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"
#include "dyn_arr.e"
#include "dyn_arr.h"
#include "faclst.e"
#include "faclst.h"
#include "error.e"


integer_big
integer_e_p_with_factors WITH_1_ARG(
faclst,		factors
)
/* 
** Given the factorisation of an integer n, return euler phi(n).
**
** Algorithm taken from H. Riesel, Prime Numbers and Computer Methods
** for Factorization (Birkhauser, 1985).
*/
{
    block_declarations;

    register t_int  i;
    register t_int  nfacts;
    register integer_big    p;
    register t_int  a;
    register integer_big    pa;
    register integer_big    p1;
    register integer_big    phi;
    register integer_big    new_phi;
    register integer_big    temp;


    nfacts = faclst_num_prime( factors );
    phi = 1;
    for (i = 0; i < nfacts; i++)
    {
	p = faclst_prime( factors, i );		/* alias */
	a = faclst_expon( factors, i );		/* alias */

	pa = integer_power( p, a-1 );
	p1 = integer_subtract( p, 1 );
	temp = integer_mult( pa, p1 );
	integer_delref( pa );
	integer_delref( p1 );

	new_phi = integer_mult( phi, temp );
	integer_delref( phi );
	integer_delref( temp );
	phi = new_phi;		/* transfer */
    }

    return phi;
}

integer_big
integer_euler_phi WITH_1_ARG(
integer_big,    n
)
/*
** Given a general integer n, return the value of the Euler phi
** function for n.
** Front end to integer_e_p_with_factors. 
*/
{
    block_declarations;

    faclst                  factors;
    dyn_arr_handle          remainders;
    Logical                 proof;
    integer_big    	    phi;

    proof = 1;      /* require probable prime factors to be proven prime */
    integer_lst_factorise( n, &factors, &remainders,
	10, 1000, 1023, 10, 500, 3, 100, n, proof );

    if (remainders != 0)
    {
	faclst_delete( &factors );
	dyn_int_arr_delete( &remainders );
	error_runtime(ERR_COULD_NOT_FACTOR_ARG, 1);
    }

    phi = integer_e_p_with_factors(factors);

    faclst_delete( &factors );
    return phi;
}
