#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"

void
integer_euclid  WITH_7_ARGS(
    t_int,    x,
    t_int,    y,
    t_int *,  gcd,
    t_int *,  s,
    t_int *,  t,
    t_int *,  u,
    t_int *,  v
)
/*
** computes the gcd = gcd(x,y) and
** integers s and t such that
** gcd = x*s + y*t
** 0  = x*u + y*v
** and s*v - u*t = 1.
** initialize the euclidean iteration algorithm.
*/
{
    t_int       a[2 + 1];
    t_int       c[2 + 1];
    t_int       d[2 + 1];
    register t_int  j;
    register t_int  k;
    register t_int  q;
    register t_int  r;

    a[0] = x;
    a[1] = y;
    c[0] = 1;
    c[1] = 0;
    d[0] = 0;
    d[1] = 1;

    j = 0;
    /*
     * the loop.
     * at each stage we have    a(j) = c(j)*x + d(j)*y
     */

    for (;;)
    {
	k = 1 - j;
	q = a[j] / a[k];
	r = a[j] - q * a[k];
	c[j] = c[j] - q * c[k];
	d[j] = d[j] - q * d[k];
	a[j] = r;
	if (r == 0)
	    break;
	j = k;
    }

    /*
     * we have finished.
     */

    *gcd = a[k];
    *s = c[k];
    *t = d[k];

    if (j != 0)
    {
	*u = c[j];
	*v = d[j];
	return;
    }

    /*
     * make sure determinant is one.
     */

    *u = -c[j];
    *v = -d[j];
}
