/*  debug.c
*/

#ifdef DEVELOP

#include "defs.h"

#define	INTBIG_MASTER_DEBUG_DEF	1
#include "integer.e"

#include "inthdl.e"

#include "intbig.h"

#if 0
#include	"bh_call_back_defs.h"
#endif


static int intbig_debug_indent_level = 0;	/* current indentation level */

/*  Number of spaces of indentation per level:  */

#define INDENT_MULTIPLE	2

/*  Pointer to empty string and Pair of arguments for "%*s" format item  */

static char Empty_String[] = "";

#define Indent_Spaces	\
	(intbig_debug_indent_level * INDENT_MULTIPLE), Empty_String


void
integer_debug_initialize()
/*
(Re-)initialize integer debugging by setting indentation to zero
(may be necessary after a restart)
*/
{
    intbig_debug_indent_level = 0;
}


void
intbig_debug_msg(msg)
char	*msg;
/*
Set indentation level according to first character of the msg argument
(+ = post-increment, - = pre-decrement; anything else = no change), and
display the message suitably indented.
*/
{
    switch(*msg)
    {
	case '+':
	    mem_info_message("%*s%s", Indent_Spaces, msg);
	    intbig_debug_indent_level++;
	    break;

	case '-':
	    if (--intbig_debug_indent_level < 0)
		intbig_debug_indent_level = 0;
	    /* then fall through to ... */

	default:
	    mem_info_message("%*s%s", Indent_Spaces, msg);
    }
}



static void
inthdl_debug_dump(a)
inthdl_handle a;
{
    int i;

    if (a == 0)
    {
	mem_info_message(" [ZERO HANDLE]");
	return;
    }

    mem_info_message(" [HANDLE %d, SIGN %d, LENGTH %d, AVAIL %d { ",
	    a, intbig_sign(a), intbig_curr_size(a), intbig_avail_size(a));
   
    if (intbig_sign(a))
    {
	for (i = 0; i < intbig_curr_size(a); i++)
	    mem_info_message("%d ",intbig_digit(a, i));
    
	if (intbig_curr_size(a) > intbig_avail_size(a))
	    mem_info_message("ERROR *** curr_size > avail_size ***");
    }

    mem_info_message("}]");
}

void
integer_debug(msg, nbig)
char *msg;
int   nbig;
/*
Debug printout: display the message, followed by nbig (zero or more)
integer_bigs
*/
{
DIE();
#if 0
    va_list	ap;
    integer_big	arg;

#ifdef	DO_NOT_USE_PROTOTYPES
    char *msg;
    int nbig;

    va_start(ap);

    msg = va_arg(ap, char *);
    nbig = va_arg(ap, int);
#else

    va_start(ap, nbig);

#endif

    intbig_debug_msg(msg);

    while (nbig-- > 0)
    {
	arg = va_arg(ap, integer_big);
	if (integer_is_single(arg))
	    mem_info_message(" [SINGLE = %d]", arg);
	else
	    inthdl_debug_dump(inthdl_big_to_handle(arg));
    }

    va_end(ap);

    mem_info_message("\n");
#endif
}


void
inthdl_debug(msg, nhdl)
char *msg;
int   nhdl;
/*
Debug printout: display the message, followed by nhdl (zero or more)
inthdl_handles
*/
{
DIE();
#if 0
    va_list	ap;
    integer_big	arg;

#ifdef	DO_NOT_USE_PROTOTYPES
    char *msg;
    int nhdl;

    va_start(ap);

    msg = va_arg(ap, char *);
    nhdl = va_arg(ap, int);
#else

    va_start(ap, nhdl);

#endif

    intbig_debug_msg(msg);

    while (nhdl-- > 0)
	inthdl_debug_dump(va_arg(ap, inthdl_handle))

    va_end(ap);

    mem_info_message("\n");
#endif
}

void
inthdl_debug_beta	WITH_3_ARGS(
    char *,		msg,
    inthdl_handle,	h,
    t_int,	b
)
/*
Debug printout: display the message then one inthdl_handle and one beta-digit
*/
{
    intbig_debug_msg(msg);
    inthdl_debug_dump(h);
    mem_info_message(" [BETA-DIGIT = %d]\n", b);
}


#ifndef	INTBIG_NO_SANITY_CHECKS

/*  The following prevents crhead from generating a prototype:  */

#define crhead_private

crhead_private inthdl_length
intbig_digit_error	WITH_2_ARGS(
    inthdl_handle,	h,
    inthdl_length,	k
)
{
    mem_info_message(
	"intbig error: attempt to access digit %d of t_handle %d\n", k, h);
    mem_info_message("length %d, avail %d", intbig_curr_size(h),
	intbig_avail_size(h));
    return k;
}

crhead_private void
intbig_debug_copy_digits	WITH_5_ARGS(
    inthdl_handle,	srchdl,
    inthdl_length,	srcpos,
    inthdl_length,	len,
    inthdl_handle,	dsthdl,
    inthdl_length,	dstpos
)
{
    if (dsthdl == srchdl && dstpos != srcpos)
	mem_info_message("intbig error: handles same but positions differ\n");
    if (srcpos + len > intbig_avail_size(srchdl))
	mem_info_message(
	    "intbig error: trying to copy FROM beyond end of digit\n");
    else if (dstpos + len > intbig_avail_size(dsthdl))
	mem_info_message(
	    "intbig error: trying to copy TO beyond end of digit\n");
    else
	return;

    mem_info_message(
	"FROM hdl %d, pos %d, avail %d\n",
	srchdl, srcpos, intbig_avail_size(srchdl));

    mem_info_message(
	"TO   hdl %d, pos %d, avail %d,\n length = %d",
	dsthdl, dstpos, intbig_avail_size(dsthdl), len);
}

#endif	/*  INTBIG_NO_SANITY_CHECKS  */

#endif
