#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"

void
ib_gcd_mult     WITH_5_ARGS(
    int,     adig,
    int,     bdig,
    int *,   gcd,
    int *,   mult1,
    int *,   mult2
)
/*
** Input:  adig, bdig - beta-digits
** Output: gcd is the gcd of adig and bdig.  mult1 and mult2 are
** beta-digits such that mult1 * adig + mult2 * bdig = gcd.
*/
{
    register int    a;
    register int    b;
    register int    c;
    register int    d;
    register int    p;
    register int    q;
    register int    r;
    register int    s;
    t_int   even;

    a = adig;
    b = bdig;
    p = 0;
    q = 1;
    r = 1;
    s = 0;
    even = 1;
    while (a % b != 0)
    {
	if ((a < 0 && b >= 0) || (a >= 0 && b < 0))
	{
	    c = (a >= 0 ? a : -a) / (b >= 0 ? b : -b);
	    c = -c;
	}
	else
	    c = a / b;
	d = b;
	b = a % b;
	a = d;
	if (even)
	{
	    p += c * q;
	    r += c * s;
	}
	else
	{
	    q += c * p;
	    s += c * r;
	}
	even = !even;
    }
    *gcd = b;
    if (even)
    {
	*mult1 = -s;
	*mult2 = q;
    }
    else
    {
	*mult1 = r;
	*mult2 = -p;
    }
}
