#include "dyn_arr.h"

t_void
dyn_arr_copy_data(h1, offset1, h2, offset2, count)
dyn_arr_handle h1, h2;
t_int   offset1, offset2, count;
{
    t_int   k;
    t_dyn_arr *p1, *p2;

    /*
	Copy count elements from h1[offset1] to h2[offset2].  No checking
	is done that this will be valid.  The current lengths are not
	changed.

	If we are copying within the same dynamic array, we have to be
	careful how we copy, so as to avoid clobbering data.
    */

    if (h1 == h2 && offset1 < offset2)
    {
	p1 = dyn_arr_elt0_ptr(h1) + offset1 + count;
	p2 = dyn_arr_elt0_ptr(h2) + offset2 + count;
	for (k = count; k > 0; k--)
	    *--p2 = *--p1;
    }
    else
    {
	p1 = dyn_arr_elt0_ptr(h1) + offset1;
	p2 = dyn_arr_elt0_ptr(h2) + offset2;
	for (k = count; k > 0; k--)
	    *p2++ = *p1++;
    }
}
