
#include "defs.h"
#include "integer.e"
#include "q.h"
#include "comp.e"
#include "mp.e"
#include "mp.h"
#include "conv.e"


t_comp
conv_q_to_comp WITH_2_ARGS(
	t_handle,		r,
	rational,	a
)
/*
** Returns the complex number correspoding to the rational a.
*/
{
	t_comp		b;
	mp_float	bre, bim;

	b = comp_alloc( real_base, comp_beta_prec(r) );

	/* split the complex number into 2 mp-floats */
	comp_split_mp( b, bre, bim );

	conv_q_to_mp( a, bre );
	mp_int_to_mp( 0, bim );

	return b;
}

