
#include "defs.h"
#include "comp.e"
#include "real.e"
#include "mp.e"

t_real
comp_arg WITH_2_ARGS(
	t_handle,		r,
	t_comp,		x
)
/*
** Returns Arg( x ), in range (-pi, pi].
*/
{
	mp_float	xre, xim;
	mp_float	yf;

	comp_split_mp( x, xre, xim );
	yf = mp_alloc( real_base, comp_beta_prec( r ));
	mp_atan2( xim, xre, yf );

	return mp_to_real( yf );
}

