#include "mem.h"

t_int f_mem_words FL1(h)
t_handle	h;
/*
Return the number of user words of the block associated with h.
*/
{
    t_ptr	bp;

    CHECK_HANDLE("mem_words", h);
    TRACE("mem_words", h, MEM_BYTES(h));

    HNORMALIZE(h);
    bp = HANDLE_ACCESS(h);
    return PTRS_TO_UWORDS(NEXT_BLOCK(bp) - bp - HEADER_SIZE);
}

t_int f_mem_bytes FL1(h)
t_handle	h;
/*
Return the number of user words of the block associated with h.
*/
{
    t_ptr	bp;

    CHECK_HANDLE("mem_bytes", h);

    HNORMALIZE(h);
    bp = HANDLE_ACCESS(h);
    return PTRS_TO_BYTES(NEXT_BLOCK(bp) - bp - HEADER_SIZE);
}

t_mem_word *f_mem_access(h, UFILE, ULINE)
t_handle	h;
char		*UFILE;
int		ULINE;
/*
Return a pointer to the beginning of the block associated with h.
*/
{
    CHECK_HANDLE("mem_access", h);
#if 0
    TRACE("mem_access", h, MEM_BYTES(h));
#endif

    STATS(memi_stats_access++);
    HNORMALIZE(h);
    return (t_mem_word *)HANDLE_ACCESS(h);
}

#ifdef DEVELOP
int *ma(h)
{
    return (int *)f_mem_access(h, "debugging junk", 1);
}
#endif
