/******************************************************************************
  vec_real_orthogonal_proj.c
******************************************************************************/
#include "kant.h"

vector
vec_real_orthogonal_proj WITH_3_ARGS (
	t_handle,	rrng,
	matrix,		mat,
	vector,		vec
)
/******************************************************************************
 
Description:	Computes the orthogonal projection of vec into
		<b1,...,bk>. b1,...,bk are the columns of a 
		matrix and must be orthonormal.
 
Calling sequence:
 
	p = vec_real_orthogonal_proj(rrng,mat,vec)

	vector		p	: the orthogonal projection of vec into <b1,...,bk>
	t_handle	rrng	: the real ring of the coefficients
	matrix		mat	: see above
	vector		vec	: see above
 
History:
 
	92-06-25 KW	mat_ring_add
	92-06-03 KW	mat must be orthonormal
	92-05-08 KW	written
 
******************************************************************************/
{
	block_declarations;

	integer_small	i,col,row;
	t_real		tempu;
	vector		v,tempa,tempb,tempc;

	col = mat_col(mat);
	row = mat_row(mat);

/*
**	Initialize v
*/
	v = vec_new(row);
	for (i=1;i<=row;i++) vec_entry(v,i) = ring_zero(rrng);

/*
**	Compute projection
*/
	for (i=1;i<=col;i++)
	{
		tempa = mat_ring_col_to_vector(rrng,mat,i);
		tempu = vec_ring_dot_product(rrng,tempa,vec);
		tempb = mat_ring_scalar_left_mult(rrng,tempu,tempa);
		tempc = v;
		v = mat_ring_add(rrng,v,tempb);
		real_delete(&tempu);    
		vec_delete(rrng,&tempa);
		vec_delete(rrng,&tempb);
		vec_delete(rrng,&tempc);
	}
	return(v);
}	
