/******************************************************************************
  order_units_logs_calc.c
******************************************************************************/

#include "kant.h"
#include "real.e"
#include "mat.e"
#include "anf.h"
#include "lattice.h"

void
order_units_logs_calc WITH_1_ARG(
	order,		ord
)
/*******************************************************************************
 
Description:

	Computes the logarithms of the absolute values of the conjugates
	of the unit system given.

  
Calling sequence:
 
	order_units_logs_calc(ord);
 
      	order         	ord     = t_handle of order 
 
 
History:
 
	92-04-24 JS/KW lat_chol_ring
	92-03-31 JS    Log-lattice (and dimension now r_1+r_2)
	92-03-24 JS    anf_elt_logs_mat
	91-10-01 JS    written
  
*******************************************************************************/
{
	block_declarations;
 
	integer_small	i, r12, cnt;
	t_handle		reals;
	matrix		mat;
	lattice		lat;
                                       
 
	cnt   = order_units_count(ord);
 
	if (cnt)
	{
		r12   = order_r1(ord) + order_r2(ord);
		reals = order_reals(ord);
		mat   = mat_new(r12, cnt);
	 
		for (i=1; i<=cnt; ++i)
			anf_elt_logs_mat(ord, order_unit(ord, i), mat, i);
	 
		order_units_logs(ord) = mat;
 
		if (anf_print_level > 2)
		{
			printf("\n");
			puts("Logs of units:");
			mat_real_write(reals, mat);
			printf("\n");
		} 
 
/*
    now creating the log lattice
*/
 
                lat = lat_create();
                lat_rank(lat)  = cnt;
                lat_basis(lat) = mat_incref(mat);
                lat_basis_ring(lat) = ring_incref(reals);
                lat_chol_ring(lat)  = ring_incref(reals);
 
                order_units_log_lat(ord)     = lat;
                order_units_log_lat_env(ord) = lat_enum_create(lat);
	}
 
	return;
}
