/******************************************************************************
  order_units_delete.c
******************************************************************************/
 
#include "kant.h"
#include "real.e"
#include "mat.e"
#include "anf.h"
#include "lattice.h"

void
order_units_delete WITH_1_ARG(
	order,		ord
)
/*******************************************************************************
 
Description:
 
        Deletes all data of an order referring to units,
        excluding the torsion unit subgroup.
   
Calling sequence:
 
	order_units_delete(ord);

	order	ord	= order under consideration
   
History:
     
        93-02-11 MD     torsion unit added
	92-05-07 JS     first version
  
*******************************************************************************/
{
	block_declarations;
 
	t_handle		reals;
        integer_small   i;
         
        for(i=1; i<=order_units_count(ord); i++)
                anf_elt_delete(ord, &order_unit(ord,i));
 
        if (order_unit_basis(ord)) dyn_arr_delete(&order_unit_basis(ord));
            
	if (order_reals(ord) != MEM_NH)
	{
		reals = order_reals(ord);
 
		if (order_units_logs_known(ord))
                {         
			mat_delref(reals, &order_units_logs(ord));
                        lat_enum_delete(order_units_log_lat(ord),       
                                        &order_units_log_lat_env(ord));
                        lat_delete(&order_units_log_lat(ord));
                }
	 

		if (order_reg_known(ord))
			real_delete(&order_reg(ord));
	}                                 
/*
        if (order_torsion_unit_known (ord))                       
        {
          anf_elt_delete (ord,&order_torsion_unit(ord));
          order_torsion_rank (ord) = 0;
        }  
*/

 
	return;
}
