#include "kant.h"
#include "dyn_arr.h"
#include "anf.h"

void
order_mult_table_alloc WITH_1_ARG(
	order,		ord
)
/*******************************************************************************
 
order_mult_table_alloc.c
 
JS August 1991   
Last modification: 26.09.91
 
Allocating space for the multiplication table of an order basis
This routine also sets the matrix dimensions to the relative extension degree
and initializes all values to zero.
 
*******************************************************************************/
{
	block_declarations;
 
	integer_small	deg;
	order		ordcoef;
	integer_small	k;
 
 
	deg = order_rel_degree(ord);
	ordcoef = order_coef_order(ord);
 
/*
    allocating space for the table itself
*/
 	order_mult_table(ord) = dyn_arr_alloc(deg);
 
/*
    setting the dimensions of the matrices and initializing them
*/
 	for (k=1; k<=deg; ++k) 
	    order_mult_matrix(ord, k) = mat_ring_create_zero(ordcoef, deg);
 
	return;
}
