/******************************************************************************
  order_lll_reduce.c                                                           
******************************************************************************/

#include "kant.h"

order
order_lll_reduce WITH_1_ARG(
	order,		ord
)
/*******************************************************************************
 
Description:
 
       This routine performs LLL reduction on the conjugate lattice basis
       of ord. This is recommended to keep numbers small in subsequent
       computations. If the real values of ord are not known they are
       computed automatically.
 
 
Calling sequence:
 
	ordlll = order_lll_reduce(ord);
 
      	order       ord   = t_handle of order to reduce
      
 
History:
 
	92-03-10 JS    first version
 
*******************************************************************************/
{
	block_declarations;
	
	order		ordlll;
        matrix          matl, trans, transi;
        t_handle          R, Z;
  
/*
    we need the real basis of ord
*/
        order_reals_assure(ord);
 
        R = order_reals(ord);
 
/*
   LLL reduction
*/
 
        matl = 0; trans = 0;
        lll_real_d_reduce(R, order_basis_real(ord), 0.75, &matl, &trans);
        transi = mat_real_to_mat_z(R, trans);
        mat_delref(R, &trans);
        mat_delref(R, &matl);

/*
   Transformation
*/
 
        ordlll = order_trans(ord, transi, 1);
 
/*
   end
*/

	Z = m_z_str_incref(structure_z);
        mat_delref(Z, &transi);
        ring_delete(&Z);
 
        return ordlll;
}
