/******************************************************************************
  order_lat.c
******************************************************************************/
#include "kant.h"
#include "mat.h"
#include "anf.h"
#include "lattice.h"  


void
order_lat WITH_3_ARGS (
	order,		ord,
	lattice*,	lat,
	lat_enum_env*,	env
)

/******************************************************************************
 
Description:	Initialisation of a lattice and an appropriate enumeration
		enviroment. The basis of the new lattice is the real basis
		of the passed order.

Calling sequence:
 
		order_lat(ord,&lat,&env)

		order		ord	= t_handle of order
		lattice		lat	= t_handle of the new lattice
		lat_enum_env	env	= t_handle of the new enumeration env

History:
 
        93-02-02 MJ/KW  chol ring setting
	92-06-05 JS     order_reals_assure
	92-05-29 KW	discriminant
	92-02-12 KW	written
 
******************************************************************************/
{
	block_declarations;

	t_real	temp1,temp2;
 
        order_reals_assure(ord);

	*lat = lat_create();
	
	lat_rank(*lat) = order_abs_degree(ord);

	lat_basis(*lat) = mat_incref(order_basis_real(ord));

	lat_basis_ring(*lat) = ring_incref(order_reals(ord));
	lat_chol_ring(*lat) = ring_incref(order_reals(ord));

	if ((order_r2(ord) == 0)
	 && (ring_type(order_coef_order(ord)) == RING_Z)
	 && (order_mult_table_known(ord))
	 && (order_rel_degree(ord)  == order_abs_degree(ord)))
	{
/*
* 		Save Z and beware of R (ord is totally real).
*/

		lat_gram(*lat) = order_trace_mat(ord);
		lat_gram_ring(*lat) = ring_incref(order_coef_order(ord));
	}

	if (order_disc_known(ord))
	{
		lat_disc_ring(*lat) = ring_incref(order_reals(ord));
		temp1 = conv_int_to_real(order_reals(ord),order_disc(ord));
		temp2 = real_abs(order_reals(ord),temp1);
		lat_disc(*lat) = real_sqrt(order_reals(ord),temp2);
		real_delete(&temp1);
		real_delete(&temp2);
	}		

	*env = lat_enum_create(*lat);
}	
