/******************************************************************************
  order_delete.c
******************************************************************************/
 
#include "kant.h"

void 
order_delete WITH_1_ARG(
        order*, ord
)
/*******************************************************************************
 
Description:
 
	Deletes an order.
	The order is delreffed. This routine takes care of the fact that there
        might be recursive references between this order and its quotient
        field.
 
Calling sequence:
 
	order_delete(&ord)

	order	ord	= order to be deleted
 
History:
 
	92-09-09 JS     resorting of orders of anf_order(ord)
	92-06-04 JS     Fincke related data
	92-05-12 JS     fac_basis, relation_matrix, subfield_orders
	92-04-02 JS     order_mult_table_delete
	92-03-31 MD	deletion of units changed
	92-03-20 JS	class group
	92-03-19 JS	using order_reals_delete
	92-03-12 JS	deletion of dyn_arrays containing order_units
	92-03-05 KW	minor changes
	91-11-?? KW	written
 
*******************************************************************************/
{
        block_declarations;
         
        anf             ord_anf;
        order   	ord_coef;
        integer_small   deg;     
        integer_small   i, j, count;
        t_handle        pring,  Z;

        integer_small      rc;

        /* Anzahl rc der Referenzen auf *ord ermitteln */

        rc = block_ref_count(*ord);

        ord_anf = order_anf(*ord);          

        /* 1.Fall : rc > 2 --> Referenzzaehler der Ordnung reduzieren 
           2.Fall : rc = 2 und kein algebraischer Zahlkoerper --> wie 1.Fall
           3.Fall : rc = 1 --> Speicher fuer die Ordnung freigeben
           4.Fall : rc = 2 und algebraischer Zahlkoerper --> wie 3.Fall und Referenz auf *ord
                                                             im alg. Zahlkoerper loeschen
        */

        if ((rc > 2) || ((rc == 2) && (ord_anf == MEM_NH)))
        {
                block_decref_delete(*ord);
        }
        else
        {      
	        ord_coef = order_coef_order(*ord);
	        deg = order_rel_degree(*ord);                
 
                /* Shifting orders in table of the anf and delreffing it */

                if (ord_anf != MEM_NH) 
                {
                        i = 1; 	
                        while (anf_order(ord_anf,i) != *ord) i++;
			count = anf_order_count(ord_anf);
                        for (; i<count; i++) anf_order(ord_anf, i) = anf_order(ord_anf, i+1);
                        anf_order_count_set(ord_anf, count-1);
                        anf_delete(&ord_anf);
			block_decref_delete(*ord);
                }

                /* now all subfield orders */
 
                if (count = order_subfield_order_count(*ord))
                {
			for (i=1; i<=count; ++i)
                        {
                                ring_delete(&order_subfield_order(*ord, i));
                                vec_delete(*ord, &order_subfield_order_basis(*ord, i));
	                        if (order_subfield_order_con_tran_known(*ord, i))
                                   mat_delref(order_reals(*ord),&order_subfield_order_con_tran(*ord, i));
                        }       
	                dyn_arr_delete(&order_subfield_order_info(*ord));
                }
 
                /* how is the order given? */
 
                if (order_poly(*ord) != MEM_NH)
		{
			pring = poly_str_create(ord_coef, 1);
                        poly_elt_delete(pring,&order_poly(*ord));
			poly_str_delete(0, &pring);
		}
 
                if (order_basis_is_rel(*ord))
                {
                        mat_delref(ord_coef,&order_tran(*ord));
                        mat_delref(ord_coef,&order_invtran(*ord));
                        
                        integer_delref(order_tran_den(*ord));
                        integer_delref(order_index(*ord));
                        
                        ring_delete(&order_suborder(*ord));
                }
                
                if (order_basis_is_pure(*ord))
                        anf_elt_delete(ord_coef,&order_pure_gen(*ord));
 
                if (order_basis_is_table(*ord))
                {
                        for(i=1;i<=deg;i++)
                        {
                                anf_elt_delete(order_basis_table_order(*ord,i),&order_basis_table_anf_elt(*ord,i));
                                ring_delete(&order_basis_table_order(*ord,i));
                        }
                }

                /* discriminant */
 
                if (order_disc_known(*ord)) integer_delref(order_disc(*ord));
                        
                /* multiplication table */
 
                order_mult_table_delete(*ord);

                /* units */
 
                for(i=1;i<=order_units_count(*ord);i++)
                        anf_elt_delete(*ord,&order_unit(*ord,i));
 
                if (order_unit_basis(*ord)) dyn_arr_delete(&order_unit_basis(*ord));

                /* torsion unit subgroup */

                if (order_torsion_unit_known(*ord))
                        anf_elt_delete(*ord,&order_torsion_unit(*ord));
                               
                /* class group structure */
 
                if (order_class_group_structure_known(*ord) &&
                    order_class_number(*ord) != 1)
   		{
                        count = order_class_group_order(*ord);
                        for (i=1; i<=count; ++i)
                                integer_delref(order_class_group_factor_order(*ord, i));
                        dyn_arr_delete(&order_class_group_structure(*ord));
                        count = order_class_group_gen_count(*ord);
                        for (i=1; i<=count; ++i)
                                anf_ideal_delete(*ord, &order_class_group_gen(*ord, i));
                        dyn_arr_delete(&order_class_group_gens(*ord));
                        Z = m_z_str_incref(structure_z);
                        mat_delref(Z, &order_class_group_genexps(*ord));
                        ring_delete(&Z);
                }
 
                if (order_class_number_known(*ord))
                        integer_delref(order_class_number(*ord));
 
                /* factor basis stuff */
 
                order_fac_basis_delete(*ord);
                order_relation_delete(*ord);
 
                if (order_fincke_rbounds_known(*ord))
                {
                        Z = m_z_str_incref(structure_z);
                        vec_delete(Z, &order_fincke_rbounds(*ord));
                        ring_delete(&Z);
                }
                      
                /* now the rest... */
 
		ring_delete(&ord_coef);
 
                order_reals_delete(*ord);
        
        
                structure_parent_delete( *ord );
                structure_remove( *ord ); 
                mem_delete_hptr(ord);  

        }
}
