/******************************************************************************
  order_create.c
******************************************************************************/
 
#include "kant.h"
#include "structure.e"
#ifndef KANT
#include "alg.e"
#endif
 
extern anf_elt		anf_mult();
extern anf_elt		anf_add();
extern anf_elt		anf_negate();
extern anf_elt		anf_inverse();
/*
extern anf_elt		anf_power();
extern anf_elt		anf_subtract();
extern integer_small	anf_compare();
*/

order
order_create WITH_4_ARGS(
	anf,		field,
	order,		ordcoef,
	integer_small,	deg,
	integer_small,	poly_pos
)
/*******************************************************************************
 
Description:
 
	Allocates space for an order over an algebraic number field
	and initializes some particular values (if submitted)
 
	This routine has three tasks: 
	  - to provide sufficient space for the table which describes an order
	  - to initialize certain values for this order 
	  - to set the generic arithmetic operations which refer to this type of ring
 
	No multiplication table will be initialized. For this the user should
	call order_mult_assure.
	In addition, no real values of the order will be computed.
        Call order_reals_create in this case.
                                             
   
Calling sequence:
 
	ord = order_create(anf, ordcoef, deg, poly_pos);
 
	field (if not 0):	A t_handle to the quotient field of the new order. 
				The signature of the field is copied and a 
				link is set via order_anf.
 
	ordcoef (if not 0):	A t_handle to the coefficient order of the new order.
				(May be overruled by poly_pos)
 
	deg (if > 0):		The relative degree of the extension of ordcoef.
				(May be overruled by poly_pos)
 
	poly_pos (if not 0): 	This refers to the tables of minimal polynomials 
				of the quotient field (if > 0: polynomials over Z, 
				in the other case polynomials over orders). 
				It is assumed that the order basis is power basis 
				given in terms of a zero of the polynomial. 
				In this case the relative degree and coefficient
				order are set according to the polynomial data. 
 
	Example:
	ord = order_create(fld, 0, 0, 1)
	creates the equation order for the first Z-polynomial in the table of field.
                                                                                    
 
History:
 
	92-06-04 JS	Fincke macros
	92-05-05 JS	factor basis and relation matrix
	92-03-19 JS	class group, subfields
	91-10-21 JS	minor changes
	91-08-10 MB/JS	first version
 
*******************************************************************************/
{
	block_declarations;
	

	order		ord, ordcoef1;
	integer_small   deg1, cnt;
	t_poly       poly;
	t_handle		polh;
	t_handle		pring;
 
/*
    allocating space
*/
	ord = structure_alloc(sizeof(t_order_table),RING_BLOCK_TYPE, 1, REP_ORDER, FALSE);
	ring_put_type(ord, RING_ORDER); 
/* 
    Initialization of data if necessary
*/
	if (field)
	{
		order_anf(ord) 		= anf_incref(field);
		order_abs_degree(ord) 	= anf_abs_degree(field);
		order_r1(ord) 		= anf_r1(field);
		order_r2(ord) 		= anf_r2(field);
		order_r(ord) 		= anf_r(field);
  
                cnt = anf_order_count(field); cnt++;
		anf_order_count_set(field, cnt);
		anf_order(field, cnt) = order_incref(ord);
 
		if(poly_pos)
		{
			order_set_basis_is_power(ord);
			order_one_position(ord) = 1;
 
			if(poly_pos < 0)
			{       
			   poly     = anf_poly_order_poly (field,-poly_pos);
			   polh     = m_poly_poly_to_handle(poly);
			   ordcoef1 = anf_poly_order_order(field,-poly_pos);
			   pring = poly_str_create(ordcoef1, 1);
			   order_poly(ord) = poly_elt_incref(pring, poly);
			   poly_str_delete(0, &pring);
			   order_coef_order(ord) = ring_incref(ordcoef1);
			   order_rel_degree(ord) = 
			   		m_poly_expt(polh, m_poly_nterms(polh)-1);
			}
			else
			{
			   poly     = anf_poly_z_poly (field, poly_pos);
			   polh     = m_poly_poly_to_handle(poly);
			   ordcoef1 = m_z_str_incref(structure_z);
			   order_poly(ord) = m_poly_z_incref(structure_pring_z, poly);
			   order_coef_order(ord) = ordcoef1;
			   order_rel_degree(ord) = 
			   		m_poly_expt(polh, m_poly_nterms(polh)-1);
			}
			order_mult_table(ord) = MEM_NH;
		}
		else
		{
			order_rel_degree(ord) = (deg > 0)
						? deg
						: -1;
			order_coef_order(ord) = (ordcoef != 0)
						? ring_incref(ordcoef)
						: 0;
			order_mult_table(ord) = MEM_NH;
		}
	}
	else
	{
		    	order_anf(ord) = MEM_NH;
			order_rel_degree(ord) = (deg > 0)
						? deg
						: -1;
			order_coef_order(ord) = (ordcoef != 0)
						? ring_incref(ordcoef)
						: MEM_NH;
			order_mult_table(ord) = MEM_NH;
	}
 
	order_pure_gen(ord) 		= MEM_NH;
	order_disc(ord)           	= MEM_NH;
	order_reals(ord)          	= MEM_NH;
	order_basis_real(ord)   	= MEM_NH;
	order_basis_real_inv(ord) 	= MEM_NH;
	order_unit_basis(ord)     	= MEM_NH;
	order_units_logs(ord)     	= MEM_NH;
	order_torsion_unit(ord)   	= MEM_NH;
	order_torsion_rank(ord)   	= 0;
	order_reg(ord)            	= MEM_NH;
 
        order_class_number(ord)   	= MEM_NH;
        order_class_group_structure(ord)= MEM_NH;
        order_class_group_gens(ord)	= MEM_NH;
        order_class_group_genexps(ord)	= MEM_NH;
 
        order_subfield_order_info(ord)	= MEM_NH;
 
        order_fac_basis(ord)		= MEM_NH;
        order_relation_mat(ord)		= MEM_NH;
        order_relation_numbers(ord)	= MEM_NH;
        order_relation_trans_mat(ord)	= MEM_NH;
        order_relation_trans_mat(ord)	= MEM_NH;
        order_relation_status(ord)	= 0;
        order_relation_count(ord)	= 0;
 
        order_fincke_gamma1(ord) 	= MEM_NH;
        order_fincke_lambda(ord) 	= MEM_NH;
 
	if order_abs_degree(ord) 
		order_fincke_rbounds_alloc(ord);
        else
                order_fincke_rbounds(ord) = MEM_NH;
    
	return ord;
}
