/*******************************************************************************
  is_index_divisor.c 
********************************************************************************/



#include "kant.h"


t_logical is_index_divisor WITH_2_ARGS (order      , ord,
                                      integer_big, prime)
/*******************************************************************************
Description:
   
    Checks whether or not the prime "prime" divides the index of [ord:Main].
    Main is the equation order of the field.
    

Calling sequence:
                                                           
          order       ord   :  The order start has to be the ring of integers 
                               of a number field.
                               
          integer_big prime :  The upper bound for the norm of the ideals that 
                               will be stored 
          t_logical     OK    : return value.

      Ok = is_index_divisor (ord,prime);

                            
History:                                 
           

   MD 09.04.92    written                    

********************************************************************************/
{
	block_declarations;       
  
        order           suborder;

        integer_big     index,rem;                                   
        t_logical         value;         
                 

   if (order_basis_is_power (ord))  /* The index of the equation order is 1 */
                                    /* so every prime is certainly not an   */
                                    /* index divisor.                       */
   {
     return FALSE;
   }
   else                                                                      
     if (order_basis_is_rel (ord)) 
     {                       
       index = order_index (ord);
       rem   = integer_rem (index,prime);                        
    
       if ((rem = integer_rem (index,prime))== 0)
         value = TRUE;
       else
         {
           suborder = order_suborder (ord);
           value    = is_index_divisor (suborder,prime); 
         }

       integer_delref (rem);

       return value;
     }
     else  
       error_internal ("IS_INDEX_DIVISOR : Can`t compute index");

                            
}

