#include "kant.h"
#include "integer.e"
#include "dyn_arr.e"
#include "faclst.h"
#include "faclst.e"

t_logical
integer_is_squarefree WITH_1_ARG(integer_big, d)

/*********************************************************************************

Description:
        Returns true if d is squarefree ( or it is not known), 
        Returns false if d = a * b^2 , b>1.


Calling sequence: 

        L = integer_is_squarefree( d );

        integer_big     d = t_handle to number
        t_logical         L = TRUE or FALSE      


History:

	92-07-08 JPS written 
        92-07-10 MJ  Making shure that the number to factorise is 
                     positve
	92-09-11 AIS written
*********************************************************************************/
{
	block_declarations;
	t_logical	res, succ;
	t_integer	x, y;

	succ = integer_squarefree(d, 0, &x, 0, &y, 0);
	if (!succ)
		return TRUE;
	
	res = (y == 1);
	integer_delref(x);
	integer_delref(y);
	return res;
}
