/*******************************************************************************
  anf_rdisc_factors_get.c
********************************************************************************/
    


#include <stdio.h>
#include "kant.h" 
#include "anf.h" 
#include "faclst.e" 
#include "faclst.h"
#include "poly_z_faclst.h"

void 
anf_rdisc_factors_get WITH_2_ARGS (anf           ,  field,
                                   integer_small ,  no)
/*******************************************************************************

Description:                                                   
	Returns the factorisation of the reduced discriminant of  
	the given alg. number field.                            
                                                   

Calling sequence:


            anf            field      : The red. discriminat of this field will
                                        be factorised.      
            
            integer_small  no         : The number of the polynomial that
                                        will be used.


       anf_rdisc_factors_get (field,no);

History:

 	92-06-05 JS    slightly changed output
	MD 92-04-15    first version
 
********************************************************************************/
{
	block_declarations;         

        faclst          factors;                              


	integer_big	rdisc;
        dyn_arr_handle  rem;



  if (anf_poly_z_rdisc_known(field, no))
    rdisc  = integer_abs(anf_poly_z_rdisc (field,no));
  else      
    {
      anf_rdisc_calc(field,no);
      rdisc  = integer_abs(anf_poly_z_rdisc(field,no));
    }
#ifndef KANT
  integer_lst_factorise(rdisc, &factors, &rem, 10, 1000, 1023, 10, 500, 3, 100, rdisc, 1);
#else
  integer_lst_factorise   (rdisc, &factors, &rem, 50, 1000, 262144, 0, 0, 0, 0, rdisc, 0);
#endif
   
  if (anf_print_level >0)
  {
    printf("Factorization of reduced discriminant: ");
    faclst_print(factors); 
    if (rem) puts(" ... with a composite remainder ... ");
  }
                         
  anf_poly_z_rdisc_fac (field,no) = factors;
                

  integer_delref(rdisc);

  if (rem)                  
    dyn_arr_delete (&rem);

  return;
}


