/******************************************************************************
  anf_rdisc_calc.c
******************************************************************************/
 
#include "kant.h"
#include "real.e"
#include "mat.e"
#include "poly.e"
#include "anf.h"
#include "conv.e"

 

void
anf_rdisc_calc WITH_2_ARGS(
	                    anf           , field,
                            integer_small , no
)
/*******************************************************************************
 
Description:

Computes the reduced discriminant of an alg. number field (defined by the
polynomial no in the list of polynomials).
 
  
Calling sequence:
        
      	anf           field      = t_handle of alg. num. field 
        integer_small no         = no of pol. in list.

	anf_rdisc_calc(field,no);
 
 

History:                                 
                                                             
 	92-10-04 MD    first version

*******************************************************************************/
{
	block_declarations;
        
        integer_big     rdisc;
        t_poly       polynomial;


  polynomial = anf_poly_z_poly (field,no);
  rdisc = poly_z_red_discriminant(structure_pring_z, polynomial);
  anf_poly_z_rdisc (field,no) = rdisc;

}
 
