#include "kant.h"
#include "integer.e"
#include "anf.h"


anf_elt
anf_negate WITH_2_ARGS(
	order,		ord,
	anf_elt,	alpha
)
/*******************************************************************************
 
anf_negate.c
 
JS September 1991                                               Version 24.09.91
 
Negates alpha (recursively, if necessary)

*******************************************************************************/
{
	block_declarations;
 
	integer_small	deg;
        order		ordcoef;
	anf_elt		beta;
	integer_small	i;
  
         
	if (anf_elt_is_integer(alpha)) 	return integer_negate(alpha);
 
       	deg = order_rel_degree(ord);
        ordcoef = order_coef_order(ord);
 
	anf_elt_alloc(beta, deg);
	anf_elt_den(beta) = anf_elt_incref(anf_elt_den(alpha));
 
	if (ring_type(ordcoef) == RING_Z) 
	{
		for (i=1; i<=deg; ++i)
			anf_elt_coef(beta, i) = 
				integer_negate(anf_elt_coef(alpha, i));
	}
	else
	{
		for (i=1; i<=deg; ++i)
			anf_elt_coef(beta, i) = 
				anf_negate(ordcoef, anf_elt_coef(alpha, i));
	}
 
	return beta;
}
