#include "kant.h"




t_logical
anf_ideal_is_principal WITH_3_ARGS (order      , ord   ,
                                    anf_ideal  , ideal ,
                                    anf_elt*   , gamma  )
/*******************************************************************************
 
Description:
 
          Checks whether or not a given ideal is principal and depending on the
          result true or false is returned.
          If the ideal is principle a generator is returned in gamma.
                                  

 
Calling sequence:
 
 
      	order  	        ord      = t_handle of an order 
        anf_ideal       ideal    = checked ideal. 

        anf_elt         gamma    = generator of ideal (if one ex.)
	t_logical         is_princ = return value 
                                                                  

          is_princ = anf_ideal_is_principal(ord,ideal,&gamma);
 
History:
 
	92-06-21 MD     written
 
*******************************************************************************/
{      


             block_declarations;

             dyn_arr_handle      list;

             integer_big         K,den;
             t_logical             is_princ,find_all = FALSE;

                                 
           
  anf_ideal_norm (ord,ideal,&K,&den);

  if (den != 1)
    error_internal ("ANF_IDEAL_IS_PRINCIPLE : Ideal is fractional ");
                                          
  anf_ideal_norm_equation (ord,ideal,K,gamma,&list,find_all);

  if (*gamma == MEM_NH) 
    is_princ = FALSE;
  else
    is_princ = TRUE;
  

  integer_delref (K);
  

  return is_princ;

}
