/******************************************************************************
  anf_ideal_divide_out_ideal.c
******************************************************************************/
 
#include "kant.h"        


anf_ideal
anf_ideal_divide_out_ideal WITH_3_ARGS(
	order,		ord,
	anf_ideal,	id1,
	anf_ideal,	id2
)
/*******************************************************************************
 
Description:
             
	Computes an ideal "remainder" so that
		id1 = remainder * id2^const
	and id2 does not divide remainder.
	If id2 does not divide id1 ( const = 0 ),
	the function returns id1 as remainder.

Calling sequence:
 
        anf_ideal_divide_out_ideal(ord, id1, id2);
 
        order   	ord:        order over which id1 and id2 are defined
        anf_ideal       id1:	    ideal to be divided
        anf_ideal       id2:	    divisor ideal
 
History:

	92-12-21 CO     first version

*******************************************************************************/
{       
	block_declarations;
 
	anf_ideal	inverse, remainder, hlp;
	integer_big	norm, den;

	inverse = anf_ideal_invert_integral( ord, id2 );
	remainder = anf_ideal_incref( id1 );
	anf_ideal_norm( ord, remainder, &norm, &den );
	anf_ideal_2_assure( ord, remainder);


	while( ( anf_elt_in_ideal( ord, anf_ideal_gen1( remainder ), id2 ))
	    && ( anf_elt_in_ideal( ord, anf_ideal_gen2( remainder ), id2 ))
	    && ( integer_compare( norm, 1 ) == 1 ) )
	{
	    hlp = remainder;
	    integer_delref( norm );
	    integer_delref( den );

	    remainder = anf_ideal_mult( ord, hlp, inverse );
	    anf_ideal_norm( ord, remainder, &norm, &den );
	    anf_ideal_2_assure( ord, remainder);

	    anf_ideal_delete( ord, &hlp );
	}
	integer_delref( norm );
	integer_delref( den );
	anf_ideal_delete( ord, &inverse );

	anf_ideal_simplify( ord, &remainder );
	return ( remainder );
}
