/******************************************************************************
  anf_ideal_alloc.c
******************************************************************************/
 
#include "kant.h"
#include "anf.h"

anf_ideal
anf_ideal_alloc WITH_NO_ARGS(
)
/*******************************************************************************
 
Description:
 
	Allocating space for an ideal of an order in an algebraic number field
 
	The task of this routine is to allocate sufficient space for the table
	which describes a fractional ideal of an algebraic number field. 
	On exit, the user is provided with a t_handle to the ideal.
 
        Usually, this routine should not be used directly. 
        Use but anf_ideal_*_create instead.
 
  
Calling sequence:
 
	id = anf_ideal_alloc();

	anf_ideal	id	= created ideal (empty)

History:
 
	91-09-01  JS    first version
 
*******************************************************************************/
{
	anf_ideal	id;

	id = mem_alloc_zero(sizeof(anf_ideal_struct));
 
	block_init(id, ANF_IDEAL_BLOCK_TYPE);

	anf_ideal_gen_g(id)     = 0;
	anf_ideal_tran(id)      = MEM_NH;
	anf_ideal_tran_hnf(id)  = 0;
	anf_ideal_min(id)       = 0;

	return id;
}
