/******************************************************************************
  anf_ideal_2_normal_check.c
******************************************************************************/
 
#include "stdio.h"        
#include "kant.h"
#include "anf.h"

t_logical
anf_ideal_2_normal_check WITH_2_ARGS(
	order,		ord,
	anf_ideal,	id
)
/*******************************************************************************
 
Description:
             
	Checks if the 2-Element-Presentation of the integer
	ideal id is normal.

	If the first generator of id is a negative integer,
	it will be changed to its absolute value.
	If we find out that id is normal, the "flag"
	anf_ideal_gen_g( id ) may be changed.
  
Calling sequence:
 
        anf_ideal_2_normal_check(ord, id);
 
        order   	ord:        order over which id is defined
        anf_ideal       id:	    integer ideal to be checked
 
History:

	93-01-04 CO	anf_ideal_2_assure (l.101)
	92-06-11 CO     first version

*******************************************************************************/
{       
	block_declarations;
 
	integer_big	m, gcd, dum1, dum2;
	integer_small   ok;
	anf_elt		a;
	anf_ideal	alpha_princ;
 
	order_must_be_over_z(ord);

	if( !anf_ideal_is_integral( ord, id ))
		error_internal("anf_ideal_2_normal_check: Ideal is not integral.");

	if( anf_print_level > 6 )
	{
		printf("\n ideal before normal_check =");
		anf_ideal_2_write( ord, id );
		printf("\n g =");
		integer_write( anf_ideal_gen_g(id));puts("");
	}

/******* Trivial cases : no 2-Elem.-Presentation given		 *******/
/*******   or   the set referring to which a normal presentation *******/
/*******        is given has been set <> 1 (this can be inter-   *******/
/*******        preted as flag and means that we already have a  *******/
/*******	2-Element-Normal-Presentation )			 *******/
/*******   or   first generator is not an integer at all         *******/
 
	if( !anf_ideal_is_2( id ) )
		return 0;

	if ( integer_compare( anf_ideal_gen_g(id), 1 ) == 1 )
		if ( !anf_elt_equal( ord, anf_ideal_gen1(id), anf_ideal_gen_g(id) ) )
			error_internal("anf_ideal_2_normal_check: first generator <> g_set");
		else
			return 1;

	else  /* case anf_ideal_gen_g = 1   or   < 0  */
	{
		if ( !anf_elt_is_integer( anf_ideal_gen1(id) ) )
			return 0;

/******* Take absolut value of the first generator.              *******/

		if ( integer_compare( anf_ideal_gen1( id ), 0 ) == -1 )
		{
			dum1 = integer_negate( anf_ideal_gen1( id ));
			anf_elt_delete( ord, &anf_ideal_gen1( id ));
			anf_ideal_gen1( id ) = dum1;
		}
                                   
/******* Standard case : we check if                             *******/
/*******							 *******/
/*******	     anf_ideal_min( alpha_princ )		 *******/
/*******   gcd ( a, ---------------------------------------- = 1 *******/
/*******	     gcd( anf_ideal_min( alpha_princ ), a ) 	 *******/
/*******							 *******/
/******* with a = first generator of id and alpha_princ = prin-  *******/
/******* cipal ideal generated by the second generator of id.    *******/


		a = anf_elt_incref( anf_ideal_gen1( id ));
		alpha_princ = anf_elt_to_princ_ideal( ord, anf_ideal_gen2(id) );
		anf_ideal_2_assure( ord, alpha_princ );
	/* we use 2_assure because the (first) generator of */
	/* alpha_princ must be > 0 !                        */
		anf_ideal_min_assure( ord, alpha_princ );
		m = anf_ideal_min( alpha_princ );

		gcd = integer_gcd( m, a );
		integer_quot_rem( m, gcd, &dum1, &dum2 );
		integer_delref( gcd );
		gcd = integer_gcd( dum1, a );
		if ( integer_compare( gcd, 1 ) == 0 ) /*** gcd = 1 ***/
		{
			ok = 1;                                        
			integer_delref( anf_ideal_gen_g(id) );
			anf_ideal_gen_g(id) = integer_incref( a );
		}
		else
			ok = 0;

		if( anf_print_level > 5 )
		{
			printf("\nanf_ideal_2_normal_check: min =");
			integer_write( m);puts("");
			printf("\n gcd =");
			integer_write(gcd);puts("");
		}

		integer_delref( dum1 );
		integer_delref( gcd );
		anf_ideal_delete( ord, &alpha_princ );
		anf_elt_delete( ord, &a );

		return ok;
	}
}
