/******************************************************************************
  anf_ideal_2_create.c
******************************************************************************/
 
#include "kant.h"
#include "mat.h"
#include "anf.h"

anf_ideal
anf_ideal_2_create WITH_3_ARGS(
	order,  	ord,
        anf_elt,	alpha,
	anf_elt,	beta
)
/*******************************************************************************
 
Description:
 
	Creates the ideal given by the transformation matrix trans and the
        denominator den. It is assumed that the ideal is not given in any
        normal presentation.
 
  
Calling sequence:
 
	id = anf_ideal_2_create(ord, alpha, beta);
                                                                       
        order           ord     = order over which id will be defined
	anf_elt	        alpha   = first generator
	anf_elt	        beta    = second generator
	anf_ideal	id	= created ideal in Z-basis presentation

History:
 
	92-03-17  JS    first version
 
*******************************************************************************/
{
	block_declarations;         
 
	anf_ideal	id;
 
        id = anf_ideal_alloc();
 
	anf_ideal_gen1(id)  = anf_elt_incref(alpha);
	anf_ideal_gen2(id)  = anf_elt_incref(beta);
	anf_ideal_gen_g(id) = 1;
 
	return id;
}
