/******************************************************************************
  anf_elt_read.c                                                           
******************************************************************************/
 
#include "stdio.h"        
#include "kant.h"
#include "anf.h"


anf_elt
anf_elt_read WITH_1_ARG(
	order,		ord
)
 
/*******************************************************************************
 
Description:
 
	Reads an algebraic number. 
	This (preliminary) version is NOT compatible to anf_write, every
	anf_elt must be given with all coefficients and denominator.
	Only small numbers are supported without any '(', ')', or '/'.
	 
	Planned: This routine should be compatible with anf_elt_write.

 
Calling sequence:
 
	gamma = anf_elt_read(ord);
 
      	order       ord      = t_handle of order 
      	anf_elt     gamma    = algebraic number read
                               (referring to basis of ord)
      
 
History:
 
	91-09-26 JS    minor changes
	91-08-31 JS    written
 
*******************************************************************************/
{
	block_declarations;
 
	anf_elt		alpha;
	integer_small	deg;
        order		ordcoef;
	integer_small	i, onepos;
	integer_big	denom;
	integer_big	a;
 

	if(ring_type(ord) == RING_Z) 
	{
		scanf("%d", &alpha);
		return alpha;
	}

        deg = order_rel_degree(ord);
        ordcoef = order_coef_order(ord);
        onepos  = order_one_position(ord);
 
	anf_elt_alloc(alpha, deg);
 
        for (i=1; i<=deg; ++i)
		anf_elt_coef(alpha, i) = anf_elt_read(ordcoef);
 		
	scanf("%d", &denom);
	anf_elt_den(alpha) = denom;
                                   
	if (ring_type(ordcoef) == RING_Z && onepos == 1 && denom == 1)
	{
		for (i=2; i<=deg; ++i)
		{
			if (anf_elt_coef(alpha, i)) return alpha;
		}
		a = integer_incref(anf_elt_coef(alpha, 1));
		anf_elt_delete(ord, &alpha);
		return a;
		
	}
	else
	{
		return alpha;
	}
	
}
