(define (magic-eval exp)
  (scheme->subeval (eval exp user-initial-environment)))

(define (scheme->subeval obj)
  (cond ((null? obj) nil-builtin)  ;;;REVISED: () to nil-builtin
        ((list? obj)
	 (cons '<<list>> (map scheme->subeval obj)))
	((pair? obj)
	 (list '<<cons>>
	       (scheme->subeval (car obj))
	       (scheme->subeval (cdr obj))))
	((procedure? obj)
         (install-system-constant! obj))  ;REVISED
	((symbol? obj)
	 `(quote ,obj))
	((equal? obj (cond))
	 undefined-value)
	((boolean? obj) obj)
        ((number? obj) obj)
        ((string? obj) obj)
        (else
         (sm-error
          "scheme->subeval: unrepresentable object" obj))))
        
(define (install-system-constant! obj)     ;REVISED
  (let ((name (get-next-fresh-proc-name)))
    (eval `(define ,name ,obj) user-initial-environment)
    (add-to-functional-constants! name)
    name))                              ;REVISED

(define (get-next-fresh-proc-name)
  (add-angle-brackets (next-symbol 'system-procedure)))

(define (add-angle-brackets name)
  (string->symbol
   (string-append
    "<<"
    (symbol->string name)
    ">>")))

(define (add-to-functional-constants! name) ;REVISED
  (set! functional-constants
        (cons name functional-constants))
  (set! alternate-functional-constants
        (cons name alternate-functional-constants)))
