#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine Menu (X, Y, Numpt, NumCrv, term, done)


*****************************************************************
*                                                               *
*      Subroutine Plotting_Menu                                 *
*                                                               *
*        This subroutine displays a list of options from        *
*        which the user is able to interactively enter          *
*        labels for the axis, specify the window size,          *
*        the number of simultaneous curves to be plotted,       *
*        the terminal type used, number of tick marks to be     *
*        displayed, and other such options.                     *
*                                                               *
*****************************************************************


        Integer         max, num, maxC
        Common /Object/ max, num, maxC
        Save   /Object/

        Integer  gigi, vt240R, vt240T, tek, sun, ibmPC
        Parameter (gigi = 1, vt240R = 2, vt240T = 3, tek = 4, sun = 5,
     +            ibmPC = 6)

        Real       X(max, num), Y(max, num)
        Integer    NumCrv, Numpt(num), term, CrvTyp(3), NumTic(2), 
     +		     choice, fid
        Logical    shadng, intpl, done

C Variable names added for hardcopy abilitiy to LN03
     	 Character*10 fname
     	 Integer status 
     	 logical exist

        Data Numtic /0,0/
        Data  CrvTyp/1,1,1/
        Data shadng, intpl/.false.,.false./

*       (* Initialize the parameters to their default value. *)
        Call init(term, shadng, intpl)

    1   Call Clear(term)
        Write (*,10)
   10   Format (/15x,'Plot Menu',//
     +         ,5x,'Please choose one of the following options:',//
     +         ,10x,'1.  Plot Data',19x,'8.  Select Color',//
     +         ,10x,'2.  Specify Window',14x,'9.  Select Shading'//
     +         ,10x,'3.  Specify Plot Type',10x,'10.  Choose Terminal',
     +              ' Type',//
     +         ,10x,'4.  Specify Line Type',10x,'11.  Debug Data',//
     +         ,10x,'5.  Interpolate Data',11x,'12.  Help!',//
     +         ,10x,'6.  Select Tic Marks',11x,'13.  Input New Data',//
     +         ,10x,'7.  Select Labels',14x,'14.  Hardcopy File',//
     +         ,30x,'15.  Quit XY PLOTTER'/)
        Write (*,20)
   20   Format (5x,'Enter option (1 - 15) ... ')
        Read (*,'(i4)',err=1) choice

  100   IF (choice .NE. 13 .AND. choice .NE. 15) THEN
          IF (choice .EQ. 1) THEN
	     fid = 6
            IF (intpl) THEN
              Call Crvpl (X, Y, Numpt, Numcrv, term, CrvTyp, NumTic,
     +                   shadng, fid)
            ELSE
              Call Plot (X, Y, Numpt, NumCrv, term, CrvTyp, NumTic,
     +                  shadng, fid)
            ENDIF
          ELSE IF (choice .EQ. 2) THEN
            Call WinVew(term)
          ELSE IF (choice .EQ. 3) THEN
            Call Curve(CrvTyp, term, NumCrv)
          ELSE IF (choice .EQ. 4) THEN
            Call LineTp(term, NumCrv)
          ELSE IF (choice .EQ. 5) THEN
            Call Interp(term, intpl)
          ELSE IF (choice .EQ. 6) THEN
            Call Ticks(NumTic, term)
          ELSE IF (choice .EQ. 7) THEN
            Call Label(term)
          ELSE IF (choice .EQ. 8) THEN
            Call Color(term, NumCrv)
          ELSE IF (choice .EQ. 9) THEN
            Call Shade(term, shadng)
          ELSE IF (choice .EQ. 10) THEN
            Call Clear(term)
            Call Termcp(term)
          ELSE IF (choice .EQ. 11) THEN
            Call Debug(X,Y,Numpt,NumCrv,term)
          ELSE IF (choice .EQ. 12) THEN
            Call Online(term)
          ELSE IF (choice .EQ. 14) THEN
C
C The following code was added to let the user generate a tektronix
C file.  This enables the user to send the "ln03.graph" file to the
C ln03 laser printer.
C			  Van Rauch (University of New Mexico) 10/1/86.
C
C It was then modified to allow the user to leave multiple graphs 
C in their home directory.
C                   Patrick M. Kelly
C
C Check for existence of the old graph file
            fname = 'ln03.graph'
C
            inquire(file=fname,exist=exist)
C
 450        if (exist) then
 490          call clear(term)
              write (*,500) fname
 500          format (/3x,'File "',a,'" exists ...  Would you like',
     +                ' to'//,3x,'1)  Write over old file',/3x,
     +                '2)  Save graph under different file name',
     +                //)
              read (*,'(i1)',err=490) choice
C
 510          if (choice .LT. 1 .OR. choice .GT. 2) then
                call clear(term)
                write (*,500) fname
                read (*,'(i1)',err=490) choice
                goto 510
              endif
C
              if (choice .EQ. 1) then
	 	    close(unit = 3)
                exist = .FALSE.
              elseif (choice .EQ. 2) then
 515            write (*,520)
 520            format (/3x,'Please enter filename (max = 10 chars)',
     +                   '...'/)
                read (*,'(a)',err=515) fname
                inquire(file=fname,exist=exist)
              endif
              goto 450
            endif
C end of mod for check for existence of old graph file
	     fid = 3
	     open (unit = 3, file = fname, status = 'new')
	     rewind (unit = 3)
            IF (intpl) THEN
              Call Crvpl (X, Y, Numpt, Numcrv, vt240T, CrvTyp, NumTic,
     +                   shadng, fid)
            ELSE
              Call Plot (X, Y, Numpt, NumCrv, vt240T, CrvTyp, NumTic,
     +                  shadng, fid)
            ENDIF
            close(unit = 3)
          ELSE
            Write (*,'(a1)') Char(7)
          ENDIF

    2     Call Clear(term)
          Write (*,10)
          Write (*,20)
          Read(*,'(i4)',err=2) choice

          GOTO 100
        ENDIF

        IF (choice .EQ. 15) THEN
          done = .true.
        ENDIF

        RETURN
        END
