/* ras2raw.c  --  routine to remap a raster file from color (through its */
/*                color map) to grayscale and out put it as a raw byte   */  
/*                file.                                                  */
/* includes: main */

/* depends on: ReadRasterFile, WriteRasterFile, ExtractLuminance */

/* version 2.0     14 Jan 93 */

/* by Richard Alan Peters II                       */
/* Department of Electrical Engineering            */
/* Vanderbilt University School of Engineering     */ 
/* Nashville, TN 37235                             */ 
/* rap2@vuse.vanderbilt.edu                        */ 
/*                                                 */ 
/* This software is freely redistributable if      */ 
/* the author's name and affiliation are included. */


#include "stdio.h"
#include "malloc.h"
#include "rasterio.h"



main( argc, argv )
   unsigned int argc;
   char * argv[];
   {
   char *Img;
   char *CMap;
   struct rasterfile RasHd;	/* raster file header */

   /* check args */
   if ( argc > 1  && argv[1][0] == '?' )
      {
      fprintf(stderr, "usage:  ras2raw  < In  > Out\n");
      exit(0);
      }

   /* read the input image into memory */
   if ( ReadRasterFile( stdin, &RasHd, &CMap, &Img, 0, 0, 0, 0, ALLOC ) ) 
      exit(0);

   /* remap the image */
   ExtractLuminance( &RasHd, CMap, Img, 0, 0, 0, 0 );

   /* write out raw image */  
   if ( fwrite( Img, sizeof(char), RasHd.ras_width * RasHd.ras_height, stdout ) 
        != RasHd.ras_width * RasHd.ras_height )
      {
      fprintf(stderr,"Error writing output image\n");
      exit(0);
      }

   }




 
