/* m3dmanip.c  --  3d morphology image manipulation procedures */

/* contains: AllocBuf(), DeAllocBuf(), BlockMove(), ScrollBuf() */

/* dependencies: none */ 

/* morph3d version 4.0  1 June 1993                */
/* 3D image morphology program                     */
/*                                                 */
/* by Richard Alan Peters II                       */
/* Department of Electrical Engineering            */
/* Vanderbilt University School of Engineering     */
/* Nashville, TN 37235                             */
/* rap2@vuse.vanderbilt.edu                        */
/*                                                 */
/* This software is freely redistributable if      */
/* the author's name and affiliation are included. */

#include "morph3d_sub.h"


/* allocate and initalize (to zeros) either a single buffer or a buffer list */

byte **AllocBuf( X, Y, Z, psize )
   int  X,Y;    /* buffer horizontal, vertical dimensions */
   int  Z;      /* number of buffers in list (if 0 make 1 buffer, no list) */
   int  psize;  /* number of bytes per pixel */
   {
   byte **Buf;  /* buffer list */
   int k;       /* index */

   if ( Z == 0 )    /* allocate a single buffer */
      {
      if ( !(Buf = (byte **)calloc( X*Y, psize )) )
         {
         fprintf( stderr, "AllocBuf: Unable to allocate standalone buffer.\n" );
         exit( 0 );
         }
      }
   else        /* allocate a buffer list */
      {
      if ( !(Buf = (byte **)calloc( Z, sizeof(byte *) )) )
         {
         fprintf( stderr, "AllocBuf: Unable to allocate buffer list.\n" );
         exit( 0 );
         }
      for ( k=0; k<Z; ++k )
         {
         if (!(*(Buf+k) = (byte *)calloc( X*Y, (psize==WORDPX ? 2 : 1))))
            {
            fprintf( stderr, "AllocBuf: Unable to allocate buffer %d.\n", k );
            exit( 0 );
            }
         }
      }
   return(Buf);
   }




/* free the memory allocated by AllocBuf */

void DeAllocBuf( Buf, N )
   byte **Buf;    /* buffer list */
   int  N;        /* number of buffers in list (if 0 make 1 buffer, no list) */
   {
   int k;

   if ( Buf == NULL )
      {
      return;
      }
   else if ( N == 0 )    /* deallocate a single buffer */
      {
      free( Buf );
      return;
      }
   else        /* deallocate a buffer list */
      {
      for ( k=0; k<N; ++k )
         {
         free( *(Buf+k) );
         }
      free( Buf );
      }
   return;
   }




/* Move a w by h block of pixels starting at location (x,y) in  */
/* image S (which is sX by sY) to location (u,v) of image D     */ 
/* which is dX by dY pixels (horizontal by vertical) in size.   */
/* Either block may be 1 or two bytes per pixel.                */

void BlockMove( S, sB, sX, sY, x, y, w, h, D, dB, dX, dY, u, v )
   byte *S;       /* source image */
   int   sB;      /* bytes per pixel in source image */
   int   sX,sY;   /* source img. horizontal, vertical, dimensions */
   int   x,y;     /* source image offset */
   int   w,h;     /* dims of block to copy */
   byte *D;       /* destination image */
   int   dB;      /* bytes ber pixel in dest. image */
   int   dX, dY;  /* destination img. horiz., vert. dims. */
   int   u,v;     /* dest. image offset */
   {
   int i,j;       /* indicies */
   word p;        /* pixel value */
   byte *IB,*OB;  /* byte image pointers */
   word *IW,*OW;  /* word image pointers */


   if ( (x+w)>sX || (y+h)>sY || (u+w)>dX || (v+h)>dY )
      {
      fprintf(stderr,"BlockMove: incompatible array sizes\n");
      exit(0);
      }

   if ( sB==1 && dB==1 )
      for ( j=0; j<h; ++j )
         {
         IB = S + (y+j)*sX + x;
         OB = D + (v+j)*dX + u;
         memcpy(OB, IB, w);
         }
   else if ( sB==1 && dB==2 )
      for ( j=0; j<h; ++j )
         {
         IB = S + (y+j)*sX + x;
         OW = (word *)D + (v+j)*dX + u;
         for ( i=0; i<w; ++i )  *(OW++) = (word)*(IB++);
         }
   else if ( sB==2 && dB==1 )
      for ( j=0; j<h; ++j )
         {
         IW = (word *)S + (y+j)*sX + x;
         OB = D + (v+j)*dX + u;
         for ( i=0; i<w; ++i ) 
            {
            p = *(IW++);
            *(OB++) = (byte)( p>255 ? WHITE : ( p<0 ? BLACK : p ) );
            }
         }
   else if (  sB==2 && dB==2  )
      for ( j=0; j<h; ++j )
         {
         IW = (word *)S + (y+j)*sX + x;
         OW = (word *)D + (v+j)*dX + u;
         memcpy(OW, IW, 2*w);
         }
   else
      {
      fprintf(stderr,"BlockMove: illegal parameter\n");
      exit(0);
      }

   return;
   }
       


      

       

/* scroll buffer list, Buf, forward and copy Img into the last position */
/* if Img is NULL, copy zeros into the last position */

void ScrollBuf( Buf, bX, bY, BufSize, BufDepth, oX, oY, Img, iX, iY, PixSize )
   byte **Buf;      /* buffer is a list of pointers to image planes */
   int    bX,bY;    /* horiz. and vert. dims. of each image plane */
   int    BufSize;  /* number of bytes in each plane pixel */    
   int    BufDepth; /* number of image planes in buffer */
   int    oX,oY;    /* x,y offset in image plane at which to begin copy */
   byte  *Img;      /* image to scroll into last plane */
   int    iX, iY;   /* horiz, vert. image dimensions */
   int    PixSize;  /* number of bytes per pixel in image */
   {
   byte *T;
   int i,n;

   T = *Buf;
   for ( i=0; i<BufDepth-1; ++i )  *(Buf+i) = *(Buf+i+1);
   *(Buf+BufDepth-1) = T;

   if ( Img != NULL )
      BlockMove( Img,PixSize,iX,iY,0,0,iX,iY,T,BufSize,bX,bY,oX,oY );
   else
      {
      n = BufSize*bX*bY;
      for ( i=0; i<n; ++i)  *(T++) = 0;
      } 
   return;
   }


