* **********************************************************************
* ** NOAA/USGS GENERAL MAP PROJECTION PACKAGE ..... DR. A. A. ELASSAL **
* ** GCTP/II                 VERSION 1.0.2           SEPTEMBER 1,1986 **
* **********************************************************************
      SUBROUTINE GTRNZ0 (CRDIN,INDEF,TPARIN,CRDIO,IODEF,TPARIO,
     .                   IPFILE,IFLG)
*
* GENERAL PROGRAM FOR TRANSFORMATION BETWEEN VARIOUS REFERENCE SYSTEMS
*
* INPUT ***************************************************************
* CRDIN    : COORDINATES IN INPUT SYSTEM (2 DP WORDS ARRAY).
* INDEF(1) : CODE NUMBER OF INPUT COORDINATE SYSTEM (INTEGER).
*               =  0 , GEOGRAPHIC
*               =  1 , U T M
*               =  2 , STATE PLANE
*               =  3 , ALBERS CONICAL EQUAL-AREA
*               =  4 , LAMBERT CONFORMAL CONIC
*               =  5 , MERCATOR
*               =  6 , POLAR STEREOGRAPHIC
*               =  7 , POLYCONIC
*               =  8 , EQUIDISTANT CONIC
*               =  9 , TRANSVERSE MERCATOR
*               = 10 , STEREOGRAPHIC
*               = 11 , LAMBERT AZIMUTHAL EQUAL-AREA
*               = 12 , AZIMUTHAL EQUIDISTANT
*               = 13 , GNOMONIC
*               = 14 , ORTHOGRAPHIC
*               = 15 , GENERAL VERTICAL NEAR-SIDE PERSPECTIVE
*               = 16 , SINUSOIDAL
*               = 17 , EQUIRECTANGULAR
*               = 18 , MILLER CYLINDRICAL
*               = 19 , VAN DER GRINTEN I
*               = 20 , OBLIQUE MERCATOR (HOTINE)
* INDEF(2) : CODE NUMBER OF INPUT COORDINATE ZONE (INTEGER).
* TPARIN   : PARAMETERS OF INPUT REFERENCE SYSTEM (15 DP WORDS ARRAY).
* INDEF(3) : CODE NUMBER OF UNITS OF MEASURE FOR INPUT COORDS (INTEGER).
*               = 0 , RADIANS.
*               = 1 , FEET.
*               = 2 , METERS.
*               = 3 , SECONDS OF ARC.
*               = 4 , DEGREES OF ARC.
*               = 5 , PACKED DMS.
* IODEF(1) : CODE NUMBER OF OUTPUT COORDINATE SYSTEM (INTEGER).
* IODEF(2) : CODE NUMBER OF OUTPUT COORDINATE ZONE (INTEGER).
* TPARIO   : PARAMETERS OF OUTPUT REFERENCE SYSTEM (15 DP WORDS ARRAY).
* IODEF(3) : CODE NUMBER OF UNITS OF MEASURE FOR OUTPUT COORDS (INTEGER)
* IPFILE   : LOGICAL NUMBER OF FILE FOR MESSAGES.
*
* OUTPUT **************************************************************
* CRDIO    : COORDINATES IN OUTPUT REFERENCE SYSTEM (2 DP WORDS ARRAY).
* IFLG     : RETURN FLAG (INTEGER).
*              = 0 , SUCCESSFUL TRANSFORMATION.
*              = I , UNSUCCESSFUL TRANSFORMATION. ERROR CODE   = I.
*
      IMPLICIT REAL*8 (A-H,O-Z)
      INTEGER*4 SYSUNT(21),INDEF(3),IODEF(3)
      DIMENSION CRDIN(1),CRDIO(1),TPARIN(1),TPARIO(1),COORD(2)
      DATA SYSUNT / 0 , 20*2 /
      DATA MAXUNT,MAXSYS / 5 , 20 /
      DATA ZERO /0.0D0/
*
* CHECK VALIDITY OF CODES FOR UNITS OF MEASURE AND REFERENCE SYSTEMS.
*
      IF (INDEF(1).GE.0 .AND. INDEF(1).LE.MAXSYS) GO TO 020
      IF (IPFILE .NE. 0) WRITE (IPFILE,2000) INDEF(1)
 2000 FORMAT (' ILLEGAL SOURCE REFERENCE SYSTEM CODE = ',I6)
      IFLG = 1
      RETURN
  020 IF (IODEF(1).GE.0 .AND. IODEF(1).LE.MAXSYS) GO TO 040
      IF (IPFILE .NE. 0) WRITE (IPFILE,2010) IODEF(1)
 2010 FORMAT (' ILLEGAL TARGET REFERENCE SYSTEM CODE = ',I6)
      IFLG = 2
      RETURN
  040 IF (INDEF(3).GE.0 .AND. INDEF(3).LE.MAXUNT) GO TO 060
      IF (IPFILE .NE. 0) WRITE (IPFILE,2020) INDEF(3)
 2020 FORMAT (' ILLEGAL SOURCE UNIT CODE = ',I6)
      IFLG = 3
      RETURN
  060 IF (IODEF(3).GE.0 .AND. IODEF(3).LE.MAXUNT) GO TO 080
      IF (IPFILE .NE. 0) WRITE (IPFILE,2030) IODEF(3)
 2030 FORMAT (' ILLEGAL TARGET UNIT CODE = ',I6)
      IFLG = 4
      RETURN
*
* CHECK CONSISTANCY BETEEN UNITS OF MEASURE AND REFERENCE SYSTEM.
*
  080 IUNIT = SYSUNT(INDEF(1) + 1)
      DO 100 I = 1,2
      CALL UNITZ0 (CRDIN(I),INDEF(3),COORD(I),IUNIT,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
  100 CONTINUE
      IUNIT = SYSUNT(IODEF(1) + 1)
      CALL UNITZ0 (ZERO,IUNIT,CRDIO,IODEF(3),IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      IF (INDEF(1).NE.IODEF(1) .OR. INDEF(2).NE.IODEF(2)) GO TO 140
      DO 120 I = 1,2
      CALL UNITZ0 (CRDIN(I),INDEF(3),CRDIO(I),IODEF(3),IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
  120 CONTINUE
      RETURN
*
* COMPUTE TRANSFORMED COORDINATES AND ADJUST THEIR UNITS.
*
  140 IF (INDEF(1) .EQ. 0) GO TO 520
      IF (INDEF(2).GT.60 .OR. INDEF(1).EQ.1) GO TO 200
      IF (IPFILE .NE. 0) WRITE (IPFILE,2040) INDEF(2)
 2040 FORMAT (' ILLEGAL SOURCE ZONE NUMBER = ',I6)
      IFLG = 5
      RETURN
*
* INVERSE TRANSFORMATION.
*
  200 GO TO (210,220,230,240,250,260,270,280,290,300,
     .       310,320,330,340,350,360,370,380,390,400) , INDEF(1)
  210 CALL IS01Z0 (INDEF(2),TPARIN,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 500
      CALL PI01Z0 (COORD,CRDIO,IFLG)
      GO TO 500
  220 CALL IS02Z0 (INDEF(2),TPARIN,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 500
      CALL PI02Z0 (COORD,CRDIO,IFLG)
      GO TO 500
  230 CALL IS03Z0 (INDEF(2),TPARIN,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 500
      CALL PI03Z0 (COORD,CRDIO,IFLG)
      GO TO 500
  240 CALL IS04Z0 (INDEF(2),TPARIN,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 500
      CALL PI04Z0 (COORD,CRDIO,IFLG)
      GO TO 500
  250 CALL IS05Z0 (INDEF(2),TPARIN,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 500
      CALL PI05Z0 (COORD,CRDIO,IFLG)
      GO TO 500
  260 CALL IS06Z0 (INDEF(2),TPARIN,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 500
      CALL PI06Z0 (COORD,CRDIO,IFLG)
      GO TO 500
  270 CALL IS07Z0 (INDEF(2),TPARIN,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 500
      CALL PI07Z0 (COORD,CRDIO,IFLG)
      GO TO 500
  280 CALL IS08Z0 (INDEF(2),TPARIN,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 500
      CALL PI08Z0 (COORD,CRDIO,IFLG)
      GO TO 500
  290 CALL IS09Z0 (INDEF(2),TPARIN,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 500
      CALL PI09Z0 (COORD,CRDIO,IFLG)
      GO TO 500
  300 CALL IS10Z0 (INDEF(2),TPARIN,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 500
      CALL PI10Z0 (COORD,CRDIO,IFLG)
      GO TO 500
  310 CALL IS11Z0 (INDEF(2),TPARIN,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 500
      CALL PI11Z0 (COORD,CRDIO,IFLG)
      GO TO 500
  320 CALL IS12Z0 (INDEF(2),TPARIN,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 500
      CALL PI12Z0 (COORD,CRDIO,IFLG)
      GO TO 500
  330 CALL IS13Z0 (INDEF(2),TPARIN,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 500
      CALL PI13Z0 (COORD,CRDIO,IFLG)
      GO TO 500
  340 CALL IS14Z0 (INDEF(2),TPARIN,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 500
      CALL PI14Z0 (COORD,CRDIO,IFLG)
      GO TO 500
  350 CALL IS15Z0 (INDEF(2),TPARIN,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 500
      CALL PI15Z0 (COORD,CRDIO,IFLG)
      GO TO 500
  360 CALL IS16Z0 (INDEF(2),TPARIN,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 500
      CALL PI16Z0 (COORD,CRDIO,IFLG)
      GO TO 500
  370 CALL IS17Z0 (INDEF(2),TPARIN,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 500
      CALL PI17Z0 (COORD,CRDIO,IFLG)
      GO TO 500
  380 CALL IS18Z0 (INDEF(2),TPARIN,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 500
      CALL PI18Z0 (COORD,CRDIO,IFLG)
      GO TO 500
  390 CALL IS19Z0 (INDEF(2),TPARIN,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 500
      CALL PI19Z0 (COORD,CRDIO,IFLG)
      GO TO 500
  400 CALL IS20Z0 (INDEF(2),TPARIN,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 500
      CALL PI20Z0 (COORD,CRDIO,IFLG)
  500 IF (IFLG .NE. 0) RETURN
      IF (IODEF(1) .EQ. 0) GO TO 920
      COORD(1) = CRDIO(1)
      COORD(2) = CRDIO(2)
  520 IF (IODEF(2).GT.60 .OR. IODEF(1).EQ.1) GO TO 540
      IF (IPFILE .NE. 0) WRITE (IPFILE,2050) IODEF(2)
 2050 FORMAT (' ILLEGAL TARGET ZONE NUMBER = ',I6)
      IFLG = 6
      RETURN
*
* FORWARD TRANSFORMATION.
*
  540 GO TO (610,620,630,640,650,660,670,680,690,700,
     .       710,720,730,740,750,760,770,780,790,800) , IODEF(1)
  610 CALL IS01Z0 (IODEF(2),TPARIO,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 900
      CALL PF01Z0 (COORD,CRDIO,IFLG)
      GO TO 900
  620 CALL IS02Z0 (IODEF(2),TPARIO,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 900
      CALL PF02Z0 (COORD,CRDIO,IFLG)
      GO TO 900
  630 CALL IS03Z0 (IODEF(2),TPARIO,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 900
      CALL PF03Z0 (COORD,CRDIO,IFLG)
      GO TO 900
  640 CALL IS04Z0 (IODEF(2),TPARIO,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 900
      CALL PF04Z0 (COORD,CRDIO,IFLG)
      GO TO 900
  650 CALL IS05Z0 (IODEF(2),TPARIO,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 900
      CALL PF05Z0 (COORD,CRDIO,IFLG)
      GO TO 900
  660 CALL IS06Z0 (IODEF(2),TPARIO,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 900
      CALL PF06Z0 (COORD,CRDIO,IFLG)
      GO TO 900
  670 CALL IS07Z0 (IODEF(2),TPARIO,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 900
      CALL PF07Z0 (COORD,CRDIO,IFLG)
      GO TO 900
  680 CALL IS08Z0 (IODEF(2),TPARIO,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 900
      CALL PF08Z0 (COORD,CRDIO,IFLG)
      GO TO 900
  690 CALL IS09Z0 (IODEF(2),TPARIO,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 900
      CALL PF09Z0 (COORD,CRDIO,IFLG)
      GO TO 900
  700 CALL IS10Z0 (IODEF(2),TPARIO,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 900
      CALL PF10Z0 (COORD,CRDIO,IFLG)
      GO TO 900
  710 CALL IS11Z0 (IODEF(2),TPARIO,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 900
      CALL PF11Z0 (COORD,CRDIO,IFLG)
      GO TO 900
  720 CALL IS12Z0 (IODEF(2),TPARIO,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 900
      CALL PF12Z0 (COORD,CRDIO,IFLG)
      GO TO 900
  730 CALL IS13Z0 (IODEF(2),TPARIO,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 900
      CALL PF13Z0 (COORD,CRDIO,IFLG)
      GO TO 900
  740 CALL IS14Z0 (IODEF(2),TPARIO,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 900
      CALL PF14Z0 (COORD,CRDIO,IFLG)
      GO TO 900
  750 CALL IS15Z0 (IODEF(2),TPARIO,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 900
      CALL PF15Z0 (COORD,CRDIO,IFLG)
      GO TO 900
  760 CALL IS16Z0 (IODEF(2),TPARIO,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 900
      CALL PF16Z0 (COORD,CRDIO,IFLG)
      GO TO 900
  770 CALL IS17Z0 (IODEF(2),TPARIO,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 900
      CALL PF17Z0 (COORD,CRDIO,IFLG)
      GO TO 900
  780 CALL IS18Z0 (IODEF(2),TPARIO,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 900
      CALL PF18Z0 (COORD,CRDIO,IFLG)
      GO TO 900
  790 CALL IS19Z0 (IODEF(2),TPARIO,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 900
      CALL PF19Z0 (COORD,CRDIO,IFLG)
      GO TO 900
  800 CALL IS20Z0 (IODEF(2),TPARIO,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 900
      CALL PF20Z0 (COORD,CRDIO,IFLG)
  900 IF (IFLG .NE. 0) RETURN
  920 DO 940 I = 1,2
      CALL UNITZ0 (CRDIO(I),IUNIT,CRDIO(I),IODEF(3),IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
  940 CONTINUE
*
      RETURN
      END
