/* SCCS @(#)selectplaneI.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       selectplaneI.layout.c                          */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   selectplaneI.layout.c                               */
/*                                                                      */
/* DESCRIPTION  :   1 Input plane                                       */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "selectplaneI.layout.h"
#include "widgetstructure.h"

#define MAX_ARGS 100

extern XmFontList gFontlist;
extern Pixel      gorchid, gthistle;

/********************************************************
/   Creation Function for SelectionPlane 
/*******************************************************/

Widget
build_SelectionPlane(selectplaneinput, IO_load_image_plane_OK, message, vector)
	Widget selectplaneinput;
	Widget IO_load_image_plane_OK;
        char *message;
	int vector;
{
	Widget SelectionPlane;
	Widget SelectPlane0;
	Widget SelectPlane1;
	Arg args[MAX_ARGS];
	int n;

	/* Creating SelectionPlane Widget */ 

	n = 0;
	XtSetArg(args[n],XmNx,1); n++;

	SelectionPlane = 
		XmCreateRowColumn(selectplaneinput,"SelectionPlane",args,n);
	XtManageChild(SelectionPlane);

	/* Creating SelectPlane0 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	if (vector != 1) 
	     XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[73],
			XmSTRING_DEFAULT_CHARSET)); 
	else XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[90],
			XmSTRING_DEFAULT_CHARSET)); 
	n++;

	SelectPlane0 = XmCreateLabel(SelectionPlane,"SelectPlane0",args,n);
	XtManageChild(SelectPlane0);

	/* Creating SelectPlane1 Widget */ 

	SelectPlane1 = 
		build_SelectPlane1(SelectionPlane, 
			IO_load_image_plane_OK, message, 1, vector);

	return(SelectionPlane);
}


/********************************************************
/   Creation Function for SelectPlane1 
/*******************************************************/

Widget
build_SelectPlane1(SelectionPlane, IO_load_image_plane_OK, message, numplan, vector)
	Widget SelectionPlane;
	Widget IO_load_image_plane_OK;
        char *message;
	int numplan;
	int vector;
{
	Widget SelectPlane1;
	Widget SelectPlaneLabel1;
	Widget SelectPlanes;
	Widget SelectPlaneLabel2;
	Widget Planenumbers;
	Widget Plane[MAX_IMAGE];
	plan_image_select *Tableau_plans;
	char num[4];
	Arg args[MAX_ARGS];
	int i, n;

	/* Creating SelectPlane1 Widget */ 


	SelectPlane1 = 
		XmCreateRowColumn(SelectionPlane,"SelectPlane1",NULL,0);
	XtManageChild(SelectPlane1);

	/* Creating SelectPlaneLabel1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	if (vector != 1) 
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[103],
			XmSTRING_DEFAULT_CHARSET)); 
	else 
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[104],
			XmSTRING_DEFAULT_CHARSET));
	n++;

	SelectPlaneLabel1 = 
		XmCreateLabel(SelectPlane1,"SelectPlaneLabel1",args,n);
	XtManageChild(SelectPlaneLabel1);

	/* Creating SelectPlanes Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	SelectPlanes = XmCreateRowColumn(SelectPlane1,"SelectPlanes",args,n);
	XtManageChild(SelectPlanes);

	/* Creating SelectPlaneLabel2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList,gFontlist); n++;
	if (vector != 1) 
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(message,
				   XmSTRING_DEFAULT_CHARSET));
	else
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(message,
			XmSTRING_DEFAULT_CHARSET)); 
	n++;
	
	SelectPlaneLabel2 = 
		XmCreateLabel(SelectPlanes,"SelectPlaneLabel2",args,n);
	XtManageChild(SelectPlaneLabel2);

	/* Creating Planenumbers Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	Planenumbers = XmCreateForm(SelectPlanes,"Planenumbers",args,n);

	XtManageChild(Planenumbers);

	/* Creating Plane[MAX_IMAGE] Widgets */ 

	Tableau_plans = 
	    (plan_image_select *) malloc (sizeof (plan_image_select));

	if (vector != 1) {
	  for (i=0;i < MAX_IMAGE; i++){
	    itoa (i, num);	 
  	    n = 0;
	    XtSetArg(args[n],XmNfontList, gFontlist); n++;
	    if (i == 0) XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM);
	    else
	    {
	      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET);n++;
	      XtSetArg(args[n],XmNleftWidget,Plane[i-1]);
	    }
	    n++;
	    XtSetArg(args[n],XmNwidth, 20); n++;
	    XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(num,
			XmSTRING_DEFAULT_CHARSET)); n++;
	    XtSetArg(args[n],XmNpushButtonEnabled,true); n++;
	    XtSetArg(args[n],XmNrecomputeSize,false); n++;
	    XtSetArg(args[n],XmNhighlightThickness, 0); n++;

	    /* Definition de l'occupation du plan represente par ce bouton!*/
	    if (Occupation_Plan(i) == 1){
	      XtSetArg (args[n],XmNforeground, gorchid); n++;
	    }
	    XtSetArg (args[n],XmNbackground, gthistle);n++;      

	    Plane[i] = XmCreateDrawnButton(Planenumbers,"Plane",args,n);

	    XtManageChild(Plane[i]);
	  
	    Tableau_plans->plan_image[i] = Plane[i];
	  }

	  Tableau_plans->num_index = numplan;

	  /* Adding Callbacks for Plane[i] */ 

	  for (i=0;i < MAX_IMAGE; i++)
	    XtAddCallback(Plane[i],
		XmNactivateCallback, plane_selected,Tableau_plans);
	}
	else {
	  for (i=0;i < MAX_VECTEUR; i++){
	    itoa (i, num);	 
  	    n = 0;
	    XtSetArg(args[n],XmNfontList,gFontlist); n++;
	    if (i == 0) XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM);
	    else
	    {
	      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET);n++;
	      XtSetArg(args[n],XmNleftWidget,Plane[i-1]);
	    }
	    n++;
	    XtSetArg(args[n],XmNwidth, 20); n++;
	    XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(num,
			XmSTRING_DEFAULT_CHARSET)); n++;
	    XtSetArg(args[n],XmNpushButtonEnabled,true); n++;
	    XtSetArg(args[n],XmNrecomputeSize,false); n++;
	    XtSetArg(args[n],XmNhighlightThickness, 0); n++;

	    /* Definition de l'occupation du vecteur represente par ce bouton!*/
	    if (Occupation_Vector(i) == 1){
	      XtSetArg (args[n],XmNforeground, gorchid); n++;
	    }
	    XtSetArg (args[n],XmNbackground, gthistle);n++;      

	    Plane[i] = XmCreateDrawnButton(Planenumbers,"Plane",args,n);

	    XtManageChild(Plane[i]);
	  
	    Tableau_plans->plan_image[i] = Plane[i];
	  }

	  Tableau_plans->num_index = numplan;
	  /* Adding Callbacks for Plane[i] */ 

	  for (i=0;i < MAX_VECTEUR; i++)
	  XtAddCallback(Plane[i],
		XmNactivateCallback, vector_selected,Tableau_plans);
	}

	XtAddCallback(IO_load_image_plane_OK,XmNactivateCallback,
		      libere_memoire,Tableau_plans);


	return(SelectPlane1);
}
