/* SCCS @(#)proconvmask.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                        proconvmask.layout.c                          */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   proconvmask.layout.c                                */
/*                                                                      */
/* DESCRIPTION  :   Convolution Create mask                             */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "widgetstructure.h"
#include "proconvmask.layout.h"

#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;

/********************************************************
/   Creation Function for PRO_create_mask_param_widget 
/*******************************************************/

xs_struc_paramprepro
* build_PRO_create_mask_param_widget(PRO_create_mask_param1)
	Widget PRO_create_mask_param1;
{
	Widget PRO_create_mask_param_widget;
	Widget nb_lines_label;
	Widget nb_columns_label;
	Widget mult_factor_label;
	Widget nb_lines_text;
	Widget nb_columns_text;
	Widget mult_factor_text;
	Widget PRO_mask_button;
	xs_struc_paramprepro *Paramprepro;
	Widget Mask_Label_0;
	char *repfloat;
	Arg args[MAX_ARGS];
	int n;

	Paramprepro = 
	  (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));

	Paramprepro->Text = NULL;
	
	repfloat = (char *) malloc (20);

	/* Creating PRO_create_mask_param_widget Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,256); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,185); n++;
	XtSetArg(args[n],XmNx,27); n++;
	XtSetArg(args[n],XmNy,19); n++;

	PRO_create_mask_param_widget = XmCreateForm(PRO_create_mask_param1,
				      "PRO_create_mask_param_widget",args,n);
	XtManageChild(PRO_create_mask_param_widget);

	Paramprepro->parent = PRO_create_mask_param_widget;

	/* Creating nb_lines_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[433],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightPosition,40); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,15); n++;

	nb_lines_label = XmCreateLabel(PRO_create_mask_param_widget,
				       "nb_lines_label",args,n);
	XtManageChild(nb_lines_label);

	/* Creating nb_columns_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[432],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightPosition,40); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,35); n++;

	nb_columns_label = XmCreateLabel(PRO_create_mask_param_widget,
					 "nb_columns_label",args,n);
	XtManageChild(nb_columns_label);

	/* Creating mult_factor_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[30],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightPosition,40); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,55); n++;

	mult_factor_label = XmCreateLabel(PRO_create_mask_param_widget,
					  "mult_factor_label",args,n);
	XtManageChild(mult_factor_label);

	/* Creating nb_lines_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,nb_lines_label); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,95); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,15); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	nb_lines_text = XmCreateText(PRO_create_mask_param_widget,
				     "nb_lines_text",args,n);
	sprintf (repfloat, "%d", 3); 
	XmTextSetString (nb_lines_text, repfloat);
	XtManageChild(nb_lines_text);

	Paramprepro->line = nb_lines_text;

	/* Creating nb_columns_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,nb_columns_label); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,95); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,35); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	nb_columns_text = XmCreateText(PRO_create_mask_param_widget,
				       "nb_columns_text",args,n);
	sprintf (repfloat, "%d", 3); 
	XmTextSetString (nb_columns_text, repfloat);
	XtManageChild(nb_columns_text);

	Paramprepro->colon = nb_columns_text;

	/* Creating mult_factor_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,mult_factor_label); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,95); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,55); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	mult_factor_text = XmCreateText(PRO_create_mask_param_widget,
					"mult_factor_text",args,n);
	sprintf (repfloat, "%d", 1); 
	XmTextSetString (mult_factor_text, repfloat);
	XtManageChild(mult_factor_text);

	Paramprepro->alpha = mult_factor_text;

	/* Creating PRO_mask_button Widget */ 
	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(mastertabs[35],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,20); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,75); n++;

	PRO_mask_button = 
	XmCreatePushButton(PRO_create_mask_param_widget,
			   "PRO_mask_Label_0",args,n);
	XtManageChild(PRO_mask_button);

	/* Adding Callbacks for PRO_mask_button */ 

	XtAddCallback(PRO_mask_button,XmNactivateCallback,
		PRO_create_mask_callb, Paramprepro);


	/* Creating Mask_Label_0 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(labeltabs[9],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,5); n++;

	Mask_Label_0 = XmCreateLabel(PRO_create_mask_param_widget,
				     "Mask_Label_0",args,n);
	XtManageChild(Mask_Label_0);
	
	free (repfloat);

	return(Paramprepro);
}
