/* SCCS @(#)preenhmfi.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      preenhmfi.layout.c                              */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   preenhmfi.layout.c                                  */
/*                                                                      */
/* DESCRIPTION  :   Preprocessing enhancement (Median filter)           */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "widgetstructure.h"
#include "preenhmfi.layout.h"
#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;

/********************************************************
/   Creation Function for PREPRO_median_filter_param_widget 
/*******************************************************/

xs_struc_paramprepro 
* build_PREPRO_median_filter_param_widget(PREPRO_median_filter_param)
	Widget PREPRO_median_filter_param;
{
	Widget PREPRO_median_filter_param_widget;
	Widget no_of_columns_Label_2;
	Widget no_of_lines_Label_4;
	Widget no_of_lines_text;
	Widget no_of_columns_text;
	xs_struc_paramprepro *Paramprepro;
	Widget PREPRO_enhanc_median_Label_3;
	Arg args[MAX_ARGS];
	int n;

	Paramprepro = 
	  (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));


	/* Creating PREPRO_median_filter_param_widget Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,113); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,199); n++;
	XtSetArg(args[n],XmNx,1); n++;

	PREPRO_median_filter_param_widget = 
	   XmCreateForm(PREPRO_median_filter_param,
			"PREPRO_median_filter_param_widget",args,n);
	XtManageChild(PREPRO_median_filter_param_widget);

	Paramprepro->parent = PREPRO_median_filter_param_widget;

	/* Creating no_of_columns_Label_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[485],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,10); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,25); n++;

	no_of_columns_Label_2 = 
	     XmCreateLabel(PREPRO_median_filter_param_widget,
			   "no_of_columns_Label_2",args,n);
	XtManageChild(no_of_columns_Label_2);

	/* Creating no_of_lines_Label_4 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[484],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,10); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,60); n++;
	XtSetArg(args[n],XmNtopWidget,NULL); n++;

	no_of_lines_Label_4 = 
	         XmCreateLabel(PREPRO_median_filter_param_widget,
			       "no_of_lines_Label_4",args,n);
	XtManageChild(no_of_lines_Label_4);

	/* Creating no_of_lines_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,no_of_lines_Label_4); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,95); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,60); n++;
	XtSetArg(args[n],XmNtopWidget,no_of_columns_text); n++;
	XtSetArg(args[n],XmNvalue,"3"); n++;
        XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	no_of_lines_text = 
	           XmCreateText(PREPRO_median_filter_param_widget,
				"no_of_lines_text",args,n);
	XtManageChild(no_of_lines_text);

	Paramprepro->line = no_of_lines_text;

	/* Creating no_of_columns_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,no_of_columns_Label_2); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,95); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,25); n++;
	XtSetArg(args[n],XmNvalue,"3"); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	no_of_columns_text = XmCreateText(PREPRO_median_filter_param_widget,
					  "no_of_columns_text",args,n);
	XtManageChild(no_of_columns_text);

	Paramprepro->colon = no_of_columns_text;

	/* Creating PREPRO_enhanc_median_Label_3 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[431],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PREPRO_enhanc_median_Label_3 = 
	    XmCreateLabel(PREPRO_median_filter_param_widget,
			  "PREPRO_enhanc_median_Label_3",args,n);
	XtManageChild(PREPRO_enhanc_median_Label_3);

	return(Paramprepro);
}
