/* SCCS @(#)auxmodnoi.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       auxmodnoi.layout.c                             */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   auxmodnoi.layout.c                                  */
/*                                                                      */
/* DESCRIPTION  :   Auxiliary modifications Noise                       */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "widgetstructure.h"
#include "auxmodnoi.layout.h"
#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;

/********************************************************
/   Creation Function for AUX_mod_noise_param 
/*******************************************************/

/* bruit uniforme: type = 0 */
/* bruit gaussian: type = 1 */

xs_struc_paramprepro
* build_AUX_mod_noise_param(auxmodnoi, type)
	Widget auxmodnoi;
	int type;
{
	Widget AUX_mod_noise_param;
	Widget mean_label;
	Widget range_label;
	Widget range_text;
	Widget mean_text;
	Widget Labelprincip;
	xs_struc_paramprepro *Paramprepro;
	Arg args[MAX_ARGS];
	int n;

	Paramprepro = 
	  (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));

	/* Creating AUX_mod_noise_param Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,210); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,168); n++;
	XtSetArg(args[n],XmNx,26); n++;
	XtSetArg(args[n],XmNy,25); n++;

	AUX_mod_noise_param = 
	        XmCreateForm(auxmodnoi,"AUX_mod_noise_param",args,n);
	XtManageChild(AUX_mod_noise_param);

	Paramprepro->parent = AUX_mod_noise_param;

	/* Creating mean_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	if (type == 0) /*bruit uniforme */
	     XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[19],
			XmSTRING_DEFAULT_CHARSET));
	else XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[5],
			XmSTRING_DEFAULT_CHARSET));
	n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,10); n++;
	XtSetArg(args[n],XmNrightPosition,40); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,35); n++;

	mean_label = XmCreateLabel(AUX_mod_noise_param,"mean_label",args,n);
	XtManageChild(mean_label);

	/* Creating range_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	if (type == 0)
	     XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[20],
			XmSTRING_DEFAULT_CHARSET));
	else XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[6],
			XmSTRING_DEFAULT_CHARSET));
 	n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,10); n++;
	XtSetArg(args[n],XmNrightPosition,40); n++;
	XtSetArg(args[n],XmNrightWidget,NULL); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,60); n++;

	range_label = XmCreateLabel(AUX_mod_noise_param,"range_label",args,n);
	XtManageChild(range_label);

	/* Creating range_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,25); n++;
	XtSetArg(args[n],XmNleftWidget,NULL); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,90); n++;
	XtSetArg(args[n],XmNrightWidget,NULL); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,70); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	if (type == 0) /* bruit uniforme */
	  XtSetArg(args[n],XmNvalue, "1");
	else
	  XtSetArg(args[n],XmNvalue, "0.25");
	n++;
	  
	range_text = XmCreateText(AUX_mod_noise_param,"range_text",args,n);
	XtManageChild(range_text);

	Paramprepro->colon = range_text;

	/* Creating mean_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,25); n++;
	XtSetArg(args[n],XmNleftWidget,NULL); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,90); n++;
	XtSetArg(args[n],XmNrightWidget,NULL); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,45); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	if (type == 0) /*bruit uniforme */
	  XtSetArg(args[n],XmNvalue, "0");
	else
	  XtSetArg(args[n],XmNvalue, "0"); 
	n++;
	
	mean_text = XmCreateText(AUX_mod_noise_param,"mean_text",args,n);
	XtManageChild(mean_text);

	Paramprepro->line = mean_text;

	/* Creating Labelprincip Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	if (type == 0)
	     XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(panel_titres[165],
			XmSTRING_DEFAULT_CHARSET));
	else XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(panel_titres[166],
			XmSTRING_DEFAULT_CHARSET));
	n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,5); n++;

	Labelprincip = XmCreateLabel(AUX_mod_noise_param,
				     "Labelprincip",args,n);
	XtManageChild(Labelprincip);

	return(Paramprepro);
}
