/* SCCS @(#)i_olim.callback.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                          i_olim.callback.c                           */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   i_olim.callback.c                                   */
/*                                                                      */
/* DESCRIPTION  :   IO operations of LaboImage   (load)                 */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "libwidgets/widgetstructure.h"
#include "i_olim.layout.h"
#include <Xm/FileSB.h>
#include <Xm/Text.h>
#include <strings.h>
#include "lecture4.h"
#include "gel1D_in4.h"


static int numplans = 0;


void Ote_ima_des (file)
     char **file;
{
  char stringIma[5];
  int i, len;

  len = strlen (*file);

  if (len > 4)
    {
      for (i = 0; i < 4; i++)
	stringIma[i] = (*file)[len + i - 4];
      
      stringIma[4] = '\0';
      
      if ((strncmp (stringIma, ".ima", 4) == 0) || 
	  (strncmp (stringIma, ".des", 4) == 0))
	(*file)[len-4] = '\0';
    }
}


/********************************************************************/
/******************************************************
/   activateCallback for Widget  IO_load_image_planeout_CANCEL 
/*****************************************************/

void
IO_load_image_planeout_CANCEL_callb(IO_load_image_planeout_CANCEL, 
			IO_widget_planeout, callData)
	Widget IO_load_image_planeout_CANCEL;
	xs_struc_widget_planeout *IO_widget_planeout;
	caddr_t callData;
{
  if (IO_widget_planeout->fn)
    {
      fclose (IO_widget_planeout->fn->fpim);
      IO_widget_planeout->fn->fpim = NULL;
      fclose(IO_widget_planeout->fn->fpdesc);
      IO_widget_planeout->fn->fpdesc = NULL;
    }
  if (IO_widget_planeout->lect_lts)
    {
      fclose(IO_widget_planeout->lect_lts->fp_lts);
      IO_widget_planeout->lect_lts->fp_lts = NULL;
    }
  XtUnmanageChild (XtParent (XtParent (IO_load_image_planeout_CANCEL)));
}


/******************************************************
/   activateCallback for Widget  IO_load_image_planeout_OK 
/*****************************************************/

void
IO_load_image_planeout_OK_callb(IO_load_image_planeout_OK, 
			IO_widget_planeout, callData)
	Widget IO_load_image_planeout_OK;
	xs_struc_widget_planeout *IO_widget_planeout;
	caddr_t callData;
{
  int lecture_OK;
  int type;

  type = IO_widget_planeout->type;
  /* lecture plan choisi: voir si tous les plans sont correctement selectionne*/
  switch (type) 
  {
     case IO_LOAD_LTS:
	 lecture_OK = (* (IO_widget_planeout->fct_ok_lecture))
			(index_image[1], IO_widget_planeout->lect_lts);
         if (lecture_OK == 1) 
	 {
	   sprintf(buf, "%s ", IO_widget_planeout->lect_lts->filename); 
	   write_master (buf); 
	   sprintf(buf, " --> %d: \n", index_image[1]);
	   write_master (buf); 
	   sprintf(buf,paneltabs[256]);
	   write_master (buf); 
	   sprintf(buf, " %d,\n ", IO_widget_planeout->lect_lts->header);
	   write_master (buf); 
	   sprintf(buf, paneltabs[257]);
	   write_master (buf); 
	   sprintf(buf, " %d,\n ", IO_widget_planeout->lect_lts->nlignes);
	   write_master (buf); 
	   sprintf(buf, paneltabs[258]);
	   write_master (buf); 
	   sprintf(buf, " %d,\n ", IO_widget_planeout->lect_lts->nbytes);
	   write_master (buf); 
	   sprintf(buf, paneltabs[259]);
	   write_master (buf); 
	   sprintf(buf, " %d,\n ", IO_widget_planeout->lect_lts->nvaleur);
	   write_master (buf); 
	   sprintf(buf, paneltabs[260]);
	   write_master (buf); 
	   sprintf(buf, " %d.\n ", IO_widget_planeout->lect_lts->bytes_sautes);
	   write_master(buf);
	 }
	 break;

     case IO_LOAD_RGB:      
	 lecture_OK = (* (IO_widget_planeout->fct_ok_lecture))
			(index_image[1], index_image[3], index_image[5], 
			IO_widget_planeout->lect_lts);
         if (lecture_OK == 1) 
	 {
	   sprintf (buf, "%s ", IO_widget_planeout->lect_lts->filename); 
	   write_master (buf); 
	   sprintf (buf, " --> %d %d %d: \n", 
		    index_image[1], index_image[3], index_image[5]);
	   write_master (buf); 
	   sprintf(buf,paneltabs[256]);
	   write_master (buf); 
	   sprintf(buf, " %d,\n ", IO_widget_planeout->lect_lts->header);
	   write_master (buf); 
	   sprintf(buf, paneltabs[257]);
	   write_master (buf); 
	   sprintf(buf, " %d,\n ", IO_widget_planeout->lect_lts->nlignes);
	   write_master (buf); 
	   sprintf(buf, paneltabs[258]);
	   write_master (buf); 
	   sprintf(buf, " %d,\n ", IO_widget_planeout->lect_lts->nbytes);
	   write_master (buf); 
	   sprintf(buf, paneltabs[259]);
	   write_master (buf); 
	   sprintf(buf, " %d,\n ", IO_widget_planeout->lect_lts->nvaleur);
	   write_master (buf); 
	   sprintf(buf, paneltabs[260]);
	   write_master (buf); 
	   sprintf(buf, " %d.\n ", IO_widget_planeout->lect_lts->bytes_sautes);
	   write_master(buf);
	 }
	 break;

     case IO_LOAD_STANDARD:
     case IO_LOAD_BSTANDARD: 
     case IO_LOAD_MELANIE:
	 lecture_OK = (* (IO_widget_planeout->fct_ok_lecture))
			(IO_widget_planeout->fn, IO_widget_planeout->type);
         if (lecture_OK == 1) 
	 {
	   switch (numplans) {
	    case 1 :
              sprintf (buf, mastertabs[132], IO_widget_planeout->fn->filename, 
		       index_image[1]);
	      break;
	    case 2 : 
	      sprintf (buf, mastertabs[133], IO_widget_planeout->fn->filename, 
		       index_image[1], index_image[3]);
	      break;
	    case 3 : 
	      sprintf (buf,mastertabs[134],IO_widget_planeout->fn->filename,
		       index_image[1], index_image[3], index_image[5]);
	      break;
	    }
	   write_master (buf);
	 }  
	 break;

     case IO_LOAD_SUN:
	 lecture_OK = (* (IO_widget_planeout->fct_ok_lecture))
			(IO_widget_planeout->fn);
         if (lecture_OK == 1) 
	 {
	   sprintf (buf, mastertabs[132], IO_widget_planeout->fn->filename, 
		    index_image[1]);
	   write_master (buf);
	 }  
	 break;

     case IO_LOAD_GEL_STANDARD:
	 lecture_OK = (* (IO_widget_planeout->fct_ok_lecture))
	                       (IO_widget_planeout->fn, 1);
         if (lecture_OK == 1) 
	 {
	   sprintf (buf, "%s", IO_widget_planeout->fn->filename); 
	   write_master (buf); 
	   sprintf (buf, " --> %d\n", index_image[1]);
	   write_master (buf); 
	 }
	 break;

     case IO_LOAD_GEL_MELANIE:
	 lecture_OK = (* (IO_widget_planeout->fct_ok_lecture))
	                       (IO_widget_planeout->fn, 2);
         if (lecture_OK == 1) 
	 {
	   sprintf (buf, "%s", IO_widget_planeout->fn->filename); 
	   write_master (buf); 
	   sprintf (buf, " --> %d\n", index_image[1]);
	   write_master (buf);
         } 
	 break;

     default: break;
  }

  if (lecture_OK != 1) 
    write_erreur(987);

  XtUnmanageChild (XtParent (XtParent (IO_load_image_planeout_OK)));
  XtUnmanageChild (IO_widget_planeout->IO_load_image_file_widget);
}


/******************************************************
/   cancelCallback for Widget  IO_load_image_file_selection 
/*****************************************************/

void
IO_load_image_file_CANCEL_callb(IO_load_image_file_selection, 
			IO_load_image_file_widget, callData)
	Widget IO_load_image_file_selection;
	Widget IO_load_image_file_widget;
	caddr_t callData;
{
    sprintf(buf,panel_titres[25]);
    write_master(buf);
    XtUnmanageChild (IO_load_image_file_widget);
}


/******************************************************
/   okCallback for Widget  IO_load_image_file_selection 
/*****************************************************/

void
IO_load_image_stand_OK_callb(IO_load_image_file_selection, 
			IO_load_image_file_widget, callData)
	Widget IO_load_image_file_selection;
	Widget IO_load_image_file_widget;
	caddr_t callData;
{
  xs_struc_widget_planeout *IO_widget_planeout;
  struct fname *fn;
  int k;
  Widget IO_load_image_planeout_widget;
  char * filedes;

  if (filedes != NULL) free(filedes);

  filedes = XmTextGetString (XmFileSelectionBoxGetChild 
		(IO_load_image_file_selection, XmDIALOG_TEXT));

  sprintf (buf, mastertabs[136]);
  write_master (buf);

  if (strlen (filedes) == 0) 
  {
    write_erreur(20);
    return;
  }

  /*mise a jour de la variable globale: repertoire_image*/
  strcpy (repertoire_image, XmTextGetString (XmFileSelectionBoxGetChild 
		 (IO_load_image_file_selection, XmDIALOG_FILTER_TEXT)));

  Ote_ima_des(&filedes);

  fn = lire_fname (filedes, 10);

  if (fn->fpdesc != NULL && fn->fpim != NULL) {

    IO_widget_planeout = 
    (xs_struc_widget_planeout *) malloc (sizeof (xs_struc_widget_planeout));
    IO_widget_planeout->IO_load_image_file_widget = IO_load_image_file_widget;
    IO_widget_planeout->type = IO_LOAD_STANDARD;
    IO_widget_planeout->fct_ok_lecture = lecture_standard;
    IO_widget_planeout->fn = fn;
    IO_widget_planeout->lect_lts = NULL;

    k = read_desc(fn->fpdesc, &desc);
    switch (k){
       case -1: 
         write_erreur(104);
	 fclose (fn->fpim);
	 fclose(fn->fpdesc);
	 XtUnmanageChild (IO_load_image_file_widget);
	 return;
       case 0: 
	 write_erreur(103);
	 fclose (fn->fpim);
	 fclose(fn->fpdesc);
	 XtUnmanageChild (IO_load_image_file_widget);
	 return;
    }

    /*Passage des informations au widget IO_load_image_planeout_widget.*/
    switch (desc.type)
    {
       case -1:
       case 0 :
       case 1 :
       case 2 :
       case 3 : 
	 numplans = 1;
	 IO_load_image_planeout_widget = 
	    build_IO_load_image_planeout_widget(IO_widget_planeout, 1, desc.type);
		 break;
       case 4 : 
       case 5 : 
	 numplans = 2;
	 IO_load_image_planeout_widget = 
	    build_IO_load_image_planeout_widget(IO_widget_planeout, 2, desc.type);
		 break;
       case 6 : 
	 numplans = 3;
	 IO_load_image_planeout_widget = 
	    build_IO_load_image_planeout_widget(IO_widget_planeout, 3, desc.type);
		 break;
    }
    XtManageChild (IO_load_image_planeout_widget);
  }
  else 
    write_erreur(987);

  XtFree(filedes);
}


/******************************************************
/   okCallback for Widget  IO_load_image_file_selection 
/*****************************************************/

void
IO_load_image_melanie_OK_callb(IO_load_image_file_selection, 
			IO_load_image_file_widget, callData)
	Widget IO_load_image_file_selection;
	Widget IO_load_image_file_widget;
	caddr_t callData;
{
  xs_struc_widget_planeout *IO_widget_planeout;
  struct fname *fn;
  int k;
  Widget IO_load_image_planeout_widget;
  char * dirgel;

  if (dirgel != NULL) free(dirgel);

  dirgel = XmTextGetString (XmFileSelectionBoxGetChild 
		(IO_load_image_file_selection, XmDIALOG_TEXT));

  sprintf (buf, mastertabs[144]);
  write_master (buf);

  if (strlen (dirgel) == 0) 
  {
    write_erreur(20);
    return;
  }

  /*mise a jour de la variable globale: repertoire_image*/
  strcpy (repertoire_image, XmTextGetString (XmFileSelectionBoxGetChild 
		(IO_load_image_file_selection, XmDIALOG_FILTER_TEXT)));

  /* traitement du nom de repertoire 'dirgel'. */
  fn = lire_repertoire_gel (dirgel, 0);

  if (fn->fpdesc != NULL && fn->fpim != NULL) 
  {  
    IO_widget_planeout = 
    (xs_struc_widget_planeout *) malloc (sizeof (xs_struc_widget_planeout));
    IO_widget_planeout->IO_load_image_file_widget = IO_load_image_file_widget;
    IO_widget_planeout->type = IO_LOAD_MELANIE;
    IO_widget_planeout->fct_ok_lecture = lecture_standard;
    IO_widget_planeout->fn = fn;
    IO_widget_planeout->lect_lts = NULL;


    k = read_desc_gel(fn->fpdesc, &desc);
    switch (k)
    {
      case -1: 
         write_erreur(104);
	 fclose (fn->fpim);
	 fclose(fn->fpdesc);
	 XtUnmanageChild (IO_load_image_file_widget);
	 return;
      case 0: 
	 write_erreur(103);
	 fclose (fn->fpim);
	 fclose(fn->fpdesc);
	 XtUnmanageChild (IO_load_image_file_widget);
	 return;
      default: 
	 break;
    }

    /*Passage des informations au widget IO_load_image_planeout_widget.*/
    numplans = 1;
    IO_load_image_planeout_widget = 
	   build_IO_load_image_planeout_widget(IO_widget_planeout, 1, desc.type);
    XtManageChild (IO_load_image_planeout_widget);
  }
  else 
    write_erreur(987);

  XtFree(dirgel);
}


/******************************************************
/   okCallback for Widget  IO_load_image_file_selection 
/*****************************************************/

void
IO_load_image_bstand_OK_callb(IO_load_image_file_selection, 
			IO_load_image_file_widget, callData)
	Widget IO_load_image_file_selection;
	Widget IO_load_image_file_widget;
	caddr_t callData;
{
  xs_struc_widget_planeout *IO_widget_planeout;
  struct fname *fn;
  struct  description desc;
  int k;
  Widget IO_load_image_planeout_widget;
  char * filedes;

  if (filedes != NULL) free (filedes);

  filedes = XmTextGetString (XmFileSelectionBoxGetChild 
			(IO_load_image_file_selection, XmDIALOG_TEXT));

  sprintf (buf, mastertabs[135]);
  write_master (buf);

  if (strlen (filedes) == 0) 
  {
    write_erreur(20);
    return;
  }

  /*mise a jour de la variable globale: repertoire_image*/
  strcpy (repertoire_image, XmTextGetString (XmFileSelectionBoxGetChild 
		(IO_load_image_file_selection, XmDIALOG_FILTER_TEXT)));

  Ote_ima_des(&filedes);

  fn = lire_fname (filedes, 10);

  if (fn->fpdesc != NULL && fn->fpim != NULL) 
  {
    IO_widget_planeout = 
    (xs_struc_widget_planeout *) malloc (sizeof (xs_struc_widget_planeout));
    IO_widget_planeout->IO_load_image_file_widget = IO_load_image_file_widget;
    IO_widget_planeout->type = IO_LOAD_BSTANDARD;
    IO_widget_planeout->fct_ok_lecture = lecture_standard;
    IO_widget_planeout->fn = fn;
    IO_widget_planeout->lect_lts = NULL;


    k = read_desc(fn->fpdesc, &desc);
    switch (k){
      case -1: 
         write_erreur(104);
	 fclose (fn->fpim);
	 fclose(fn->fpdesc);
	 XtUnmanageChild (IO_load_image_file_widget);
	 return;
      case 0: 
	 write_erreur(103);
	 fclose (fn->fpim);
	 fclose(fn->fpdesc);
	 XtUnmanageChild (IO_load_image_file_widget);
	 return;
      default: 
	 break;
    }

    /*Passage des informations au widget IO_load_image_planeout_widget.*/
    switch (desc.type) {
	case -1:
        case 0 :
        case 1 :
        case 2 :
        case 3 : 
	  numplans = 1;
	  IO_load_image_planeout_widget = 
	    build_IO_load_image_planeout_widget(IO_widget_planeout, 1, desc.type);
		 break;
        case 4 : 
        case 5 : 
	  numplans = 2;
	  IO_load_image_planeout_widget = 
	    build_IO_load_image_planeout_widget(IO_widget_planeout, 2, desc.type);
		 break;
        case 6 :  
	  numplans = 3;
	  IO_load_image_planeout_widget = 
	    build_IO_load_image_planeout_widget(IO_widget_planeout, 3, desc.type);
		 break;
    }
    XtManageChild (IO_load_image_planeout_widget);
  }
  else 
    write_erreur(987);

  XtFree(filedes);
}


/******************************************************
/   okCallback for Widget  IO_load_image_file_selection 
/*****************************************************/

void
IO_load_image_lts_OK_callb(IO_load_image_file_selection, IO_param_file, callData)
	Widget IO_load_image_file_selection;
	xs_struc_widgetIO *IO_param_file;
	caddr_t callData;
{
  char * filedes;
  xs_struc_widget_planeout *IO_widget_planeout;
  struct lecture_lts *lect_lts;
  Widget IO_load_image_planeout_widget;

  if (filedes != NULL) free(filedes);

  filedes = XmTextGetString (XmFileSelectionBoxGetChild 
			   (IO_load_image_file_selection, XmDIALOG_TEXT));

  sprintf (buf, mastertabs[142]);
  write_master (buf);

  if (strlen (filedes) == 0) 
  {
    write_erreur(20);
    return;
  }

  /*mise a jour de la variable globale: repertoire_image*/
  strcpy (repertoire_image, XmTextGetString (XmFileSelectionBoxGetChild 
		(IO_load_image_file_selection, XmDIALOG_FILTER_TEXT)));

  lect_lts = (struct lecture_lts *) malloc (sizeof (struct lecture_lts));

  if ((lect_lts->fp_lts = fopen (filedes, "r")) == NULL) free(lect_lts);
  else 
  {
    strcpy(lect_lts->filename, filedes);
    lect_lts->header = 
           atoi(XmTextGetString (IO_param_file->param->header_length));
    lect_lts->nlignes = 
          atoi(XmTextGetString (IO_param_file->param->No_rows_image));
    lect_lts->nvaleur = 
          atoi(XmTextGetString (IO_param_file->param->No_columns_image));
    lect_lts->nbytes = 
          atoi(XmTextGetString (IO_param_file->param->No_bytes_row));
    lect_lts->bytes_sautes = 
          atoi(XmTextGetString (IO_param_file->param->No_bytes_to_skip_pixel));

    IO_widget_planeout = 
    (xs_struc_widget_planeout *) malloc (sizeof (xs_struc_widget_planeout));
    IO_widget_planeout->IO_load_image_file_widget = IO_param_file->filewidget;
    IO_widget_planeout->type = IO_LOAD_LTS;
    IO_widget_planeout->fct_ok_lecture = lire_filelts;
    IO_widget_planeout->fn = NULL;
    IO_widget_planeout->lect_lts = lect_lts;

    IO_load_image_planeout_widget = 
	  build_IO_load_image_planeout_widget(IO_widget_planeout, 1, 6);
    XtManageChild (IO_load_image_planeout_widget);
  }
}

/******************************************************
/   okCallback for Widget  IO_load_image_file_selection 
/*****************************************************/

void
IO_load_image_rgb_OK_callb(IO_load_image_file_selection, IO_param_file, callData)
	Widget IO_load_image_file_selection;
	xs_struc_widgetIO *IO_param_file;
	caddr_t callData;
{
  char * filedes;
  xs_struc_widget_planeout *IO_widget_planeout;
  struct lecture_lts *lect_lts;
  Widget IO_load_image_planeout_widget;

  if (filedes != NULL) free(filedes);

  filedes = XmTextGetString (XmFileSelectionBoxGetChild 
			(IO_load_image_file_selection, XmDIALOG_TEXT));

  sprintf (buf,mastertabs[143]);
  write_master (buf);

  if (strlen (filedes) == 0) 
  {
    write_erreur(20);
    return;
  }

  /*mise a jour de la variable globale: repertoire_image*/
  strcpy (repertoire_image, XmTextGetString (XmFileSelectionBoxGetChild 
		(IO_load_image_file_selection, XmDIALOG_FILTER_TEXT)));

  lect_lts = (struct lecture_lts *) malloc (sizeof (struct lecture_lts));

  if ((lect_lts->fp_lts = fopen (filedes, "r")) == NULL) free(lect_lts);
  else 
  {
    strcpy(lect_lts->filename, filedes);
    lect_lts->header = 
           atoi(XmTextGetString (IO_param_file->param->header_length));
    lect_lts->nlignes = 
           atoi(XmTextGetString (IO_param_file->param->No_rows_image));
    lect_lts->nvaleur = 
           atoi(XmTextGetString (IO_param_file->param->No_columns_image));
    lect_lts->nbytes = 
           atoi(XmTextGetString (IO_param_file->param->No_bytes_row));
    lect_lts->bytes_sautes = 
           atoi(XmTextGetString (IO_param_file->param->No_bytes_to_skip_pixel));
  
    IO_widget_planeout = 
    (xs_struc_widget_planeout *) malloc (sizeof (xs_struc_widget_planeout));
    IO_widget_planeout->IO_load_image_file_widget = IO_param_file->filewidget;
    IO_widget_planeout->type = IO_LOAD_RGB;
    IO_widget_planeout->fct_ok_lecture = lire_filergb;
    IO_widget_planeout->fn = NULL;
    IO_widget_planeout->lect_lts = lect_lts;

    IO_load_image_planeout_widget = 
		build_IO_load_image_planeout_widget(IO_widget_planeout, 3, 6);
    XtManageChild (IO_load_image_planeout_widget);
  }
}

/******************************************************
/   okCallback for Widget  IO_load_image_file_selection 
/*****************************************************/

void
IO_load_image_sun_OK_callb(IO_load_image_file_selection, IO_load_image_file_widget, callData)
	Widget IO_load_image_file_selection;
	Widget IO_load_image_file_widget;
	caddr_t callData;
{
  char * filedes;
  struct fname *fn;
  xs_struc_widget_planeout *IO_widget_planeout;
  Widget IO_load_image_planeout_widget;

  if (filedes != NULL) free(filedes);

  filedes = XmTextGetString (XmFileSelectionBoxGetChild 
		(IO_load_image_file_selection, XmDIALOG_TEXT));

  sprintf (buf, mastertabs[137]);
  write_master (buf);

  if (strlen (filedes) == 0) 
  {
    write_erreur(20);
    return;
  }

  /*mise a jour de la variable globale: repertoire_image*/
  strcpy (repertoire_image, XmTextGetString (XmFileSelectionBoxGetChild 
		(IO_load_image_file_selection, XmDIALOG_FILTER_TEXT)));

  fn = lire_fname (filedes, 30);

  if (fn->fpim != NULL) 
  {
    IO_widget_planeout = 
    (xs_struc_widget_planeout *) malloc (sizeof (xs_struc_widget_planeout));
    IO_widget_planeout->IO_load_image_file_widget = IO_load_image_file_widget;
    IO_widget_planeout->type = IO_LOAD_SUN;
    IO_widget_planeout->fct_ok_lecture = lecture_rasterfile;
    IO_widget_planeout->fn = fn;
    IO_widget_planeout->lect_lts = NULL;

    numplans = 1;
    IO_load_image_planeout_widget = 
      build_IO_load_image_planeout_widget(IO_widget_planeout, 1, 0);
  }
  else 
    write_erreur(987);

    XtManageChild (IO_load_image_planeout_widget);
}


/******************************************************
/   okCallback for Widget  IO_load_image_file_selection 
/*****************************************************/

void
IO_load_gel_standard_OK_callb(IO_load_image_file_selection, IO_load_image_file_widget, callData)
	Widget IO_load_image_file_selection;
	Widget IO_load_image_file_widget;
	caddr_t callData;
{
  char * filedes;
  xs_struc_widget_planeout *IO_widget_planeout;
  struct fname *fn;
  int k;
  Widget IO_load_image_planeout_widget;

  filedes = XmTextGetString (XmFileSelectionBoxGetChild 
		(IO_load_image_file_selection, XmDIALOG_TEXT));

  sprintf (buf, mastertabs[136]);
  write_master (buf);

  if (strlen (filedes) == 0) 
  {
    write_erreur(20);
    return;
  }

  /*mise a jour de la variable globale: repertoire_image*/
  strcpy (repertoire_image, XmTextGetString (XmFileSelectionBoxGetChild 
		(IO_load_image_file_selection, XmDIALOG_FILTER_TEXT)));

  Ote_ima_des(&filedes);

  fn = lire_fname (filedes, 10);

  if (fn->fpdesc != NULL && fn->fpim != NULL) 
  { 
    IO_widget_planeout = 
    (xs_struc_widget_planeout *) malloc (sizeof (xs_struc_widget_planeout));
    IO_widget_planeout->IO_load_image_file_widget = IO_load_image_file_widget;
    IO_widget_planeout->type = IO_LOAD_GEL_STANDARD;
    IO_widget_planeout->fct_ok_lecture = read_gel1d_proc;
    IO_widget_planeout->fn = fn;
    IO_widget_planeout->lect_lts = NULL;


    k = read_desc_gel(fn->fpdesc, &desc);
    switch (k){
      case -1: 
        write_erreur(104);
	fclose (fn->fpim);
	fclose(fn->fpdesc);
	XtUnmanageChild (IO_load_image_file_widget);
	return;
      case 0: 
	write_erreur(103);
	fclose (fn->fpim);
	fclose(fn->fpdesc);
	XtUnmanageChild (IO_load_image_file_widget);
	return;
      default: 
	break;
    }

    /*TEST PERMETTANT DE SAVOIR SI UN GEL EST PRETRAITE OU NON !!!!!?!!!?!!*/
    /*on regarde si le type de l'image est byte ou non --                  */
    /*  -->> ce n'est pas du tout bien ni efficace!!!!                     */
    /* voir gel1D_in4.c: lecture_gel1d();                                  */

    if (desc.type) 
    {
      write_erreur(953);
      fclose (fn->fpim);
      fclose(fn->fpdesc);
      XtUnmanageChild (IO_load_image_file_widget);
      return;
    }

    /*Passage des informations au widget IO_load_image_planeout_widget.*/
    IO_load_image_planeout_widget = 
	    build_IO_load_image_planeout_widget(IO_widget_planeout, 1, desc.type);
    XtManageChild (IO_load_image_planeout_widget);
  }
  else 
    write_erreur(987);

  XtFree(filedes);
}


/******************************************************
/   okCallback for Widget  IO_load_image_file_selection 
/*****************************************************/

void
IO_load_gel_melanie_OK_callb(IO_load_image_file_selection, IO_load_image_file_widget, callData)
	Widget IO_load_image_file_selection;
	Widget IO_load_image_file_widget;
	caddr_t callData;
{
  char * dirgel;
  xs_struc_widget_planeout *IO_widget_planeout;
  struct fname *fn;
  int k;
  Widget IO_load_image_planeout_widget;

  dirgel = XmTextGetString (XmFileSelectionBoxGetChild 
		(IO_load_image_file_selection, XmDIALOG_TEXT));

  sprintf (buf, mastertabs[144]);
  write_master (buf);

  if (strlen (dirgel) == 0) 
  {
    write_erreur(20);
    return;
  }

  /*mise a jour de la variable globale: repertoire_image*/
  strcpy (repertoire_image, XmTextGetString (XmFileSelectionBoxGetChild 
		(IO_load_image_file_selection, XmDIALOG_FILTER_TEXT)));

  /* traitement du nom de repertoire 'dirgel'. */
  fn = lire_repertoire_gel (dirgel, 0);

  if (fn->fpdesc != NULL && fn->fpim != NULL) 
  {
    IO_widget_planeout = 
    (xs_struc_widget_planeout *) malloc (sizeof (xs_struc_widget_planeout));
    IO_widget_planeout->IO_load_image_file_widget = IO_load_image_file_widget;
    IO_widget_planeout->type = IO_LOAD_GEL_MELANIE;
    IO_widget_planeout->fct_ok_lecture = read_gel1d_proc;
    IO_widget_planeout->fn = fn;
    IO_widget_planeout->lect_lts = NULL;


    k = read_desc_gel(fn->fpdesc, &desc);
    switch (k)
    {
      case -1: 
        write_erreur(104);
	fclose (fn->fpim);
	fclose(fn->fpdesc);
	XtUnmanageChild (IO_load_image_file_widget);
	return;
      case 0: 
	write_erreur(103);
	fclose (fn->fpim);
	fclose(fn->fpdesc);
	XtUnmanageChild (IO_load_image_file_widget);
	return;
      default: 
	break;
    }

    /*TEST PERMETTANT DE SAVOIR SI UN GEL EST PRETRAITE OU NON !!!!!?!!!?!!*/
    /*on regarde si le type de l'image est byte ou non --                  */
    /*  -->> ce n'est pas du tout bien ni efficace!!!!                     */
    /* voir gel1D_in4.c: lecture_gel1d();                                  */

    if (desc.type) 
    {
      write_erreur(953);
      fclose (fn->fpim);
      fclose(fn->fpdesc);
      XtUnmanageChild (IO_load_image_file_widget);
      return;
    }
	
    /*Passage des informations au widget IO_load_image_planeout_widget.*/
    IO_load_image_planeout_widget = 
	    build_IO_load_image_planeout_widget(IO_widget_planeout, 1, desc.type);
    XtManageChild (IO_load_image_planeout_widget);
  }
  else 
    write_erreur(987);

  XtFree(dirgel);
}
