/* SCCS @(#)ctransfo.c	1.1  12/2/92 */
/*****************************************************************************/
/* module ctransfo.c							     */
/*									     */
/* Author: Markus Buchi							     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1988							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
  
#define INFINI -1

extern unsigned short **c_allouer();
extern c_desallouer();


ouverture(nl, nc, image, taille)
int nl, nc;
unsigned short **image;
short taille;
{
   erosion(nl, nc, image, taille);
   dilatation(nl, nc, image, taille);
}


fermeture(nl, nc, image, taille)
int nl, nc;
unsigned short **image;
short taille;
{
   dilatation(nl, nc, image, taille);
   erosion(nl, nc, image, taille);
}

/*************************************************************************/

/* elimination des trous dans image */

elim_trous(nl, nc, image)
int nl, nc;
unsigned short **image;
{
    unsigned short **ima_temp;

    ima_temp = c_allouer(nl, nc); 

    not_ima(nl, nc, image, image);
    ima_allum(nl, nc, ima_temp);
    b_erosion(nl, nc, ima_temp);
    diff_ima(nl, nc, image, ima_temp, ima_temp);
    condilat(nl, nc, ima_temp, image, INFINI);
    not_ima(nl, nc, ima_temp, image);

    c_desallouer(nl, ima_temp);

} /* end elim_trous */


/*************************************************************************/

/* elimine les particules du bord de l'image */

elim_bord(nl, nc, image)
int nl, nc;
unsigned short **image;
{
    unsigned short **ima_temp;
   
    ima_temp = c_allouer(nl, nc); 

    ima_allum(nl, nc, ima_temp);               /* ima_temp a 1 */
    b_erosion(nl, nc, ima_temp);               /* erosion de taille 1 de ima_temp */
    diff_ima(nl, nc, image, ima_temp, ima_temp);  /* image - ima_temp -> ima_temp */
    condilat(nl, nc, ima_temp, image, INFINI);       /* dilatation de ima_temp infinie conditionnellement a image */
    diff_ima(nl, nc, image, ima_temp, image);

    c_desallouer(nl, ima_temp);

} /* end elim_bord */

/*************************************************************************/

/* contour des objets */

contour(nl, nc, image)

int nl, nc;
unsigned short **image;
{
    unsigned short **ima_temp;
 
    ima_temp = c_allouer(nl, nc);

    copier(nl, nc, image, ima_temp);
    erosion(nl, nc, ima_temp, 1);
    diff_ima(nl, nc, image, ima_temp, image);

    c_desallouer(nl, ima_temp);

} /* end contour */

/****************************************************************/

/* squelette par zone d'influence */

squelz(nl, nc, image)

int nl, nc;
unsigned short **image;
{
    L_epaissir(nl, nc, image, -1);
    E_epaissir(nl, nc, image, -1);
    not_ima(nl, nc, image, image);
}
