/* SCCS @(#)LaboImage.main.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                            LaboImage.main.c                          */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   LaboImage.main.c                                    */
/*                                                                      */
/* DESCRIPTION  :   Interface for LaboImage                             */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <X11/cursorfont.h>

#include "LaboImage.layout.h"
#include "win4.h"
#include "paneltitres.h"
#include "errormessage.h"
#include "menutitres.h"
#include "accelerator.h"
#include "wintab.h"
#include "libwidgets/widgetstructure.h"
#include "icon/labo"

extern GC xs_create_xor_gc();
extern GC xs_create_and_gc();
extern GC xs_create_notand_gc();
static void SetIconPixmap();

char    help_path[80];
char    gLogname[80];
int     english_language;
GC 	default_gc, gc_xor, gc_and, gc_notand;
Display *gDisplay;
Visual  *gVisual;
Window  root_window;
int 	screen_number;

Colormap   gDefaultcolormap;

Cursor  gWatchcursor;

/*****************************************************************************/
/************************************** M A I N ******************************/
/*****************************************************************************/

main(argc, argv)
    unsigned int argc;
    char * argv[];
{
  FILE *log_name;
  Arg arg[2];
  int i;
  Status res;
  XVisualInfo v_info_ret;
  Pixmap icon_pixmap;


  /* choose language */
  if ((argc == 2) && (strcmp(argv[1] ,"-f") == 0))
  {
    english_language = FALSE;
    F_init_mastertabs();
    F_init_labeltabs();
    F_init_paneltabs();
    F_init_error();
    initf1();
    initf2();
  }
  else 
  {
    english_language = TRUE;
    E_init_mastertabs();
    E_init_labeltabs();
    E_init_paneltabs();
    E_init_error();
    inite1();
    inite2();
  }
  
  init_accelerator();
  
  /* set LABOIMAGE environnement variable before running LaboImage ! */
  if (getenv("LABOIMAGE") == NULL){
    printf("%s",mastertabs[500]);
    fflush(stdout);
    exit(0);
  }

  strcpy(help_path, getenv("LABOIMAGE"));

  /*  Initialize Motif Toolkit */

  gLabowidget = XtInitialize(argv,"gLabowidget",NULL,0,&argc,argv);

  /*  Layout toplevel Widget */
  layout_LaboImage(gLabowidget);

  /*  Realize toplevel Widget */
  XtRealizeWidget(gLabowidget);

  gDisplay = XtDisplay(gLabowidget);
  screen_number = XDefaultScreen(gDisplay);
  root_window = XDefaultRootWindow(gDisplay);
  gVisual = XDefaultVisual(gDisplay, screen_number);
  default_gc = XDefaultGC(gDisplay, screen_number);

  icon_pixmap = XCreatePixmap (gDisplay,
			       RootWindowOfScreen(XtScreen(gLabowidget)),
			       labo_width, labo_height, 
			       DefaultDepthOfScreen (XtScreen(gLabowidget)));

  SetIconPixmap(gLabowidget, icon_pixmap);


  res = XMatchVisualInfo(gDisplay, screen_number, 8, PseudoColor, &v_info_ret);
  if (!res)
  {
     printf ("pas de Pseudocolor!\n");
     exit(1);
  }
/*  else
  {
     gVisual = v_info_ret.visual;
  }*/
  gDefaultcolormap = XDefaultColormap(gDisplay, 
				      XDefaultScreen(gDisplay));

  gc_xor = xs_create_xor_gc(gLabowidget);
  gc_and = xs_create_and_gc(gLabowidget); 
  gc_notand = xs_create_notand_gc(gLabowidget);

  /* file image.log is created, it contain the operations done in 
     a LaboImage session */

  strcpy (gLogname, "image.log");
  if ((log_name = fopen(gLogname,"w")) == NULL)
  {
    sprintf (gLogname, "%s/image.log", getenv("HOME"));
    if ((log_name = fopen(gLogname,"w")) == NULL)
    {
      printf("%s",mastertabs[500]);
      fflush(stdout);
      exit(0);
    } 
  }

  /* file image.log is closed and reopened each time we need to write 
     something in. */
  fclose(log_name);

  /* Comments on the main window */
  write_master(mastertabs[311]);
  write_master(mastertabs[312]);
  write_master(mastertabs[313]);
  write_master(mastertabs[314]);
  write_master((char *) get_time());        /* date et heure */
  write_master("\n\n");

  /* Create gWatchcursor */
  gWatchcursor = XCreateFontCursor(gDisplay, XC_watch);

  /*  Process X events */
  XtMainLoop();
}



static 
void SetIconPixmap(shell, pixmap)
Widget shell;
Pixmap pixmap;
{
  Pixmap icon_bitmap;
  Arg arg[3];
  int i;

  icon_bitmap = XCreateBitmapFromData (gDisplay, 
			       RootWindowOfScreen(XtScreen(shell)),
			       labo_bits, labo_width, labo_height);
  XCopyPlane(gDisplay, icon_bitmap, pixmap, 
	     default_gc, 0, 0, 
	     labo_width, labo_height, 0, 0, 1);
	
  i = 0;
  XtSetArg(arg[i],XmNiconPixmap, pixmap); i++;
  XtSetArg(arg[i],XmNtitle, "LaboImage 4.0"); i++;
  XtSetValues(shell, arg,i);

  XFreePixmap (XtDisplay(shell), icon_bitmap);
}


