/*****************************************************************************/
/* module pixedit.c							     */
/*									     */
/* Author: Krassimir TODOROV						     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   August 1989							     */
/* Modifications:							     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
#include "suntool/sunview.h"
#include "suntool/panel.h"
#include "suntool/canvas.h"
#include "suntool/scrollbar.h"
#include "pixrect/pr_line.h"
#include "define.h"
#include "global.h"
#include "structure.h"
#include "type.h"
#include "math.h"
#include "stdio.h"
#include "memory.h"

/* #define IMIT */
#define MY_DEBUG

#ifdef MY_DEBUG
static void
Stop()
{
    int             I = 0;
}
#define Test_Error(error) \
{if (error) {fprintf(stderr,"%cERROR at line %d in %s!\n",\
		    7,__LINE__,__FILE__); Stop();}}
#else
#define Test_Error(error)
#endif

#define abs(x) (((x) < 0) ? (-x) : (x))


#define Adresse(x,y) (y * Width + x)
#define Adresse_P_1(x,y) (y * (Width+Flag_Plus_1) + x)

#define MAX_H		    800
#define MAX_W		    700
#define SCROLL_H	    1
#define SCROLL_V	    2
#define CF		    (double)(255.0/9.0)
#define G_LIN		    0
#define G_LOG		    2
#define DIRECT		    0
#define INVERSE		    1
#define MAGN		    4
#define LOUPE		    64
#define LOUPE_SIZE	    (MAGN*LOUPE)
#define WIDTH_MAX	    500
#define HEIGHT_MAX	    500
#define REGIME_PIXEL	    0
#define REGIME_RECTANGLE    REGIME_PIXEL+1


static struct Loupe_Type
{
    unsigned char   Chars[LOUPE_SIZE][LOUPE_SIZE];
}              *Buf_Loupe;
static char     Str_x[128];
static Scrollbar Scrollbar_H, Scrollbar_V;
static int      Scroll_H, Scroll_V, Regime, Loupe_Displayed;
static Pixwin  *Image_Pixwin, *Magn_Pixwin, *N_Gris_Pixwin;
static Cursor   Image_Cursor, N_Gris_Cursor, Finger_Cursor;
static struct pixrect *Image_Pixrect, *Magn_Pixrect, *N_Gris_Pixrect;
static Panel_item Stat_P_i_X, Stat_P_i_Y, Stat_P_i_C;
static Panel_item Comment_1_i, Comment_2_i, Comment_3_1_i;
static Panel_item Comment_3_2_i, Comment_3_3_i, C_Corr_i;
static unsigned char *VRAM;
static Canvas   Image_Canvas, Magn_Canvas, N_Gris_Canvas;
static char     Map_G_Lin[256], Map_G_Log[256];
static char     Map_G_Lin_I[256], Map_G_Log_I[256];
static int      plan, Affichage, Inverse, Type, Width, Height, Size, Modified;
static int      Curs_X, Curs_Y, Curs_X_Old, Curs_Y_Old, X_Undo, Y_Undo;
Frame           Image_Frame_K;
static Frame    Loupe_Frame;
static char     N_Gris_VRAM[22][512];
static float    Couleur_Corr, G_Min, G_Max, C_Undo, Delta_G;
static int	Flag_Plus_1, XZ1, YZ1, XZ2, YZ2;


extern void hproc_pixeditTool();


/*****************************************************************************/

short           N_Gris_Pixrect_Data_Cursor[] = {
#include "icon/n_gris.cursor"
};
mpr_static(N_Gris_Pixrect_Cursor, 16, 16, 1, N_Gris_Pixrect_Data_Cursor);

short           Mouse_Left_Pixrect_Data_Icon[] = {
#include "icon/mouse_left.icon"
};
mpr_static(Mouse_Left_Pixrect_Icon, 16, 16, 1, Mouse_Left_Pixrect_Data_Icon);

short           Mouse_Mid_Pixrect_Data_Icon[] = {
#include "icon/mouse_mid.icon"
};
mpr_static(Mouse_Mid_Pixrect_Icon, 16, 16, 1, Mouse_Mid_Pixrect_Data_Icon);

short           Mouse_Right_Pixrect_Data_Icon[] = {
#include "icon/mouse_right.icon"
};
mpr_static(Mouse_Right_Pixrect_Icon, 16, 16, 1, Mouse_Right_Pixrect_Data_Icon);

short           Finger_Pixrect_Data_Icon[] = {
#include "icon/finger.icon"
};
mpr_static(Finger_Pixrect_Icon, 16, 16, 1, Finger_Pixrect_Data_Icon);

/*****************************************************************************/

void
Set_Color_Map()
{
    char           *Map;
    switch (Affichage)
    {
    case G_LIN + DIRECT:
	Map = Map_G_Lin;
	sprintf(Str_x, canvastabs[0]);
	break;
    case G_LIN + INVERSE:
	Map = Map_G_Lin_I;
	sprintf(Str_x, canvastabs[0]);
	break;
    case G_LOG + DIRECT:
	Map = Map_G_Log;
	sprintf(Str_x, canvastabs[0]);
	break;
    case G_LOG + INVERSE:
	Map = Map_G_Log_I;
	sprintf(Str_x, canvastabs[0]);
	break;
    }
    pw_setcmsname(Image_Pixwin, Str_x);
    pw_putcolormap(Image_Pixwin, 0, 256, Map, Map, Map);
    pw_setcmsname(N_Gris_Pixwin, Str_x);
    pw_putcolormap(N_Gris_Pixwin, 0, 256, Map, Map, Map);
    if (Buf_Loupe != NULL)
    {
	pw_setcmsname(Magn_Pixwin, Str_x);
	pw_putcolormap(Magn_Pixwin, 0, 256, Map, Map, Map);
    }
}
/*****************************************************************************/

void
Change_Regime_Proc(item, value, event)
    Panel_item      item;
    int             value;
    Event          *event;
{
    int R;
    R = value;
    switch (value)
    {
    case REGIME_PIXEL:
	panel_set(Comment_1_i,
		  PANEL_LABEL_STRING,
		  paneltabs[391],
		  0);
	XZ1 = -1;
	YZ1 = -1;
	Regime = R;
	window_set(Image_Frame_K,
		    WIN_IGNORE_PICK_EVENT, LOC_DRAG, 0);
	break;
    case REGIME_RECTANGLE:
	panel_set(Comment_1_i,
		  PANEL_LABEL_STRING,
		  paneltabs[392],
		  0);
	XZ1 = -1;
	YZ1 = -1;
	Regime = R;
	window_set(Image_Frame_K,
		    WIN_CONSUME_PICK_EVENT, LOC_DRAG, 0);
	break;
    }
}
/*****************************************************************************/

void
Change_Affich_Proc(item, value, event)
    Panel_item      item;
    int             value;
    Event          *event;
{
    switch (value)
    {
    case 0:
	Affichage = (Affichage & INVERSE) + G_LIN;
	break;
    case 1:
	Affichage = (Affichage & INVERSE) + G_LOG;
	break;
    }
    Set_Color_Map();
}
/*****************************************************************************/

static void
Rectangle()
{
    pw_batch_on(Image_Pixwin);
    pw_vector(Image_Pixwin,XZ1,YZ1,XZ2,YZ1,PIX_SRC^PIX_DST,128);
    pw_vector(Image_Pixwin,XZ2,YZ1,XZ2,YZ2,PIX_SRC^PIX_DST,128);
    pw_vector(Image_Pixwin,XZ2,YZ2,XZ1,YZ2,PIX_SRC^PIX_DST,128);
    pw_vector(Image_Pixwin,XZ1,YZ2,XZ1,YZ1,PIX_SRC^PIX_DST,128);
    pw_batch_off(Image_Pixwin);
}

/*****************************************************************************/

static void
Crosshair()
{
    int             I;
    for (I = 0; I < LOUPE_SIZE; I++)
    {
	Buf_Loupe->Chars[LOUPE_SIZE / 2 + MAGN / 2 - 1][I] += 128;
	Buf_Loupe->Chars[I][LOUPE_SIZE / 2 + MAGN / 2 - 1] += 128;
	Buf_Loupe->Chars[LOUPE_SIZE / 2 + MAGN / 2][I] += 128;
	Buf_Loupe->Chars[I][LOUPE_SIZE / 2 + MAGN / 2] += 128;
    }
}
/*****************************************************************************/

void
With_Without_Magn_Proc(item, value, event)
    Panel_item      item;
    int             value;
    Event          *event;
{
    if (!value)
    {
	memset(Buf_Loupe->Chars, 0, LOUPE_SIZE * LOUPE_SIZE);
	Crosshair();
	pw_write(Magn_Pixwin, 0, 0,
		 LOUPE_SIZE, LOUPE_SIZE, PIX_SRC, Magn_Pixrect, 0, 0);
	window_set(Loupe_Frame, WIN_SHOW, TRUE, 0);
	Loupe_Displayed = 1;
    } else
    {
	window_set(Loupe_Frame, WIN_SHOW, FALSE, 0);
	Loupe_Displayed = 0;
    }
}
/*****************************************************************************/

void
Change_Inv_Proc(item, value, event)
    Panel_item      item;
    int             value;
    Event          *event;
{
    switch (value)
    {
    case 0:
	Affichage = (Affichage & (~INVERSE)) + DIRECT;
	break;
    case 1:
	Affichage = (Affichage & (~INVERSE)) + INVERSE;
	break;
    }
    Set_Color_Map();
}
/*****************************************************************************/

static void
Destroy_Pixedit()
{
    window_destroy(Image_Frame_K);
    cursor_destroy(Image_Cursor);
    cursor_destroy(N_Gris_Cursor);
    cursor_destroy(Finger_Cursor);
    if (Buf_Loupe != NULL)
    {
	free(Buf_Loupe);
	Buf_Loupe = NULL;
    }
    if ((Type > 0) || Flag_Plus_1)
	free(VRAM);
    if (Modified)
	statis(dir_image[plan].image,
	       dir_desc[plan].type,
	       dir_desc[plan].nligne,
	       dir_desc[plan].ncolonne,
	       &(dir_desc[plan].mmin),
	       &(dir_desc[plan].mmax),
	       &(dir_desc[plan].mu),
	       &(dir_desc[index_image[1]].ecart));
}


/*****************************************************************************/

static void
Refresh_Loupe()
{
    Crosshair();
    pw_write(Magn_Pixwin, 0, 0,
	     LOUPE_SIZE, LOUPE_SIZE, PIX_SRC, Magn_Pixrect, 0, 0);
    Curs_Y_Old = Curs_Y;
    Curs_X_Old = Curs_X;
}

/*****************************************************************************/

static void
memcpy_n(Adr1,Adr2,N)
char *Adr1, *Adr2;
int N;
{
    if (N <= 0)
	return;
    if (Adr2 > Adr1)
	memcpy(Adr1,Adr2,N);
    else if (Adr2 < Adr1)
    {
	int I;
	Adr1 += N-1;
	Adr2 += N-1;
	for (I = 0 ; I < N ; I++)
	{
	    *Adr1 = *Adr2;
	    Adr1 --;
	    Adr2 --;
	}
    }
}
/*****************************************************************************/

static void
Display_Edit_Window()
{
    int             X, Y, XX, YY, I, J, XMagn, YMagn, Delta_X, Delta_Y;
    int             XXMin, XXMax, YYMin, YYMax, DX, DY;
    u_char          C;
    Crosshair();
    Delta_Y = Curs_Y - Curs_Y_Old;
    Delta_X = Curs_X - Curs_X_Old;
    if ((Curs_X_Old == -1) ||
	(abs(Delta_X) >= LOUPE) || (abs(Delta_Y) >= LOUPE))
    {				/* Entree dans l'image */
	memset(Buf_Loupe->Chars, 0, LOUPE_SIZE * LOUPE_SIZE);
	for (Y = 0, YY = Curs_Y - LOUPE / 2; Y < LOUPE; Y++, YY++)
	{
	    YMagn = Y * MAGN + 4;
	    for (X = 0, XX = Curs_X - LOUPE / 2; X < LOUPE; X++, XX++)
	    {
		if ((XX >= 0) && (XX < Width) &&
		    (YY >= 0) && (YY < Height))
		{
		    C = *(VRAM + Adresse_P_1(XX, YY));
		    XMagn = X * MAGN + 4;
		    for (I = X * MAGN; I < XMagn; I++)
			for (J = Y * MAGN; J < YMagn; J++)
			{
			    Test_Error((I < 0) || (J < 0) ||
				     (I >= LOUPE_SIZE) || (J >= LOUPE_SIZE))
				Buf_Loupe->Chars[J][I] = C;
			}
		}
	    }
	}
	Refresh_Loupe();
	return;
    }
    XXMin = Curs_X_Old - LOUPE / 2;
    XXMax = XXMin + LOUPE;
    if (Delta_Y > 0)
    {				/* Deplacer l'image vers le haut */
	Test_Error(Delta_Y * MAGN > LOUPE_SIZE)
	    memcpy_n(Buf_Loupe->Chars[0],
		   Buf_Loupe->Chars[Delta_Y * MAGN],
		   LOUPE_SIZE * (LOUPE_SIZE - Delta_Y * MAGN));
	YYMin = Curs_Y + LOUPE / 2 - Delta_Y;
	YYMax = Curs_Y + LOUPE / 2;
	if (YYMax > Height)
	{
	    DY = (YYMax - Height) * MAGN;
	    YYMax = Height;
	} else
	    DY = 0;
	YYMin = min(YYMin, YYMax);
	Test_Error(YYMin < 0)
	    Test_Error(YYMin > Height)
	    Test_Error(YYMin > YYMax)
	    for (Y = LOUPE - Delta_Y, YY = YYMin; YY < YYMax; Y++, YY++)
	{
	    YMagn = (Y + 1) * MAGN;
	    for (X = 0, XX = XXMin; X < LOUPE; X++, XX++)
	    {
		if ((XX >= 0) && (XX < Width))
		    C = *(VRAM + Adresse_P_1(XX, YY));
		else
		    C = 0;
		XMagn = (X + 1) * MAGN;
		for (I = X * MAGN; I < XMagn; I++)
		    for (J = Y * MAGN; J < YMagn; J++)
		    {
			Test_Error((I < 0) || (J < 0) ||
				   (I >= LOUPE_SIZE) || (J >= LOUPE_SIZE))
			    Buf_Loupe->Chars[J][I] = C;
		    }
	    }
	}
	Test_Error((DY > LOUPE_SIZE) || (DY < 0))
	    if (DY)
	    memset(Buf_Loupe->Chars[LOUPE_SIZE - DY], 0, DY * LOUPE_SIZE);
    } else if (Delta_Y < 0)
    {				/* Deplacer l'image vers le bas  */
	memcpy_n(Buf_Loupe->Chars[-Delta_Y * MAGN],
	       Buf_Loupe->Chars[0],
	       LOUPE_SIZE * (LOUPE_SIZE + Delta_Y * MAGN));
	Test_Error(-Delta_Y * MAGN > LOUPE_SIZE)
	    YYMin = Curs_Y - LOUPE / 2;
	YYMax = YYMin - Delta_Y;
	if (YYMin < 0)
	{
	    DY = -YYMin;
	    YYMin = 0;
	} else
	    DY = 0;
	YYMax = max(YYMin, YYMax);
	Test_Error(YYMin < 0)
	    Test_Error(YYMin > Height)
	    Test_Error(YYMin > YYMax)
	    for (Y = DY, YY = YYMin; YY < YYMax; Y++, YY++)
	{
	    YMagn = (Y + 1) * MAGN;
	    for (X = 0, XX = XXMin; X < LOUPE; X++, XX++)
	    {
		if ((XX >= 0) && (XX < Width))
		    C = *(VRAM + Adresse_P_1(XX, YY));
		else
		    C = 0;
		XMagn = (X + 1) * MAGN;
		for (I = X * MAGN; I < XMagn; I++)
		    for (J = Y * MAGN; J < YMagn; J++)
		    {
			Test_Error((I < 0) || (J < 0) ||
				   (I >= LOUPE_SIZE) || (J >= LOUPE_SIZE))
			    Buf_Loupe->Chars[J][I] = C;
		    }
	    }
	}
	DY *= MAGN;
	Test_Error((DY > LOUPE_SIZE) || (DY < 0))
	    if (DY)
	    memset(Buf_Loupe->Chars[0], 0, DY * LOUPE_SIZE);
    }
    if (Delta_X)
    {				/* Deplacer l'image vers la gauche */
	XXMin = Curs_X - LOUPE / 2;
	XXMax = XXMin + LOUPE;
	if (Delta_X > 0)
	{
	    XXMin = Curs_X + LOUPE / 2 - Delta_X;
	    if (XXMax > Width)
	    {
		DX = (XXMax - Width);
		XXMax = Width;
	    } else
		DX = 0;
	    XXMin = min(XXMin, XXMax);
	    Test_Error((DX > LOUPE_SIZE) || (DX < 0) || (XXMin < 0) ||
		       (XXMin > Width) || (XXMin > XXMax))
		for (Y = 0; Y < LOUPE_SIZE; Y++)
	    {
		memcpy_n(Buf_Loupe->Chars[Y],
		       &(Buf_Loupe->Chars[Y][Delta_X * MAGN]),
		       LOUPE_SIZE - Delta_X * MAGN);
		if (DX)
		    memset(&Buf_Loupe->Chars[Y][LOUPE_SIZE - DX * MAGN],
			   0, DX * MAGN);
	    }
	    for (Y = 0, YY = Curs_Y - LOUPE / 2; Y < LOUPE; Y++, YY++)
	    {
		YMagn = (Y + 1) * MAGN;
		for (X = LOUPE - Delta_X, XX = XXMin; XX < XXMax; X++, XX++)
		{
		    if ((YY >= 0) && (YY < Height))
			C = *(VRAM + Adresse_P_1(XX, YY));
		    else
			C = 0;
		    XMagn = (X + 1) * MAGN;
		    for (I = X * MAGN; I < XMagn; I++)
			for (J = Y * MAGN; J < YMagn; J++)
			{
			    Test_Error((I < 0) || (J < 0) ||
				     (I >= LOUPE_SIZE) || (J >= LOUPE_SIZE))
				Buf_Loupe->Chars[J][I] = C;
			}
		}
	    }
	} else
	{			/* Deplacer l'image vers la droite */
	    XXMax = Curs_X - LOUPE / 2 - Delta_X;
	    if (XXMin < 0)
	    {
		DX = -XXMin;
		XXMin = 0;
	    } else
		DX = 0;
	    XXMax = max(XXMin, XXMax);
	    Test_Error((DX > LOUPE_SIZE) || (DX < 0) || (XXMin < 0) ||
		       (XXMin > Width) || (XXMin > XXMax))
		for (Y = 0; Y < LOUPE_SIZE; Y++)
	    {
		memcpy_n(&(Buf_Loupe->Chars[Y][-Delta_X * MAGN]),
		       Buf_Loupe->Chars[Y],
		       LOUPE_SIZE + Delta_X * MAGN);
		if (DX)
		    memset(Buf_Loupe->Chars[Y], 0, DX * MAGN);
	    }
	    for (Y = 0, YY = Curs_Y - LOUPE / 2; Y < LOUPE; Y++, YY++)
	    {
		YMagn = (Y + 1) * MAGN;
/*	    for (X = LOUPE + DX , XX = XXMin ; XX < XXMax ; X++ , XX ++) */
		for (X = DX, XX = XXMin; XX < XXMax; X++, XX++)
		{
		    if ((YY >= 0) && (YY < Height))
			C = *(VRAM + Adresse_P_1(XX, YY));
		    else
			C = 0;
		    XMagn = (X + 1) * MAGN;
		    for (I = X * MAGN; I < XMagn; I++)
			for (J = Y * MAGN; J < YMagn; J++)
			{
			    Test_Error((I < 0) || (J < 0) ||
				     (I >= LOUPE_SIZE) || (J >= LOUPE_SIZE))
				if ((I < 0) || (J < 0) ||
				    (I >= LOUPE_SIZE) || (J >= LOUPE_SIZE))
				printf("?error\n");
			    Buf_Loupe->Chars[J][I] = C;
			}
		}
	    }
	}
    }
    Refresh_Loupe();
}
/*****************************************************************************/

static void
Change_1_Pixel(XX, YY, C)
    int             XX, YY;
    char            C;
{
    int             XMin, XMax, YMin, YMax, X, Y;
    unsigned char   CC;
    if ((XX < -LOUPE / 2) || (YY < -LOUPE / 2) ||
	(XX >= LOUPE / 2) || (YY >= LOUPE / 2))
	return;
    XMin = (XX + LOUPE / 2) * MAGN;
    XMax = XMin + MAGN;
    YMin = (YY + LOUPE / 2) * MAGN;
    YMax = YMin + MAGN;
    for (Y = YMin; Y < YMax; Y++)
	for (X = XMin; X < XMax; X++)
	{
	    Test_Error((Y < 0) || (X < 0) || (Y >= Height) || (X >= Width))
		if ((X == LOUPE * MAGN / 2 + MAGN / 2 - 1) ||
		    (X == LOUPE * MAGN / 2 + MAGN / 2))
		if ((Y == LOUPE * MAGN / 2 + MAGN / 2 - 1) ||
		    (Y == LOUPE * MAGN / 2 + MAGN / 2))
		    CC = C;
		else
		    CC = 128 + C;
	    else if ((Y == LOUPE * MAGN / 2 + MAGN / 2 - 1) ||
		     (Y == LOUPE * MAGN / 2 + MAGN / 2))
		CC = 128 + C;
	    else
		CC = C;
	    Buf_Loupe->Chars[Y][X] = CC;
	    pw_put(Magn_Pixwin, X, Y, (int) CC);
	}
}
/*****************************************************************************/

static void
Change_Rectangle_Magn(X1,Y1,X2,Y2,C)
int C;
{
    int X,Y;
    X1 += LOUPE/2;
    X1 *= MAGN;
    X1 = max(0,X1);
    X2 += LOUPE/2;
    X2 *= MAGN;
    X2++;
    X2 = min(X2,LOUPE_SIZE);
    Y1 += LOUPE/2;
    Y1 *= MAGN;
    Y1 = max(0,Y1);
    Y2 += LOUPE/2;
    Y2 *= MAGN;
    Y2++;
    Y2 = min(Y2,LOUPE_SIZE);
    for (Y = Y1 ; Y < Y2 ; Y++)
	for (X = X1 ; X < X2 ; X++)
	    Buf_Loupe->Chars[Y][X] = C;
    pw_write(Magn_Pixwin,X1,Y1,X2-X1-1,Y2-Y1-1,PIX_SRC,Magn_Pixrect,X1,Y1);
}

/*****************************************************************************/

static void
Change_Rectangle()
{
    unsigned char   CC;
/*    float           C; */
    unsigned char  *Adrc;
    short          *Adrs;
    int            *Adri, X, Y, X1, X2, Y1, Y2;
    float          *Adrf;
    X1 = min(XZ1,   XZ2);
    X2 = max(XZ1,   XZ2);
    Y1 = min(YZ1,   YZ2);
    Y2 = max(YZ1,   YZ2);
    switch (Type)
    {
	case -1:
	case 0:
	    Adrc = dir_image[plan].image;
	    for (Y = Y1 ; Y <= Y2 ; Y++)
		for (X = X1 ; X <= X2 ; X++)
		    *(Adrc+Adresse(X,Y)) = (unsigned char) Couleur_Corr;
	    break;
	case 1:
	    Adrs = (short *)dir_image[plan].image;
	    for (Y = Y1 ; Y <= Y2 ; Y++)
		for (X = X1 ; X <= X2 ; X++)
		    *(Adrs+Adresse(X,Y)) = (unsigned short) Couleur_Corr;
	    break;
	case 2:
	    Adri = (int *)dir_image[plan].image;
	    for (Y = Y1 ; Y <= Y2 ; Y++)
		for (X = X1 ; X <= X2 ; X++)
		    *(Adri+Adresse(X,Y)) = (unsigned int) Couleur_Corr;
	    break;
	case 3:
	    Adrf = (float *)dir_image[plan].image;
	    for (Y = Y1 ; Y <= Y2 ; Y++)
		for (X = X1 ; X <= X2 ; X++)
		    *(Adrf+Adresse(X,Y)) = Couleur_Corr;
	}
	CC = (255.0 * (Couleur_Corr - G_Min) / (Delta_G));
	CC --;
	for (Y = Y1 ; Y <= Y2 ; Y++)
	    for (X = X1 ; X <= X2 ; X++)
		*(VRAM + Adresse_P_1(X,Y)) = CC;
	if ((Buf_Loupe != NULL) & Loupe_Displayed)
	    Change_Rectangle_Magn(X1-Curs_X,Y1-Curs_Y,X2-Curs_X,Y2-Curs_Y,CC);
	pw_write(Image_Pixwin,X1,Y1,X2-X1+1,Y2-Y1+1,PIX_SRC,Image_Pixrect,
		    X1,Y1);
	sprintf(Str_x, "%10f", Couleur_Corr);
	panel_set(Stat_P_i_C, PANEL_LABEL_STRING, Str_x, 0);
}
/*****************************************************************************/

static void
PIXEL_Image_Notify_Proc(win, event, arg)
    Window          win;
    Event          *event;
    caddr_t         arg;
{
    int             event_code;
    unsigned char   CC;
    float           C;
    unsigned char  *Adrc;
    short          *Adrs;
    int            *Adri;
    float          *Adrf;
    event_code = event_id(event);
    switch (event_code)
    {
    case LOC_RGNENTER:
	if (Regime == REGIME_RECTANGLE)
	{
	    panel_set(Comment_3_1_i,
		  PANEL_LABEL_STRING, paneltabs[393],
		     0);
	    if (XZ1 == -1)
		panel_set(Comment_2_i,
		    PANEL_LABEL_STRING,paneltabs[394], 
		     0);
	    else
		panel_set(Comment_2_i,
		    PANEL_LABEL_STRING,paneltabs[395], 
		     0);
	    break;
	}
	Curs_X_Old = -1;
	panel_set(Comment_2_i,
		  PANEL_LABEL_STRING, paneltabs[396],
		   0);
	panel_set(Comment_3_1_i,
		  PANEL_LABEL_STRING, paneltabs[397],
		   0);
	if (X_Undo != -1)
	    panel_set(Comment_3_3_i,
		      PANEL_LABEL_STRING, paneltabs[398],
		       0);
	break;
    case LOC_RGNEXIT:
	panel_set(Comment_2_i, PANEL_LABEL_STRING, "", 0);
	panel_set(Comment_3_1_i, PANEL_LABEL_STRING, "", 0);
	panel_set(Comment_3_3_i, PANEL_LABEL_STRING, "", 0);
	break;
    case MS_LEFT:
	if (Regime == REGIME_RECTANGLE)
	{
	    if ((XZ1 == -1) && event_is_down(event))
	    {
		XZ1 = XZ2 = Curs_X;
		YZ1 = YZ2 = Curs_Y;
		panel_set(Comment_2_i,
		    PANEL_LABEL_STRING, paneltabs[395], 
		    0);
		Rectangle();
	    }
	    else if (!event_is_down(event))
	    {
		Rectangle();
		XZ2 = Curs_X;
		YZ2 = Curs_Y;
		panel_set(Comment_2_i,
		    PANEL_LABEL_STRING, paneltabs[394],
		     0);
		Change_Rectangle();
		XZ1 = -1;
		Modified = 1;
	    }
	    break;
	}
	if ((X_Undo == Curs_X) && (Y_Undo == Curs_Y))
	    break;
	if (!event_is_down(event))
	    break;
	if ((Curs_X < 0) || (Curs_X >= Width) ||
	    (Curs_Y < 0) || (Curs_Y >= Height))
	    break;
	Modified = 1;
	panel_set(Comment_3_3_i,
		  PANEL_LABEL_STRING, paneltabs[398],
		  0);
	X_Undo = Curs_X;
	Y_Undo = Curs_Y;
	Test_Error((Curs_X < 0) || (Curs_X >= Width) ||
		   (Curs_Y < 0) || (Curs_Y >= Height))
	switch (Type){
	case -1:
	case 0:
	    Adrc = dir_image[plan].image + Adresse(Curs_X, Curs_Y);
	    C_Undo = (float) *Adrc;
	    *Adrc = (char) Couleur_Corr;
	    break;
	case 1:
	    Adrs =
		(short *) dir_image[plan].image + Adresse(Curs_X, Curs_Y);
	    C_Undo = (float) *Adrs;
	    *Adrs = (unsigned short) Couleur_Corr;
	    break;
	case 2:
	    Adri =
		(int *) dir_image[plan].image + Adresse(Curs_X, Curs_Y);
	    C_Undo = (float) *Adri;
	    *Adri = (unsigned int) Couleur_Corr;
	    break;
	case 3:
	    Adrf =
		(float *) dir_image[plan].image + Adresse(Curs_X, Curs_Y);
	    C_Undo = *Adrf;
	    *Adrf = Couleur_Corr;
	}
	CC = (255.0 * (Couleur_Corr - G_Min) / (Delta_G));
	*(VRAM + Adresse_P_1(Curs_X, Curs_Y)) = CC-1;
	pw_put(Image_Pixwin, Curs_X, Curs_Y, CC-1);
	if ((Buf_Loupe != NULL) & Loupe_Displayed)
	    Change_1_Pixel(0, 0, CC-1);
	sprintf(Str_x, "%10f", Couleur_Corr);
	panel_set(Stat_P_i_C, PANEL_LABEL_STRING, Str_x, 0);
	break;
    case MS_RIGHT:
	if ((X_Undo == -1) || !event_is_down(event))
	    break;
	Test_Error((Curs_X < 0) || (Curs_X >= Width) ||
		   (Curs_Y < 0) || (Curs_Y >= Height))
	    switch (Type)
	{
	case -1:
	case 0:
	    Adrc = dir_image[plan].image + Adresse(X_Undo, Y_Undo);
	    *Adrc = (char) C_Undo;
	    *(VRAM + Adresse_P_1(Curs_X, Curs_Y)) = C_Undo;
	case 1:
	    Adrs =
		(short *) dir_image[plan].image + Adresse(X_Undo, Y_Undo);
	    *Adrs = (unsigned short) C_Undo;
	    break;
	case 2:
	    Adri =
		(int *) dir_image[plan].image + Adresse(X_Undo, Y_Undo);
	    *Adri = (unsigned int) C_Undo;
	    break;
	case 3:
	    Adrf =
		(float *) dir_image[plan].image + Adresse_P_1(X_Undo, Y_Undo);
	    *Adrf = C_Undo;
	    break;
	}
	CC = (255.0 * (C_Undo - G_Min) / (Delta_G));
	*(VRAM + Adresse(X_Undo, Y_Undo)) = CC;
	pw_put(Image_Pixwin, X_Undo, Y_Undo, CC);
	if ((Buf_Loupe != NULL) & Loupe_Displayed)
	    Change_1_Pixel(X_Undo - Curs_X, Y_Undo - Curs_Y, CC-1);
	if ((Curs_X == X_Undo) && (Curs_Y == Y_Undo))
	{
	    sprintf(Str_x, "%10f", C_Undo);
	    panel_set(Stat_P_i_C, PANEL_LABEL_STRING, Str_x, 0);
	}
	X_Undo = -1;
	panel_set(Comment_3_3_i,
		  PANEL_LABEL_STRING, "", 0);
	break;
    case LOC_DRAG:
    case LOC_MOVE:
	Curs_X = event_x(event);
	Curs_Y = event_y(event);
	sprintf(Str_x, "%4d", Curs_X);
	panel_set(Stat_P_i_X, PANEL_LABEL_STRING, Str_x, 0);
	sprintf(Str_x, "%4d", Curs_Y);
	panel_set(Stat_P_i_Y, PANEL_LABEL_STRING, Str_x, 0);
	if ((Curs_X < 0) || (Curs_X >= Width) ||
	    (Curs_Y < 0) || (Curs_Y >= Height))
	{
	    panel_set(Stat_P_i_C, PANEL_LABEL_STRING, "Dehors", 0);
	    break;
	}
	switch (Type)
	{
	case -1:
	case 0:
	    C = *(VRAM + Adresse_P_1(Curs_X, Curs_Y)) + 1;
	    if (C > 255)
	      C = C - 256;
	    break;
	case 1:
	    C = *((unsigned short *) dir_image[plan].image +
		  Adresse(Curs_X, Curs_Y));
	    break;
	case 2:
	    C = *((unsigned int *) dir_image[plan].image +
		  Adresse(Curs_X, Curs_Y));
	    break;
	case 3:
	    C = *((float *) dir_image[plan].image +
		  Adresse(Curs_X, Curs_Y));
	}
	sprintf(Str_x, "%10f", C);
	panel_set(Stat_P_i_C, PANEL_LABEL_STRING, Str_x, 0);
	if ((Buf_Loupe != NULL) & Loupe_Displayed)
	{
	    pw_batch_on(Magn_Pixwin);
	    Display_Edit_Window();
	    pw_batch_off(Magn_Pixwin);
	}
	if ((Regime == REGIME_RECTANGLE) && (XZ1 != -1))
	{
	    Rectangle();
	    XZ2 = Curs_X;
	    YZ2 = Curs_Y;
	    Rectangle();
	}
    }
}
/*****************************************************************************/

static void
Main_Image_Notify_Proc(win, event, arg)
    Window          win;
    Event          *event;
    caddr_t         arg;
{
/*    int             event_code, X, Y, N; */
/*    event_code = event_id(event); */
    switch (Regime)
    {
    case REGIME_PIXEL: case REGIME_RECTANGLE: 
	PIXEL_Image_Notify_Proc(win, event, arg);
	break;
    }
}
/*****************************************************************************/

static void
Draw_Couleur_Corr()
{
    int             N, Y;
    memset(N_Gris_VRAM, 0xff, 512 * 6);
    N = (int) (0.5 + 511.0 * (Couleur_Corr - G_Min) / (G_Max - G_Min));
    N = min(N, 511);
    for (Y = 0; Y < 6; Y++)
	N_Gris_VRAM[Y][N] = 0;
    pw_write(N_Gris_Pixwin, 0, 0, 512, 22, PIX_SRC, N_Gris_Pixrect, 0, 0);
    sprintf(Str_x, "%10f", min(Couleur_Corr, G_Max));
    panel_set_value(C_Corr_i, (caddr_t) Str_x);
}
/*****************************************************************************/

static void
PIXEL_Couleur_Corr_Notify_Proc(win, event, arg)
    Window          win;
    Event          *event;
    caddr_t         arg;
{
    int             event_code, X, Y, N;
    float           C;
    event_code = event_id(event);
    switch (event_code)
    {
    case MS_LEFT:
	X = event_x(event);
	C = G_Min + (float) X *Delta_G / 512;
	if (Type == -1)
	    if ((C - G_Min) < (G_Max - C))
		C = G_Min;
	    else
		C = G_Max;
	else if (Type < 3)
	    C = (int) (C + 0.5);
	Couleur_Corr = C;
	Draw_Couleur_Corr();
	break;
    case LOC_MOVE:
	X = event_x(event);
	C = G_Min + (float) X *Delta_G / 512;
	if (Type == -1)
	    if ((C - G_Min) < (G_Max - C))
		C = G_Min;
	    else
		C = G_Max;
	else if (Type < 3)
	    C = (int) (C + 0.5);
	sprintf(Str_x, "%10f", C);
	panel_set_value(C_Corr_i, (caddr_t) Str_x);
	break;
    case LOC_RGNENTER:
	panel_set(Comment_2_i,
	      PANEL_LABEL_STRING,paneltabs[399], 
	      0);
	panel_set(Comment_3_1_i,
		  PANEL_LABEL_STRING, paneltabs[400],
		   0);
	break;
    case LOC_RGNEXIT:
	panel_set(Comment_2_i, PANEL_LABEL_STRING, "", 0);
	panel_set(Comment_3_1_i, PANEL_LABEL_STRING, "", 0);
	Draw_Couleur_Corr();
	break;
    }
}
/*****************************************************************************/

static void
Main_Couleur_Corr_Notify_Proc(win, event, arg)
    Window          win;
    Event          *event;
    caddr_t         arg;
{
    if (!event_is_down(event))
	return;
    switch (Regime)
    {
    case REGIME_PIXEL: case REGIME_RECTANGLE:
	PIXEL_Couleur_Corr_Notify_Proc(win, event, arg);
	break;
    }
}
/*****************************************************************************/

static void
Set_Couleur_Corr_txt()
{
    float           C;
    C = atof(panel_get_value(C_Corr_i));
    C = max(min(C, G_Max), G_Min);
    if (Type == -1)
	if ((C - G_Min) < (G_Max - C))
	    Couleur_Corr = G_Min;
	else
	    Couleur_Corr = G_Max;
    else if (Type < 3)
	if (Type < 3)
	    Couleur_Corr = (int) (C + 0.5);
	else
	    Couleur_Corr = C;
    Draw_Couleur_Corr();
}
/*****************************************************************************/

static void
Create_Pixedit_Popup()
{
    Panel           Command_Panel;
    char            Str[16];
    Frame           N_Gris_Fr;
    Panel           N_Gris_P;
    Panel_item      P1;
    Panel_item      Comment_3_1_icn, Comment_3_2_icn, Comment_3_3_icn;

    int             X, Y, I, N, Ligne;
    XZ1 = -1;
    YZ1 = -1;
    Buf_Loupe = (struct Loupe_Type *) malloc(LOUPE_SIZE * LOUPE_SIZE);
    if (Buf_Loupe == NULL)
	write_erreur(940);
    else
	memset(Buf_Loupe->Chars, 0, LOUPE_SIZE * LOUPE_SIZE);
    for (I = 0; I < 256; I++)
    {
	Map_G_Lin[I] = (I+1)&0xff;
	Map_G_Lin_I[I] = ~((I+1)&0xff);
	N = (int) (255 * log10((double) ((double) I / CF + (double) 1.0)));
	Map_G_Log[I] = (N+1)&0xff;
	Map_G_Log_I[I] = ~((N+1)&0xff);
	for (Y = 6; Y < 22; Y++)
	{
	    N_Gris_VRAM[Y][I + I] = (I-1)&0xff;
	    N_Gris_VRAM[Y][I + I + 1] = (I-1)&0xff;
	}
    }
    Affichage = G_LIN + DIRECT;
    sprintf(Str_x, "LaboImage - PixelEditTool : [%d] %s",
	    plan, dir_desc[plan].filename);
    Image_Cursor = cursor_create(CURSOR_SHOW_CROSSHAIRS, TRUE,
				 CURSOR_CROSSHAIR_GAP, 5,
				 CURSOR_CROSSHAIR_OP, PIX_SRC ^ PIX_DST,
				 CURSOR_CROSSHAIR_LENGTH, CURSOR_TO_EDGE, 0);
    N_Gris_Cursor = cursor_create(
				  CURSOR_OP, PIX_SRC ^ PIX_DST,
				  CURSOR_IMAGE, &N_Gris_Pixrect_Cursor,
				  CURSOR_XHOT, 8,
				  CURSOR_YHOT, 8,
				  0);
    Finger_Cursor = cursor_create(
				  CURSOR_IMAGE, &Finger_Pixrect_Icon,
				  CURSOR_XHOT, 4,
				  CURSOR_YHOT, 0,
				  0);
#ifdef IMIT
    Image_Frame_K = window_create(NULL, FRAME,
#else
    Image_Frame_K = window_create(frame, FRAME,
#endif
				  FRAME_SUBWINDOWS_ADJUSTABLE, FALSE,
				  FRAME_SHOW_LABEL, TRUE,
				  FRAME_LABEL, Str_x,
				  FRAME_NO_CONFIRM, TRUE,
				  WIN_WIDTH, 1, WIN_HEIGHT, 8,
				  WIN_X, 0, WIN_Y, 0,
				  0);
    Command_Panel = window_create(Image_Frame_K, PANEL,
				  WIN_CURSOR, Finger_Cursor,
				  0);
    switch (dir_desc[plan].type)
    {
    case -1:
	sprintf(Str, "binary");
	break;
    case 0:
	sprintf(Str, "byte");
	break;
    case 1:
	sprintf(Str, "short");
	break;
    case 2:
	sprintf(Str, "int");
	break;
    case 3:
	sprintf(Str, "float");
	break;
    }
    sprintf(Str_x, paneltabs[401],
	    Str, Width, Height);
    panel_create_item(Command_Panel, PANEL_MESSAGE,
		      PANEL_LABEL_STRING, Str_x,
		      PANEL_LABEL_BOLD, TRUE,
		      0);
    strcpy(Str_x, paneltabs[402]);
    P1 = panel_create_item(Command_Panel, PANEL_MESSAGE,
			   PANEL_LABEL_STRING, Str_x,
			   0);
    Ligne = (int) panel_get(P1, PANEL_LABEL_Y);
    Stat_P_i_X = panel_create_item(Command_Panel, PANEL_MESSAGE,
				   PANEL_LABEL_STRING, "....",
			       PANEL_LABEL_X, panel_get(P1, PANEL_LABEL_X) +
				   ATTR_COL(strlen(Str_x)),
				   PANEL_LABEL_Y, Ligne,
				   0);
    panel_create_item(Command_Panel, PANEL_MESSAGE,
		      PANEL_LABEL_STRING, ", Y = ",
		      PANEL_LABEL_X, panel_get(P1, PANEL_LABEL_X) +
		      ATTR_COL(strlen(Str_x) + 4),
		      PANEL_LABEL_Y, Ligne,
		      0);
    Stat_P_i_Y = panel_create_item(Command_Panel, PANEL_MESSAGE,
			       PANEL_LABEL_X, panel_get(P1, PANEL_LABEL_X) +
				   ATTR_COL(strlen(Str_x) + 10),
				   PANEL_LABEL_Y, Ligne,
				   PANEL_LABEL_STRING, "....",
				   0);
    panel_create_item(Command_Panel, PANEL_MESSAGE,
		      PANEL_LABEL_X, panel_get(P1, PANEL_LABEL_X) +
		      ATTR_COL(strlen(Str_x) + 14),
		      PANEL_LABEL_Y, Ligne,
		      PANEL_LABEL_STRING, paneltabs[403],
		      0);
    Stat_P_i_C = panel_create_item(Command_Panel, PANEL_MESSAGE,
			       PANEL_LABEL_X, panel_get(P1, PANEL_LABEL_X) +
				   ATTR_COL(strlen(Str_x) + 26),
				   PANEL_LABEL_Y, Ligne,
				   PANEL_LABEL_STRING, "..........",
				   0);
    N_Gris_Fr = window_create(Image_Frame_K, FRAME,
			      FRAME_SUBWINDOWS_ADJUSTABLE, FALSE,
			      FRAME_NO_CONFIRM, TRUE,
			      0);
    N_Gris_P = window_create(N_Gris_Fr, PANEL,
			     0);
    sprintf(Str_x, "%10f", Couleur_Corr);
    C_Corr_i =
	panel_create_item(N_Gris_P, PANEL_TEXT,
			  PANEL_LABEL_STRING, paneltabs[404],
			  PANEL_VALUE, Str_x,
			  PANEL_NOTIFY_PROC, Set_Couleur_Corr_txt,
			  PANEL_VALUE_DISPLAY_LENGTH, 10,
			  0);
    sprintf(Str_x, "[Min = %10f, Max = %10f]", G_Min, G_Max);
    panel_create_item(N_Gris_P, PANEL_MESSAGE,
		      PANEL_LABEL_STRING, Str_x,
		      0);
    window_fit(N_Gris_P);
    N_Gris_Canvas = window_create(N_Gris_Fr, CANVAS,
				  CANVAS_RETAINED, FALSE,
				  WIN_CURSOR, N_Gris_Cursor,
			      WIN_EVENT_PROC, Main_Couleur_Corr_Notify_Proc,
				  WIN_HEIGHT, 22,
				  WIN_WIDTH, 512,
				  WIN_BELOW, N_Gris_P,
				  WIN_X,
		 max(0, ((int) window_get(N_Gris_P, WIN_WIDTH) - 512) >> 1),
				  0);
    window_fit(N_Gris_Canvas);
    window_fit(N_Gris_Fr);
    sprintf(Str_x, paneltabs[405],
	     MAGN);
    if (Buf_Loupe->Chars != NULL)
	panel_create_item(Command_Panel, PANEL_CHOICE,
			  PANEL_LABEL_STRING, Str_x,
			  PANEL_CHOICE_STRINGS,
			  paneltabs[406],paneltabs[407],
			  0,
			  PANEL_NOTIFY_PROC, With_Without_Magn_Proc,
			  0);
    else
	Loupe_Displayed = 0;
  panel_create_item(Command_Panel,PANEL_CHOICE,
		      PANEL_LABEL_STRING, paneltabs[408],
		      PANEL_CHOICE_STRINGS, "Pixel","Rectangle",0,
		      PANEL_NOTIFY_PROC, Change_Regime_Proc,
                     0);
    panel_create_item(Command_Panel, PANEL_CHOICE,
		      PANEL_LABEL_STRING, paneltabs[409],
		      PANEL_CHOICE_STRINGS,
		      paneltabs[410], paneltabs[411],
		      0,
		      PANEL_NOTIFY_PROC, Change_Affich_Proc,
		      0);
    panel_create_item(Command_Panel, PANEL_CHOICE,
		      PANEL_LABEL_STRING, paneltabs[412],
		      PANEL_CHOICE_STRINGS,
		      paneltabs[413], paneltabs[414], 0,
		      PANEL_NOTIFY_PROC, Change_Inv_Proc,
		      0);
    Comment_1_i = panel_create_item(Command_Panel, PANEL_MESSAGE,
				    PANEL_LABEL_STRING,
				    paneltabs[415],
				    0);
    Comment_2_i = panel_create_item(Command_Panel, PANEL_MESSAGE,
				    PANEL_LABEL_BOLD, TRUE,
				    PANEL_LABEL_STRING,
		      "                                                   ",
				    0);
    Comment_3_1_icn = panel_create_item(Command_Panel, PANEL_MESSAGE,
				PANEL_LABEL_IMAGE, &Mouse_Left_Pixrect_Icon,
					PANEL_LABEL_X, ATTR_COL(1),
					0);
    Y = (int) panel_get(Comment_3_1_icn, PANEL_LABEL_Y);
    Comment_3_1_i = panel_create_item(Command_Panel, PANEL_MESSAGE,
				      PANEL_LABEL_BOLD, TRUE,
				      PANEL_LABEL_STRING, "          ",
				      PANEL_LABEL_X, ATTR_COL(4),
				      PANEL_LABEL_Y, Y,
				      0);
    Comment_3_2_icn = panel_create_item(Command_Panel, PANEL_MESSAGE,
				 PANEL_LABEL_IMAGE, &Mouse_Mid_Pixrect_Icon,
					PANEL_LABEL_X, ATTR_COL(21),
					PANEL_LABEL_Y, Y,
					0);
    Comment_3_2_i = panel_create_item(Command_Panel, PANEL_MESSAGE,
				      PANEL_LABEL_BOLD, TRUE,
				      PANEL_LABEL_STRING, "          ",
				      PANEL_LABEL_X, ATTR_COL(24),
				      PANEL_LABEL_Y, Y,
				      0);
    Comment_3_3_icn = panel_create_item(Command_Panel, PANEL_MESSAGE,
			       PANEL_LABEL_IMAGE, &Mouse_Right_Pixrect_Icon,
					PANEL_LABEL_X, ATTR_COL(41),
					PANEL_LABEL_Y, Y,
					0);
    Comment_3_3_i = panel_create_item(Command_Panel, PANEL_MESSAGE,
				      PANEL_LABEL_BOLD, TRUE,
				      PANEL_LABEL_STRING, "          ",
				      PANEL_LABEL_X, ATTR_COL(44),
				      PANEL_LABEL_Y, Y,
				      0);
    strcpy(Str_x, paneltabs[416]
    );
    panel_create_item(Command_Panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE, panel_button_image(Command_Panel,
							    Str_x,
							  strlen(Str_x), 0),
		      PANEL_NOTIFY_PROC, Destroy_Pixedit,
		      0);
    window_fit(Command_Panel);
    Image_Canvas = window_create(Image_Frame_K, CANVAS,
/*				 WIN_CONSUME_PICK_EVENT, LOC_DRAG, */
				 WIN_CURSOR, Image_Cursor,
				 CANVAS_RETAINED, FALSE,
				 CANVAS_AUTO_SHRINK, FALSE,
				 WIN_EVENT_PROC, Main_Image_Notify_Proc,
				 WIN_HEIGHT, Height,
				 WIN_WIDTH, Width,
				 CANVAS_HEIGHT, Height,
				 CANVAS_WIDTH, Width,
				 WIN_X, 0,
				 WIN_BELOW, Command_Panel,
				 0);
    if (Scroll_H)
    {
	window_set(Image_Canvas,
		   WIN_HORIZONTAL_SCROLLBAR, Scrollbar_H,
		   WIN_WIDTH, WIDTH_MAX,
		   WIN_HEIGHT,
		    (int)window_get(Image_Canvas, WIN_HEIGHT) +
		    (int)scrollbar_get(Scrollbar_H, SCROLL_THICKNESS),
		   0);
    }
    if (Scroll_V)
    {
	window_set(Image_Canvas,
		   WIN_VERTICAL_SCROLLBAR, Scrollbar_V,
		   WIN_HEIGHT, HEIGHT_MAX,
		   WIN_WIDTH,
		    (int)window_get(Image_Canvas, WIN_WIDTH) +
		    (int)scrollbar_get(Scrollbar_V, SCROLL_THICKNESS),
		   0);
    }
    window_fit(Image_Canvas);
    window_fit(Image_Frame_K);
    Image_Pixwin = (Pixwin *) canvas_pixwin(Image_Canvas);
    N_Gris_Pixwin = (Pixwin *) canvas_pixwin(N_Gris_Canvas);
    if (Buf_Loupe != NULL)
    {
	sprintf(Str_x, paneltabs[417],
		MAGN);
	Loupe_Frame = window_create(Image_Frame_K, FRAME,
				    FRAME_SUBWINDOWS_ADJUSTABLE, FALSE,
				    FRAME_SHOW_LABEL, TRUE,
				    FRAME_LABEL, Str_x,
				    FRAME_NO_CONFIRM, TRUE,
				    WIN_RIGHT_OF, Image_Frame_K,
				    WIN_Y, 0,
				    0);
	Magn_Canvas = window_create(Loupe_Frame, CANVAS,
				    CANVAS_RETAINED, FALSE,
				    WIN_HEIGHT, LOUPE_SIZE,
				    WIN_WIDTH, LOUPE_SIZE,
				    0);
	window_fit(Magn_Canvas);
	window_fit(Loupe_Frame);
	Magn_Pixwin = (Pixwin *) canvas_pixwin(Magn_Canvas);
    }
    if (Flag_Plus_1)
	Image_Pixrect = mem_point(Width+1, Height, 8, VRAM);
    else
	Image_Pixrect = mem_point(Width, Height, 8, VRAM);
    N_Gris_Pixrect = mem_point(512, 22, 8, N_Gris_VRAM);
    Draw_Couleur_Corr();
    if (Buf_Loupe != NULL)
    {
	for (I = 0; I < LOUPE_SIZE; I++)
	{
	    Buf_Loupe->Chars[LOUPE_SIZE / 2 + 1][I] += 128;
	    Buf_Loupe->Chars[I][LOUPE_SIZE / 2 + 1] += 128;
	}
	Magn_Pixrect = mem_point(LOUPE_SIZE, LOUPE_SIZE, 8, (char *) Buf_Loupe);
	pw_write(Magn_Pixwin,
		 0, 0, LOUPE_SIZE, LOUPE_SIZE, PIX_SRC, Magn_Pixrect, 0, 0);
    }
    Set_Color_Map();
    window_set(Image_Canvas, CANVAS_RETAINED, TRUE, 0);
    window_set(N_Gris_Canvas, CANVAS_RETAINED, TRUE, 0);
    window_set(Magn_Canvas, CANVAS_RETAINED, TRUE, 0);
    if (Flag_Plus_1)
	pw_write(Image_Pixwin, 0, 0, Width+1, Height,
		PIX_SRC, Image_Pixrect, 0, 0);
    else
	pw_write(Image_Pixwin, 0, 0, Width, Height,
		PIX_SRC, Image_Pixrect, 0, 0);
    pw_write(N_Gris_Pixwin, 0, 0, 512, 22,
	     PIX_SRC, N_Gris_Pixrect, 0, 0);
    pw_write(Magn_Pixwin, 0, 0, 256, 256,
	     PIX_SRC, Magn_Pixrect, 0, 0);
    window_set(N_Gris_Fr, WIN_X, 0,
	       WIN_BELOW, Image_Frame_K,
	       WIN_SHOW, TRUE,
	       0);
    window_set(Loupe_Frame, WIN_SHOW, TRUE, 0);
#ifdef IMIT
#else
    window_set(Image_Frame_K, WIN_SHOW, TRUE, 0);
#endif
}
/*****************************************************************************/

static int
Make_Copy_Image()
{
    int             SSize, LL, I;
    unsigned char  *Adr, *Adrc;
    unsigned short *Adrs;
    unsigned int   *Adri;
    float          *Adrf;
    Flag_Plus_1 = 0;
/*
    if (((Type == 0) || (Type == -1)) && !(Width & 1))
    {
	VRAM = (unsigned char *) dir_image[plan].image;
	return(0);
    }
*/
/*    if (((Type == 0) || (Type == -1)) && (Width & 1)) */
    if (Width & 1)
	Flag_Plus_1 = 1;
    SSize = (Width+Flag_Plus_1) * Height;
    VRAM = (unsigned char *) malloc(SSize);
    if (VRAM == NULL)
    {
	write_erreur(900);
	return (1);
    }
    Adr = VRAM;
    Delta_G = G_Max - G_Min;
    switch (Type)
    {
    case -1 :
    case  0:
	Adrc = (unsigned char *) dir_image[plan].image;
/*
	for (I = 0; I < Height; I++, Adrc += Width, Adr += Width+1)
	{
	    memcpy(Adr ,Adrc ,Width);
	    *(Adr + Width) = 0;
	}
*/
	for (I = 0; I < SSize; I++, Adr++, Adrc++)
	{
	    *Adr = (unsigned char)(*Adrc-1);
	    if ((I % dir_desc[plan].ncolonne) == dir_desc[plan].ncolonne-1)
		Adr += Flag_Plus_1;
	}
	break;
    case 1:
	Adrs = (unsigned short *) dir_image[plan].image;
	for (I = 0; I < SSize; I++, Adr++, Adrs++)
	{
	    *Adr = (255.0 * ((float) *Adrs - G_Min) / (Delta_G));
	    *Adr --;
	    if ((I % dir_desc[plan].ncolonne) == dir_desc[plan].ncolonne-1)
		Adr += Flag_Plus_1;
	}
	break;
    case 2:
	Adri = (unsigned int *) dir_image[plan].image;
	for (I = 0; I < SSize; I++, Adr++, Adri++)
	{
	    *Adr = (255.0 * ((float) *Adri - G_Min) / (Delta_G));
	    *Adr --;
	    if ((I % dir_desc[plan].ncolonne) == dir_desc[plan].ncolonne-1)
		Adr += Flag_Plus_1;
	}
	break;
    case 3:
	Adrf = (float *) dir_image[plan].image;
	for (I = 0; I < SSize; I++, Adr++, Adri++)
	{
	    *Adr = (255.0 * (*Adrf - G_Min) / (Delta_G));
	    *Adr --;
	    if ((I % dir_desc[plan].ncolonne) == dir_desc[plan].ncolonne-1)
		Adr += Flag_Plus_1;
	}
    }
    return (0);
}
/*****************************************************************************/

static void
pixel_edit_tool()
{
    int             N;
    float           CC;
    Type = dir_desc[plan].type;
    if ((Type == 4) || (Type == 5))
    {
	write_erreur(941);
	return;
    }
    if (Type == 6)
    {
	write_erreur(942);
	return;
    }
    switch (Type)
    {
    case -1:
	CC = dir_desc[plan].mu;
	if ((CC - G_Min) < (G_Max - CC))
	    Couleur_Corr = G_Min;
	else
	    Couleur_Corr = G_Max;
	break;
    case 0:
    case 1:
    case 2:
	Couleur_Corr = (int) (dir_desc[plan].mu + 0.5);
	break;
    case 3:
	Couleur_Corr = dir_desc[plan].mu;
    }
    Modified = 0;
    Delta_G = 256;
    G_Min = dir_desc[plan].mmin;
    G_Max = dir_desc[plan].mmax;
    Width = dir_desc[plan].ncolonne;
    Height = dir_desc[plan].nligne;
    Size = Width * Height;
    Loupe_Displayed = 1;
    Regime = REGIME_PIXEL;
    if (Width > WIDTH_MAX)
    {
	Scroll_H = 1;
	Scrollbar_H = scrollbar_create(0);
    } else
	Scroll_H = 0;
    if (Height > HEIGHT_MAX)
    {
	Scroll_V = 1;
	Scrollbar_V = scrollbar_create(0);
    } else
	Scroll_V = 0;
    X_Undo = -1;
    CC = 256.0 / (G_Max - G_Min);
    Curs_X_Old = -1;
    switch (Type)
    {
    case 0:
	G_Min = 0.0;
	G_Max = 255.0;
    case -1:
    case 1:
    case 2:
    case 3:
	if (Make_Copy_Image())
	    return;
    }
    Create_Pixedit_Popup();
}
/*****************************************************************************/

caddr_t
proc_pixedit(m, mi)
    Menu            m;
    Menu_item       mi;
{
    struct commande *com;

    if (flag_bother){
	hproc_pixeditTool();
	return;
    }
    if (flag_help) hproc_pixeditTool();
    if (flag_creer)
    {
	com = (struct commande *) new_commande(&macro_cour);
	strcpy(com->nom, "PIXEDIT");
	com->code = 3020;
    } else
    {
	sprintf(buf, "PixelEditTool : ");
	write_master(buf);
    }
    if ((flag_exec == FROMTO_AUTO) || (flag_exec == AUTO))
	index_image[0] = macro_cour->from[0];
    else
	fromto(FROM, DEFAUT);
    plan = index_image[0];
    if (flag_break)
    {
	interruption();
	return ((caddr_t) 0);
    }
    if (flag_creer)
    {
	com->from[0] = plan;
	sprintf(buf, "%s FROM %d\n", com->nom, plan);
	write_macro(buf);
	return ((caddr_t) 0);
    }
    sprintf(buf, "-->%d\n", plan);
    write_master(buf);
    if (dir_image[plan].image == NULL)
    {
	write_erreur(9);
	return ((caddr_t) 0);
    }
    pixel_edit_tool();
}
#undef MAX_H
#undef MAX_W
#undef SCROLL_H
#undef SCROLL_V
#undef CF
#undef G_LIN
#undef G_LOG
#undef DIRECT
#undef INVERSE
#undef MAGN
#undef LOUPE
#undef LOUPE_SIZE
#undef WIDTH_MAX
#undef HEIGHT_MAX
#undef REGIME_PIXEL
#undef REGIME_RECTANGLE

#ifdef IMIT
#undef IMIT
#endif

#ifdef MY_DEBUG
#undef MY_DEBUG
#endif
#undef MY_DEBUG
