/*****************************************************************************/
/* module convert.c							     */
/*									     */
/* Author: Alain Jacot-Descombes					     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1989							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <math.h>

#include "define.h"
#include "structure.h"
#include "global.h"
#include "type.h"

#define MAXFLOAT       ((float)1.7014118219281863150e+38)
#define MINFLOAT (-MAXFLOAT)

Panel_item  minarr, maxarr, mindep, maxdep;
Panel	    panel_convert, panel_seuil;
Frame	    frame_convert, frame_seuil;
Panel_item  barre_seuil, bouton_ok, bouton_cancel;
int	val_seuil, flag_compl = FALSE;
char	rep[80];

extern void hproc_conv_byte();
extern void hproc_conv_short();
extern void hproc_conv_integer();
extern void hproc_conv_float();
extern void hproc_conv_complex();
extern void hproc_conv_cartpol();
extern void hproc_conv_polcart();

extern char *paneltabs[];
extern char *mastertabs[];
extern char *labeltabs[];
/*****************************************************************************/

static Panel_setting lire_float (item, event)
    Panel_item item;
    Event *event;

{
    static struct convert conv;

    if (event_id(event) == CTRLC) {
        /* demande d'interruption de l'interaction par l'utilisateur */
	flag_break = TRUE;
        window_return (NULL);
        window_destroy (frame_convert);
        return;
    }
    else { 
        if (event_id(event) == '\t') 
	    return(PANEL_NEXT);
	else {
	    strcpy (rep, (char *)panel_get(mindep,PANEL_VALUE));
	    if (flag_creer && strcmp(rep, "MIN") == 0){
		conv.mind = 0;
		conv.flag_mind = TRUE;	
	    }
	    else {
		conv.mind = atof((char *)panel_get(mindep, PANEL_VALUE));
		conv.flag_mind = FALSE;	
	    }
	    strcpy (rep, (char *)panel_get(maxdep,PANEL_VALUE));
	    if (flag_creer && strcmp(rep, "MAX") == 0){
		conv.maxd = 0;
		conv.flag_maxd = TRUE;	
	    }
	    else {
		conv.maxd = atof((char *)panel_get(maxdep, PANEL_VALUE));
		conv.flag_maxd = FALSE;	
	    }
	    strcpy (rep, (char *)panel_get(minarr,PANEL_VALUE));
	    if (flag_creer && strcmp (rep, "MIN") == 0){
		conv.mina = 0;
		conv.flag_mina = TRUE;	
	    }
	    else {
		conv.mina = atof((char *)panel_get(minarr, PANEL_VALUE));
		conv.flag_mina = FALSE;	
	    }
	    strcpy (rep, (char *)panel_get(maxarr,PANEL_VALUE));
	    if (flag_creer && strcmp(rep, "MAX") == 0){
		conv.maxa = 0;
		conv.flag_maxa = TRUE;	
	    }
	    else {
		conv.maxa = atof((char *)panel_get(maxarr, PANEL_VALUE));
		conv.flag_maxa = FALSE;	
	    }
            window_return(&conv);
	    window_destroy (frame_convert);
	    return;
	}
    }
}

/*****************************************************************************/

completer (stitre, select)

    char stitre[40];
    int select;
    
{
    switch (select) {
        case -1:
	case 0: strcat (stitre, "'BYTE'"); break;
	case 1: strcat (stitre, "'SHORT'"); break;
	case 2: strcat (stitre, "'INT'"); break;
	case 3: strcat (stitre, "'FLOAT'"); break;
    }
    return;
}

/*****************************************************************************/

struct convert *convert_panel (nodep, type_arr)
    short type_arr, nodep;
{
    Panel_item titre;
    char *repfloat;
    char stitre[40];
    struct convert *conv;

    repfloat = (char *)malloc(20);
    frame_convert = window_create (frame, FRAME, WIN_X, 500, WIN_Y, 500,
                         FRAME_NO_CONFIRM, TRUE, 0);
    panel_convert = window_create (frame_convert, PANEL, PANEL_LABEL_BOLD,
			 TRUE, 0);

    strcpy (stitre, paneltabs[21]);
    completer (stitre, dir_desc[nodep].type);
    strcat (stitre, paneltabs[22]);
    completer (stitre, type_arr);
    strcat (stitre, "\n");
    titre = panel_create_item (panel_convert, PANEL_MESSAGE,
                       PANEL_SHOW_ITEM, TRUE,
                       PANEL_LABEL_STRING, stitre,
                       0);
    if (flag_creer) sprintf (repfloat, "MIN");
    else sprintf (repfloat, "%f", dir_desc[nodep].mmin);  
    mindep = panel_create_item (panel_convert, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[23],
                       PANEL_VALUE, repfloat,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_float,
                       0);
    if (flag_creer) sprintf (repfloat, "MAX");
    else sprintf (repfloat, "%f", dir_desc[nodep].mmax);  
    maxdep = panel_create_item (panel_convert, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[24],
                       PANEL_VALUE, repfloat,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_float,
                       0);
    if (flag_creer) sprintf (repfloat, "MIN");
    else
	if (dir_desc[nodep].type < type_arr)
	    sprintf (repfloat, "%f", dir_desc[nodep].mmin);
	else
	    sprintf (repfloat, "0");  
    minarr = panel_create_item (panel_convert, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[25],
                       PANEL_VALUE, repfloat,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_float,
                       0);
    if (flag_creer) sprintf (repfloat, "MAX");
    else 
	if (dir_desc[nodep].type < type_arr)
	    sprintf (repfloat, "%f", dir_desc[nodep].mmax);
	else
	    sprintf (repfloat, "255");  
    maxarr = panel_create_item (panel_convert, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[26],
                       PANEL_VALUE, repfloat,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_float,
                       0);
    window_fit (panel_convert);
    window_fit (frame_convert);
    window_set (panel_convert, PANEL_CARET_ITEM, mindep, 0);
    conv = (struct convert *)window_loop(frame_convert);
    free(repfloat);
    return(conv);
}

/*****************************************************************************/
/*									     */
/* nom      : convert_byte						     */
/*									     */
/* fonction : convertit l'image dir_image[no_dep].image en byte et la	     */
/*	      stocke dans dir_image[no_arr].image.			     */
/*                                                                           */
/* entrees  : int no_dep	        : no du plan-image de depart         */
/*            int no_arr	        : no du plan-image d'arrivee         */
/*                                                                           */
/* globales : dir_desc							     */
/*	      dir_image							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : statis							     */
/*									     */
/*****************************************************************************/

int convert_byte ()

{
    unsigned char *im, *debut;
    register int j;
    int taille, no_dep, no_arr;
    register float delta, minim;
    register int minarr;
    struct convert *conv, *copyconv;


    if (flag_bother){
	hproc_conv_byte();
	return;
    }
    if (flag_help) hproc_conv_byte();
    if (!flag_creer){
	sprintf (buf, mastertabs[26]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	no_dep = index_image[0] = macro_cour->from[0];
	no_arr = index_image[1] = macro_cour->to[0];
    }
    else {
	fromto (FROMTO, DEFAUT);
	no_dep = index_image[0];
	no_arr = index_image[1];
    }
    if (flag_break) interruption();
    else{ /* !flag_break */
	if (!flag_creer){
	    sprintf(buf," %d --> %d ",index_image[0],index_image[1]);
	    write_master (buf);
	}
	if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	    conv = (struct convert *)malloc(sizeof(*conv));
	    *conv = *((struct convert *)macro_cour->param);
	}
	else
	    conv = convert_panel (no_dep, 0);
	if (flag_break) interruption();
	else{ /* !flag_break */
	    if (flag_creer){
		struct commande *com;
		com = (struct commande *)new_commande(&macro_cour);
		sprintf (com->nom, "AUXCONBYT");
		com->code = 21;
		com->from[0] = no_dep;
		com->to[0] = no_arr;
		sprintf (buf,"AUXCONBYT FROM %d TO %d WITH",no_dep,no_arr);
		if (conv->flag_mind) strcat (buf, " MIN");
		else strcat (buf,sprintf(rep," %f", conv->mind)); 
		if (conv->flag_maxd) strcat (buf, " MAX");
		else strcat (buf,sprintf(rep," %f", conv->maxd));
		if (conv->flag_mina) strcat (buf, " MIN");
		else strcat (buf,sprintf(rep," %f", conv->mina)); 
		if (conv->flag_maxa) strcat (buf, " MAX\n");
		else strcat (buf,sprintf(rep," %f\n", conv->maxa)); 
		write_macro(buf);
		copyconv = (struct convert *)malloc(sizeof(*copyconv));
		*copyconv = *conv;
		com->param = (char *)copyconv;
	    }
	    else {  /* !flag_creer */
		if (dir_image[index_image[0]].image == NULL){
		    write_erreur(1);
		    return;
		}

		taille = dir_desc[no_dep].ncolonne * dir_desc[no_dep].nligne;
		debut = im = (unsigned char *) malloc (taille);
		if (conv->flag_mind) conv->mind = dir_desc[no_dep].mmin;
		if (conv->flag_maxd) conv->maxd = dir_desc[no_dep].mmax;
		if (conv->flag_mina) conv->mina = dir_desc[no_dep].mmin;
		if (conv->flag_maxa) conv->maxa = dir_desc[no_dep].mmax;
		sprintf (buf, "(%.2f,%.2f -> %.2f,%.2f)\n", 
			conv->mind, conv->maxd, conv->mina, conv->maxa);
		write_master (buf);
		if (dir_desc[no_dep].mmin>=MINBYTE && 
		    dir_desc[no_dep].mmax<=MAXBYTE &&
		    dir_desc[no_dep].mmin==conv->mind&&conv->mind==conv->mina&&
		    dir_desc[no_dep].mmax==conv->maxd&&conv->maxd==conv->maxa)
		{
		    /* image depart comprise dans l'intervalle des byte */
		    /* +pas changement dynamique = convertir avec les "cast" */
		    switch (dir_desc[no_dep].type) {
			case -1:
			case 0 : {  
			    /* image de depart de type unsigned char(recopie)*/
			    unsigned char *b;
			    b = (unsigned char *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (unsigned char)*b;
				im++;  b++;
			    }
			    break;
			}        
			case 1 : {   /* image de depart de type short */
			    short *s;
			    s = (short *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (unsigned char)*s;
				im++;  s++;
			    }
			    break; 
			}       
			case 2 : {   /* image de depart de type int */
			    int *i;
			    i = (int *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (unsigned char)*i;
				im++;  i++;
			    }
			    break;
			}        
			case 3 : {   /* image de depart de type float */
			    float *f;
			    f = (float *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (unsigned char)*f;
				im++;  f++;
			    }
			    break;
			}
		    }
		    /* les statistiques de l'image d'arrivee sont inchangees */
		    if (dir_image[no_arr].image != NULL)
			free(dir_image[no_arr].image);
		    dir_image[no_arr].image = (unsigned char *)debut;
		    dir_desc[no_arr]  = dir_desc[no_dep];
		    dir_desc[no_arr].type = 0;
		}
		else { /* else with if dir_desc..... */
		    /* on fait une regle de trois en etalant la dynamique de */
		    /* l'intervalle de depart sur la dynamique choisie	*/
		    delta=(conv->maxa - conv->mina)/(conv->maxd - conv->mind);
		    minim = conv->mind;
		    minarr = (int)conv->mina;
		    switch (dir_desc[no_dep].type) {
			case -1:
			case 0 : {   /* l'image de depart est de type byte */
			    unsigned char *b, bb;
			    b = (unsigned char *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*b > conv->maxd) bb = conv->maxd;
				else if (*b < conv->mind) bb = conv->mind;
			    	else bb = *b;
				*im = (unsigned char)
				    (((bb - minim) * delta + minarr) + 0.5);
				im++;  b++;
			    }
			    break;
			}
			case 1 : {   /* image de depart de type short */
			    short *s, ss;
			    s = (short *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*s > conv->maxd) ss = conv->maxd;
				else if (*s < conv->mind) ss = conv->mind;
				else ss = *s;
				*im = (unsigned char)
				    (((ss - minim) * delta + minarr) + 0.5);
				im++;  s++;
			    }
			    break;
			}
			case 2 : {   /* image de depart de type int */
			    int *i, ii;
			    i = (int *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*i > conv->maxd) ii = conv->maxd;
				else if (*i < conv->mind) ii = conv->mind;
				else ii = *i;
				*im = (unsigned char)
				    (((ii - minim) * delta + minarr) + 0.5);
				im++;  i++;
			    }
			    break;
			}
			case 3 : {   /* image de depart de type float */
			    float *f, ff;
			    f = (float *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*f > conv->maxd) ff = conv->maxd;
				else if (*f < conv->mind) ff = conv->mind;
				else ff = *f;
				*im = (unsigned char)
				    (((ff - minim) * delta + minarr) + 0.5);
				im++;  f++;
			    }
			    break;
			}
		    }
		    /* on doit recalculer les statistiques de l'image */    
		    if (dir_image[no_arr].image != NULL)
			free(dir_image[no_arr].image);
		    dir_image[no_arr].image = (unsigned char *)debut;
		    dir_desc[no_arr] = dir_desc[no_dep];
		    dir_desc[no_arr].mmin = conv->mina;
		    dir_desc[no_arr].mmax = conv->maxa;
		    dir_desc[no_arr].type = 0;
		    statis (dir_image[no_arr].image, dir_desc[no_arr].type, 
			dir_desc[no_arr].nligne, dir_desc[no_arr].ncolonne,
			&(dir_desc[no_arr].mmin), &(dir_desc[no_arr].mmax), 
			&(dir_desc[no_arr].mu), &(dir_desc[no_arr].ecart));

		}
	    }
	    if (flag_exec == AUTO || flag_exec == PARAM_AUTO) free(conv);
	}
    }
}

/*****************************************************************************/

short *conv_short (no_dep)
    int	no_dep;
{
    short *im, *imsave;
    int taille, j;

    taille = dir_desc[no_dep].ncolonne * dir_desc[no_dep].nligne;
    imsave = im = (short *)malloc (taille * sizeof(*im));
    if (dir_desc[no_dep].type == 0 || dir_desc[no_dep].type == -1 ) {
	/* image de depart en unsigned char */
	unsigned char *b;
	b = (unsigned char *)dir_image[no_dep].image;
	for (j=0; j < taille; j++) {
	    *im = (short)*b;
	    im++;  b++;
	}
    }   
    return (imsave);    
}

/*****************************************************************************/
/*									     */
/* nom      : convert_short						     */
/*									     */
/* fonction : convertit l'image dir_image[no_dep].image en short et la	     */
/*	      stocke dans dir_image[no_arr].image.			     */
/*                                                                           */
/* entrees  : int no_dep	        : no du plan-image de depart         */
/*            int no_arr	        : no du plan-image d'arrivee         */
/*                                                                           */
/* globales : dir_desc							     */
/*	      dir_image							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : statis							     */
/*									     */
/*****************************************************************************/

int convert_short ()

{
    short *im, *debut;
    register int j;
    int taille, no_dep, no_arr;
    register float delta, minim;
    register int minarr;
    struct convert *conv, *copyconv;

    if (flag_bother){
	hproc_conv_short();
	return;
    }
    if (flag_help) hproc_conv_short();
    if (!flag_creer){
	sprintf (buf, mastertabs[27]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	no_dep = index_image[0] = macro_cour->from[0];
	no_arr = index_image[1] = macro_cour->to[0];
    }
    else {
	fromto (FROMTO, DEFAUT);
	
	no_dep = index_image[0];
	no_arr = index_image[1];
    }
    if (flag_break) interruption();
    else{
	if (!flag_creer){
	    sprintf(buf,"%d --> %d ",index_image[0],index_image[1]);
	    write_master (buf);
	}
	if (flag_exec == AUTO || flag_exec == PARAM_AUTO) {
	    conv = (struct convert *)malloc(sizeof(*conv));
	    *conv = *((struct convert *)macro_cour->param);
	}
	else
	    conv = convert_panel (no_dep, 1);
	if (flag_break) interruption();
	else{
	    if (flag_creer){
		struct commande *com;
		com = (struct commande *)new_commande(&macro_cour);
		sprintf (com->nom, "AUXCONSHO");
		com->code = 22;
		com->from[0] = no_dep;
		com->to[0] = no_arr;
		sprintf (buf,"AUXCONSHO FROM %d TO %d WITH",no_dep,no_arr);
		if (conv->flag_mind) strcat (buf, " MIN");
		else strcat (buf,sprintf(rep," %f", conv->mind)); 
		if (conv->flag_maxd) strcat (buf, " MAX");
		else strcat (buf,sprintf(rep," %f", conv->maxd));
		if (conv->flag_mina) strcat (buf, " MIN");
		else strcat (buf,sprintf(rep," %f", conv->mina)); 
		if (conv->flag_maxa) strcat (buf, " MAX\n");
		else strcat (buf,sprintf(rep," %f\n", conv->maxa)); 
		write_macro(buf);
		copyconv = (struct convert *)malloc(sizeof(*copyconv));
		*copyconv = *conv;
		com->param = (char *)copyconv;
	    }
	    else {
		if (dir_image[index_image[0]].image == NULL){
		    write_erreur(1);
		    return;
		}
		taille = dir_desc[no_dep].ncolonne * dir_desc[no_dep].nligne;
		debut = im = (short *) malloc (taille * 2);
							/* 2 bytes par short */
		if (conv->flag_mind) conv->mind = dir_desc[no_dep].mmin;
		if (conv->flag_maxd) conv->maxd = dir_desc[no_dep].mmax;
		if (conv->flag_mina) conv->mina = dir_desc[no_dep].mmin;
		if (conv->flag_maxa) conv->maxa = dir_desc[no_dep].mmax;
		sprintf (buf, "(%.2f,%.2f -> %.2f,%.2f)\n", 
			conv->mind, conv->maxd, conv->mina, conv->maxa);
		write_master (buf);
		if (dir_desc[no_dep].mmin>=MINSHORT &&
		    dir_desc[no_dep].mmax<=MAXSHORT &&
		    dir_desc[no_dep].mmin==conv->mind&&conv->mind==conv->mina&&
		    dir_desc[no_dep].mmax==conv->maxd&&conv->maxd==conv->maxa){
		    /* image depart comprise dans l'intervalle des short    */
		    /* +pas changement dynamique = convertir avec les "cast" */
		    switch (dir_desc[no_dep].type) {
			case -1:
			case 0 : {  /* image de depart de type unsigned char */
			    unsigned char *b;
			    b = (unsigned char *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (short)*b;
				im++;  b++;
			    }
			    break;
			}        
			case 1 : { /* image de depart de type short (recopie)*/
			    short *s;
			    s = (short *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (short)*s;
				im++;  s++;
			    }
			    break; 
			}       
			case 2 : {   /* image de depart de type int */
			    int *i;
			    i = (int *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (short)*i;
				im++;  i++;
			    }
			    break;
			}        
			case 3 : {   /* image de depart de type float */
			    float *f;
			    f = (float *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (short)*f;
				im++;  f++;
			    }
			    break;
			}        
		    }
		    /* les statistiques de l'image d'arrivee sont inchangees */
		    if (dir_image[no_arr].image != NULL) 
			free(dir_image[no_arr].image);
		    dir_image[no_arr].image = (unsigned char *)debut;
		    dir_desc[no_arr] = dir_desc[no_dep];
		    dir_desc[no_arr].type = 1;
		}
		else { 
		    /* on fait une regle de trois en etalant la dynamique de */
		    /* l'intervalle de depart sur la dynamique choisie	*/
		    delta=(conv->maxa - conv->mina)/(conv->maxd - conv->mind);
		    minim = conv->mind;
		    minarr = (int)conv->mina;
		    switch (dir_desc[no_dep].type) {
			case -1:
			case 0 : {   /* l'image de depart est de type byte */
			    unsigned char *b, bb;
			    b = (unsigned char *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*b > conv->maxd) bb = conv->maxd;
				else if (*b < conv->mind) bb = conv->mind;
				else bb = *b;
				*im = (short)
				    (((bb - minim) * delta + minarr) + 0.5);
				im++;  b++;
			    }
			    break;
			}
			case 1 : {   /* l'image de depart est de type short */
			    short *s, ss;
			    s = (short *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*s > conv->maxd) ss = conv->maxd;
				else if (*s < conv->mind) ss = conv->mind;
				else ss = *s;
				*im = (short)
				    (((ss - minim) * delta + minarr) + 0.5);
				im++;  s++;
			    }
			    break;
			}
			case 2 : {   /* l'image de depart est de type int */
			    int *i, ii;
			    i = (int *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*i > conv->maxd) ii = conv->maxd;
				else if (*i < conv->mind) ii = conv->mind;
				else ii = *i;
				*im = (short)
				    (((ii - minim) * delta + minarr) + 0.5);
				im++;  i++;
			    }
			    break;
			}
			case 3 : {   /* l'image de depart est de type float */
			    float *f, ff;
			    f = (float *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*f > conv->maxd) ff = conv->maxd;
				else if (*f < conv->mind) ff = conv->mind;
				else ff = *f;
				*im = (short)
				    (((ff - minim) * delta + minarr) + 0.5);
				im++;  f++;
			    }
			    break;
			}
		    }
		    /* on doit recalculer les statistiques de l'image */
		    if (dir_image[no_arr].image != NULL) 
			free(dir_image[no_arr].image);
		    dir_image[no_arr].image = (unsigned char *)debut;
		    dir_desc[no_arr] = dir_desc[no_dep];
		    dir_desc[no_arr].mmin = conv->mina;
		    dir_desc[no_arr].mmax = conv->maxa;
		    dir_desc[no_arr].type = 1;
		    statis (dir_image[no_arr].image, dir_desc[no_arr].type, 
			dir_desc[no_arr].nligne, dir_desc[no_arr].ncolonne,
			&(dir_desc[no_arr].mmin), &(dir_desc[no_arr].mmax), 
			&(dir_desc[no_arr].mu), &(dir_desc[no_arr].ecart));
		}
	    }
		if (flag_exec == AUTO || flag_exec == PARAM_AUTO) free(conv);
	}
    }
}

/*****************************************************************************/

int *conv_int (no_dep)
    int	no_dep;
{
    int *im, *imsave, taille, j;

    taille = dir_desc[no_dep].ncolonne * dir_desc[no_dep].nligne;
    imsave = im = (int *)malloc (taille * sizeof(*im));
    switch (dir_desc[no_dep].type) {
	case -1:
	case 0 : {   /* image de depart en unsigned char */
		    unsigned char *b;
		    b = (unsigned char *)dir_image[no_dep].image;
		    for (j=0; j < taille; j++) {
			*im = *b;
			im++;  b++;
		    }
		    break;
		}        
	case 1 : {   /* image de depart en short */
                     short *s;
                     s = (short *)dir_image[no_dep].image;
                     for (j=0; j < taille; j++) {
                         *im = (int)*s;
                         im++;  s++;
                     }
                     break; 
                 }
    }   
    return (imsave);    
}

/*****************************************************************************/
/*									     */
/* nom      : convert_integer						     */
/*									     */
/* fonction : convertit l'image dir_image[no_dep].image en entier et la	     */
/*	      stocke dans dir_image[no_arr].image.			     */
/*                                                                           */
/* entrees  : int no_dep	        : no du plan-image de depart         */
/*            int no_arr	        : no du plan-image d'arrivee         */
/*                                                                           */
/* globales : dir_desc							     */
/*	      dir_image							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : statis							     */
/*									     */
/*****************************************************************************/

int convert_integer ()
{
    int *im, *debut;
    register int j;
    int taille, no_dep, no_arr;
    register float delta, minim;
    register int minarr;
    struct convert *conv, *copyconv;


    if (flag_bother){
	hproc_conv_integer();
	return;
    }
    if (flag_help) hproc_conv_integer();
    if (!flag_creer){
	sprintf (buf, mastertabs[28]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	no_dep = index_image[0] = macro_cour->from[0];
	no_arr = index_image[1] = macro_cour->to[0];
    }
    else {
	fromto (FROMTO, DEFAUT);
	
	no_dep = index_image[0];
	no_arr = index_image[1];
    }
    if (flag_break) interruption();
    else{
	if (!flag_creer){
	    sprintf(buf,"%d --> %d ",index_image[0],index_image[1]);
	    write_master (buf);
	}
	if (flag_exec == AUTO || flag_exec == PARAM_AUTO) {
	    conv = (struct convert *)malloc(sizeof(*conv));
	    *conv = *((struct convert *)macro_cour->param);
	}
	else
	    conv = convert_panel (no_dep, 2);
	if (flag_break) interruption();
	else{
	    if (flag_creer){
		struct commande *com;
		com = (struct commande *)new_commande(&macro_cour);
		sprintf (com->nom, "AUXCONINT");
		com->code = 23;
		com->from[0] = no_dep;
		com->to[0] = no_arr;
		sprintf (buf,"AUXCONINT FROM %d TO %d WITH",no_dep,no_arr);
		if (conv->flag_mind) strcat (buf, " MIN");
		else strcat (buf,sprintf(rep," %f", conv->mind)); 
		if (conv->flag_maxd) strcat (buf, " MAX");
		else strcat (buf,sprintf(rep," %f", conv->maxd));
		if (conv->flag_mina) strcat (buf, " MIN");
		else strcat (buf,sprintf(rep," %f", conv->mina)); 
		if (conv->flag_maxa) strcat (buf, " MAX\n");
		else strcat (buf,sprintf(rep," %f\n", conv->maxa)); 
		write_macro(buf);
		copyconv = (struct convert *)malloc(sizeof(*copyconv));
		*copyconv = *conv;
		com->param = (char *)copyconv;
	    }
	    else {
		if (dir_image[index_image[0]].image == NULL){
		    write_erreur(1);
		    return;
		}
		taille = dir_desc[no_dep].ncolonne * dir_desc[no_dep].nligne;
		debut = im = (int *) malloc (taille * 4);
							/* 4 bytes part int */
		if (conv->flag_mind) conv->mind = dir_desc[no_dep].mmin;
		if (conv->flag_maxd) conv->maxd = dir_desc[no_dep].mmax;
		if (conv->flag_mina) conv->mina = dir_desc[no_dep].mmin;
		if (conv->flag_maxa) conv->maxa = dir_desc[no_dep].mmax;
		sprintf (buf, "(%.2f,%.2f -> %.2f,%.2f)\n", 
			conv->mind, conv->maxd, conv->mina, conv->maxa);
		write_master (buf);
		if (dir_desc[no_dep].mmin>=MININT &&
		    dir_desc[no_dep].mmax<=MAXINT &&
		    dir_desc[no_dep].mmin==conv->mind&&conv->mind==conv->mina&&
		    dir_desc[no_dep].mmax==conv->maxd&&conv->maxd==conv->maxa){
		    /* image depart comprise dans l'intervalle des int      */
		    /* +pas changement dynamique = convertir avec les "cast" */
		    switch (dir_desc[no_dep].type) {
			case -1:
			case 0 : {   /* image de depart en unsigned char */
			    unsigned char *b;
			    b = (unsigned char *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (int)*b;
				im++;  b++;
			    }
			    break;
			}        
			case 1 : {   /* image de depart en short */
			    short *s;
			    s = (short *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (int)*s;
				im++;  s++;
			    }
			    break; 
			}       
			case 2 : {   /* image de depart en int (recopie) */
			    int *i;
			    i = (int *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (int)*i;
				im++;  i++;
			    }
			    break;
			}        
			case 3 : {   /* image de depart en float */
			    float *f;
			    f = (float *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (int)*f;
				im++;  f++;
			    }
			    break;
			}        
		    }
		    /* les statistiques de l'image d'arrivee sont inchangees */
		    if (dir_image[no_arr].image != NULL) 
			free(dir_image[no_arr].image);
		    dir_image[no_arr].image = (unsigned char *)debut;
		    dir_desc[no_arr] = dir_desc[no_dep];
		    dir_desc[no_arr].type = 2;    
		}
		else {  
		    /* on fait une regle de trois en etalant la dynamique de */
		    /* l'intervalle de depart sur toute la dynamique des int */
		    delta = (conv->maxa - conv->mina) / 
			    (dir_desc[no_dep].mmax - dir_desc[no_dep].mmin);
		    minim = dir_desc[no_dep].mmin;
		    minarr = (int)conv->mina;
		    dir_desc[no_arr].mmin = conv->mina;
		    dir_desc[no_arr].mmax = conv->maxa;
		    switch (dir_desc[no_dep].type) {
			case -1:
			case 0 : {   /* l'image de depart est de type byte */
			    unsigned char *b, bb;
			    b = (unsigned char *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*b > conv->maxd) bb = conv->maxd;
				else if (*b < conv->mind) bb = conv->mind;
				else bb = *b;
				*im = (int)
				    (((bb - minim) * delta + minarr) + 0.5);
				im++;  b++;
			    }
			    break;
			}
			case 1 : {   /* l'image de depart est de type short */
			    short *s, ss;
			    s = (short *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*s > conv->maxd) ss = conv->maxd;
				else if (*s < conv->mind) ss = conv->mind;
				else ss = *s;
				*im = (int)
				    (((ss - minim) * delta + minarr) + 0.5);
				im++;  s++;
			    }
			    break;
			}
			case 2 : {   /* l'image de depart est de type int */
			    int *i, ii;
			    i = (int *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*i > conv->maxd) ii = conv->maxd;
				else if (*i < conv->mind) ii = conv->mind;
				else ii = *i;
				*im = (int)
				    (((ii - minim) * delta + minarr) + 0.5);
				im++;  i++;
			    }
			    break;
			}
			case 3 : {   /* l'image de depart est de type float */
			    float *f, ff;
			    f = (float *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*f > conv->maxd) ff = conv->maxd;
				else if (*f < conv->mind) ff = conv->mind;
				else ff = *f;
				*im = (int)
				    (((ff - minim) * delta + minarr) + 0.5);
				im++;  f++;
			    }
			break;
			}
		    }
/* ### 18 septembre 1989 */
		    /* on doit recalculer les statistiques de l'image */
		    if (dir_image[no_arr].image != NULL) 
			free(dir_image[no_arr].image);
		    dir_image[no_arr].image = (unsigned char *)debut;
		    dir_desc[no_arr] = dir_desc[no_dep];
		    dir_desc[no_arr].mmin = conv->mina;
		    dir_desc[no_arr].mmax = conv->maxa;
		    dir_desc[no_arr].type = 2;
/* ### */
		    statis (dir_image[no_arr].image, dir_desc[no_arr].type, 
			dir_desc[no_arr].nligne, dir_desc[no_arr].ncolonne,
			&(dir_desc[no_arr].mmin), &(dir_desc[no_arr].mmax), 
			&(dir_desc[no_arr].mu), &(dir_desc[no_arr].ecart));
		}
	    }
	    if (flag_exec == AUTO || flag_exec == PARAM_AUTO) free(conv);
	}
    }
}

/*****************************************************************************/

float *conv_float (no_dep)
    int	no_dep;
{
    float *im, *imsave;
    int taille, j;

    taille = dir_desc[no_dep].ncolonne * dir_desc[no_dep].nligne;
    imsave = im = (float *)malloc (taille * sizeof(*im));
    switch (dir_desc[no_dep].type) {
	case -1:
	case 0 : {   /* image de depart en unsigned char */
		    unsigned char *b;
		    b = (unsigned char *)dir_image[no_dep].image;
		    for (j=0; j < taille; j++) {
			*im = (float)*b;
			im++;  b++;
		    }
		    break;
		}        
	case 1 : {   /* image de depart en short */
                     short *s;
                     s = (short *)dir_image[no_dep].image;
                     for (j=0; j < taille; j++) {
                         *im = (float)*s;
                         im++;  s++;
                     }
                     break; 
                 }
	case 2 : {   /* image de depart en short */
                     int *in;
                     in = (int *)dir_image[no_dep].image;
                     for (j=0; j < taille; j++) {
                         *im = (float)*in;
                         im++;  in++;
                     }
                     break; 
                 }
    }  

    return (imsave);    
}

/*****************************************************************************/
/*									     */
/* nom      : convert_float						     */
/*									     */
/* fonction : convertit l'image dir_image[no_dep].image en float et la	     */
/*	      stocke dans dir_image[no_arr].image.			     */
/*                                                                           */
/* entrees  : int no_dep	        : no du plan-image de depart         */
/*            int no_arr	        : no du plan-image d'arrivee         */
/*                                                                           */
/* globales : dir_desc							     */
/*	      dir_image							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : statis							     */
/*									     */
/*****************************************************************************/

int convert_float ()
{
    float *im, *debut;
    register int j;
    int taille, no_dep, no_arr, no_arr2;
    register float delta, minim;
    register int minarr;
    struct convert *conv, *copyconv;


    if (flag_bother){
	hproc_conv_float();
	return;
    }
    if (flag_help) hproc_conv_float();
    if (!flag_creer){
	if (flag_compl) sprintf (buf,mastertabs[29]);
	else sprintf (buf, mastertabs[30]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	no_dep = index_image[0] = macro_cour->from[0];
	no_arr = index_image[1] = macro_cour->to[0];
	if (flag_compl) no_arr2 = index_image[3] = macro_cour->to[1];
    }
    else {
	if (flag_compl) {
	    fromto (FROMTO, DEFCOMPL1);
	
	    no_arr2 = index_image[3];
	}
	else fromto (FROMTO, DEFAUT);
	
	no_dep = index_image[0];
	no_arr = index_image[1];
    }
    if (flag_break) interruption();
    else{
	if (!flag_creer){
	    if (flag_compl) 
		sprintf (buf,"%d --> (%d,%d)",
			index_image[0], index_image[1], index_image[3]);
	    else
		sprintf (buf, "%d --> %d ",
		     index_image[0], index_image[1]);
	    write_master (buf);
	}
	if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	    conv = (struct convert *)malloc(sizeof(*conv));
	    *conv = *((struct convert *)macro_cour->param);
	}
	else
	    conv = convert_panel (no_dep, 3);
	if (flag_break) interruption();
	else{
	    if (flag_creer){
		struct commande *com;
		com = (struct commande *)new_commande(&macro_cour);
		if (flag_compl){
		    sprintf (com->nom, "AUXCONCOM");
		    com->code = 25;
		    com->from[0] = no_dep;
		    com->to[0] = no_arr;
		    com->to[1] = no_arr2;
		    sprintf(buf,"AUXCONCOM FROM %d TO %d %d WITH",
			no_dep,no_arr,no_arr2);
		    if (conv->flag_mind) strcat (buf, " MIN");
		    else strcat (buf,sprintf(rep," %f", conv->mind)); 
		    if (conv->flag_maxd) strcat (buf, " MAX");
		    else strcat (buf,sprintf(rep," %f", conv->maxd));
		    if (conv->flag_mina) strcat (buf, " MIN");
		    else strcat (buf,sprintf(rep," %f", conv->mina)); 
		    if (conv->flag_maxa) strcat (buf, " MAX\n");
		    else strcat (buf,sprintf(rep," %f\n", conv->maxa)); 
		}
		else{
		    if (dir_image[index_image[0]].image == NULL){
			write_erreur(1);
			return;
		    }
		    else if (dir_image[index_image[0]].image == NULL){
			write_erreur(9);
			return;
		    }
		    else if (dir_image[index_image[2]].image == NULL){
			write_erreur(10);
			return;
		    }
		    sprintf (com->nom, "AUXCONFLO");
		    com->code = 24;
		    com->from[0] = no_dep;
		    com->to[0] = no_arr;
		    sprintf(buf,"AUXCONFLO FROM %d TO %d WITH",no_dep,no_arr);
		    if (conv->flag_mind) strcat (buf, " MIN");
		    else strcat (buf,sprintf(rep," %f", conv->mind)); 
		    if (conv->flag_maxd) strcat (buf, " MAX");
		    else strcat (buf,sprintf(rep," %f", conv->maxd));
		    if (conv->flag_mina) strcat (buf, " MIN");
		    else strcat (buf,sprintf(rep," %f", conv->mina)); 
		    if (conv->flag_maxa) strcat (buf, " MAX\n");
		    else strcat (buf,sprintf(rep," %f\n", conv->maxa)); 
		}
		write_macro(buf);
		copyconv = (struct convert *)malloc(sizeof(*copyconv));
		*copyconv = *conv;
		com->param = (char *)copyconv;
	    }
	    else {
		taille = dir_desc[no_dep].ncolonne * dir_desc[no_dep].nligne;
		debut = im = (float *) malloc (taille * 4);  
							/* 4 bytes par float */
		if (conv->flag_mind) conv->mind = dir_desc[no_dep].mmin;
		if (conv->flag_maxd) conv->maxd = dir_desc[no_dep].mmax;
		if (conv->flag_mina) conv->mina = dir_desc[no_dep].mmin;
		if (conv->flag_maxa) conv->maxa = dir_desc[no_dep].mmax;
		sprintf (buf, "(%.2f,%.2f -> %.2f,%.2f)\n", 
			conv->mind, conv->maxd, conv->mina, conv->maxa);
		write_master (buf);
		if (dir_desc[no_dep].mmin>=MINFLOAT &&
		    dir_desc[no_dep].mmax<=MAXFLOAT &&
		    dir_desc[no_dep].mmin==conv->mind&&conv->mind==conv->mina&&
		    dir_desc[no_dep].mmax==conv->maxd&&conv->maxd==conv->maxa){
		    /* image depart comprise dans l'intervalle des float    */
		    /* +changement dynamique = convertir avec les "cast" */
		    switch (dir_desc[no_dep].type) {
			case -1:
			case 0 : {  /* image de depart de type unsigned char */
			    unsigned char *b;
			    b = (unsigned char *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (float)*b;
				im++;  b++;
			    }
			    break;
			 }        
			case 1 : {   /* image de depart de type short */
			    short *s;
			    s = (short *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (float)*s;
				im++;  s++;
			    }
			    break; 
			}       
			case 2 : {   /* image de depart de type int */
			    int *i;
			    i = (int *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (float)*i;
				im++;  i++;
			    }
			    break;
			}        
			case 3 : {   /* image de depart de type float */
			    float *f;
			    f = (float *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (float)*f;
				im++;  f++;
			    }
			    break;
			} 
		    }       
		    /* les statistiques de l'image d'arrivee sont inchangees */
		    if (dir_image[no_arr].image != NULL) 
			free(dir_image[no_arr].image);
		    dir_image[no_arr].image = (unsigned char *)debut;
		    dir_desc[no_arr] = dir_desc[no_dep];
		    dir_desc[no_arr].type = 3;
		}
		else {
		    /* on fait une regle de trois en etalant la dynamique de */
		    /* l'intervalle de depart sur toute la dynamique des int */
		    delta = (conv->maxa - conv->mina) / 
			    (dir_desc[no_dep].mmax - dir_desc[no_dep].mmin);
		    minim = dir_desc[no_dep].mmin;
		    minarr = (int)conv->mina;
		    switch (dir_desc[no_dep].type) {
			case -1:
			case 0 : {   /* l'image de depart est de type byte */
			    unsigned char *b, bb;
			    b = (unsigned char *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*b > conv->maxd) bb = conv->maxd;
				else if (*b < conv->mind) bb = conv->mind;
				else bb = *b;
				*im = (float)
				    (((bb - minim) * delta + minarr) + 0.5);
				im++;  b++;
			    }
			    break;
			}
			case 1 : {   /* l'image de depart est de type short */
			    short *s, ss;
			    s = (short *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*s > conv->maxd) ss = conv->maxd;
				else if (*s < conv->mind) ss = conv->mind;
				else ss = *s;
				*im = (float)
				    (((ss - minim) * delta + minarr) + 0.5);
				im++;  s++;
			    }
			    break;
			}
			case 2 : {   /* l'image de depart est de type int */
			    int *i, ii;
			    i = (int *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*i > conv->maxd) ii = conv->maxd;
				else if (*i < conv->mind) ii = conv->mind;
				else ii = *i;
				*im = (float)
				    (((ii - minim) * delta + minarr) + 0.5);
				im++;  i++;
			    }
			    break;
			}
			case 3 : {   /* l'image de depart est de type float */
			    float *f, ff;
			    f = (float *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*f > conv->maxd) ff = conv->maxd;
				else if (*f < conv->mind) ff = conv->mind;
				else ff = *f;
				*im = (float) ((ff - minim) * delta + minarr);
				im++;  f++;
			    }
			break;
			}
		    }
		    if (dir_image[no_arr].image != NULL) 
			free(dir_image[no_arr].image);
/* 18 septembre 1989 */
/* im --> debut	     */
		    dir_image[no_arr].image = (unsigned char *)debut;
/* */
		    dir_desc[no_arr] = dir_desc[no_dep];
		    dir_desc[no_arr].type = 3;
		    dir_desc[no_arr].mmin = conv->mina;
		    dir_desc[no_arr].mmax = conv->maxa;
		    statis (dir_image[no_arr].image, dir_desc[no_arr].type, 
			dir_desc[no_arr].nligne, dir_desc[no_arr].ncolonne,
			&(dir_desc[no_arr].mmin), &(dir_desc[no_arr].mmax), 
			&(dir_desc[no_arr].mu), &(dir_desc[no_arr].ecart));
		}
	    }
	    if (flag_exec == AUTO || flag_exec == PARAM_AUTO) free(conv);
	    if (flag_compl){
		taille = dir_desc[no_dep].ncolonne * dir_desc[no_dep].nligne;
		im = (float *) malloc (taille * 4);
		if (dir_image[no_arr2].image != NULL)
		    free (dir_image[no_arr2].image);
		dir_image[no_arr2].image = (unsigned char *) im;
		/* mise a 0 du plan imaginaire (ou argument) */
		for (j = 0; j < taille; j++){
		    *im = 0.0;
		    im++;	
		}
		/* mise a jour des statistiques du plan imaginaire */
		dir_desc[no_arr2] = dir_desc[no_dep];
		dir_desc[no_arr2].type = 3;
		dir_desc[no_arr2].mmin = 0;
		dir_desc[no_arr2].mmax = 0;
		dir_desc[no_arr2].mu = 0;
		dir_desc[no_arr2].ecart = 0;
	    }
	}
    }
}

/*****************************************************************************/
/*									     */
/* nom      : convert_complex						     */
/*									     */
/* fonction : convertit l'image dir_image[no_dep].image en complexes et la   */
/*	      stocke dans dir_image[no_arr].image.			     */
/*                                                                           */
/* entrees  : int no_dep	        : no du plan-image de depart         */
/*            int no_arr	        : no du plan-image d'arrivee         */
/*                                                                           */
/* globales : dir_desc							     */
/*	      dir_image							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : statis							     */
/*									     */
/*****************************************************************************/

int convert_complex ()

{
    float *im;
    int taille, j;

    flag_compl = TRUE;
    convert_float ();
    flag_compl = FALSE;
}

/*****************************************************************************/
/*									     */
/* nom      : plans_complexes						     */
/*									     */
/* fonction : verifie si les deux plans-images forment une image complexe    */
/*            (si les 2 plans existent et ont la meme taille)                */
/*                                                                           */
/* entrees  : int n1		        : no du 1er plan	             */
/*            int n2			: no du 2eme plan		     */
/*                                                                           */
/* globales : dir_desc							     */
/*									     */
/* return   : TRUE			: les 2 plans forment une im. compl. */
/*            FALSE			: sinon				     */
/*									     */
/* routines : write_erreur						     */
/*									     */
/*****************************************************************************/

int plans_complexes (n1, n2)

    int n1, n2;

{
    if (dir_desc[n1].nligne != dir_desc[n2].nligne ||
        dir_desc[n1].ncolonne!=dir_desc[n2].ncolonne) {
            /* taille differente */
	    write_erreur(2);
            return(FALSE);
    }
    if (dir_image[n1].image == NULL) {
        /* plan reel (ou norme) vide */
	write_erreur(9);
        return(FALSE);
    }
    if (dir_image[n2].image == NULL) {
        /* plan imaginaire (ou argument) vide */
	write_erreur
(10);
        return(FALSE);
    }
    return (TRUE);
}

/*****************************************************************************/
/*									     */
/* nom      : convert_cart_en_pol					     */
/*									     */
/* fonction : convertit l'image complexe cartesienne			     */
/*	      dir_image[no_dep1 et no_dep2].image en une image complexe	     */
/*	      polaire dir_image[no_arr1 et no_arr2].image		     */
/*                                                                           */
/* entrees  : int no_dep1	        : no du plan de depart reel          */
/*            int no_dep2		: no du plan de depart imaginaire    */
/*            int no_arr1	        : no du plan d'arrivee norme         */
/*            int no_arr2		: no du plan d'arrivee argument	     */
/*                                                                           */
/* globales : dir_desc							     */
/*	      dir_image							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : statis							     */
/*									     */
/*****************************************************************************/
 
int convert_cart_en_pol ()
{
    float *x, *y, *module, *arg, *deb_m, *deb_a;
    register int taille, n;
    int no_dep1, no_dep2, no_arr1, no_arr2;


    if (flag_bother){
	hproc_conv_cartpol();
	return;
    }
    if (flag_help) hproc_conv_cartpol();
    if (!flag_creer){
	sprintf (buf, mastertabs[31]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	no_dep1 = index_image[0] = macro_cour->from[0];
	no_dep2 = index_image[2] = macro_cour->from[1];
	no_arr1 = index_image[1] = macro_cour->to[0];
	no_arr2 = index_image[3] = macro_cour->to[1];
    }
    else{
	fromto (FROMTO, COMPL12);
	
	no_dep1 = index_image[0];  no_dep2 = index_image[2];
	no_arr1 = index_image[1];  no_arr2 = index_image[3];
    }
    if (flag_break) interruption();
    else{
	if (flag_creer){
	    struct commande *com;
	    com = (struct commande *)new_commande(&macro_cour);
	    sprintf (com->nom, "AUXCONCPO");
	    com->code = 26;
	    com->from[0] = no_dep1;  com->from[1] = no_dep2;
	    com->to[0] = no_arr1;  com->to[1] = no_arr2;
	    com->param = NULL;
	    sprintf (buf, "AUXCONCPO FROM %d %d TO %d %d\n", 
		    no_dep1, no_dep2, no_arr1, no_arr2);
	    write_macro (buf);
	}
	else {
	    sprintf(buf,"(%d,%d)--> (%d,%d)\n",
		  index_image[0],index_image[2],index_image[1],index_image[3]);
	    write_master (buf);
	    if (dir_image[index_image[0]].image == NULL){
		    write_erreur(9);
		    return;
	    }
	    else if (dir_image[index_image[2]].image == NULL){
		write_erreur(10);
		return;
	    }
	    if (plans_complexes(index_image[0],index_image[2])==TRUE){
		taille = dir_desc[no_dep1].nligne * dir_desc[no_dep1].ncolonne;
		x = (float *) dir_image[no_dep1].image;
		y = (float *) dir_image[no_dep2].image;
		deb_m = module = (float *)malloc(taille*4);
		deb_a = arg = (float *)malloc(taille*4);

		for ( n = 0 ; n < taille ; n++){
		    *module = (float) hypot((double) *x , (double) *y);
		    if (*x==0)
			if (*y>0) *arg = M_PI_2;
			else if (*y<0) *arg = - M_PI_2;
			else *arg = 0;
		    else
			*arg = (float) atan ( (double) *y / (double) *x);
		    module++;  arg++;
		    x++;  y++;
		}

		if (dir_image[no_arr1].image != NULL)
		    free (dir_image[no_arr1].image);
		if (dir_image[no_arr2].image != NULL)
		    free (dir_image[no_arr2].image);
		dir_image[no_arr1].image = (unsigned char *)deb_m;
		dir_image[no_arr2].image = (unsigned char *)deb_a;

		/* recopie globale des descripteurs */
		dir_desc[no_arr1] = dir_desc[no_dep1];
		dir_desc[no_arr2] = dir_desc[no_dep2];

		/* calcul des statistiques pour le plan-norme */
		statis (dir_image[no_arr1].image, dir_desc[no_arr1].type,
			dir_desc[no_arr1].nligne, dir_desc[no_arr1].ncolonne,
			&(dir_desc[no_arr1].mmin),&(dir_desc[no_arr1].mmax), 
			&(dir_desc[no_arr1].mu), &(dir_desc[no_arr1].ecart)); 
		/* calcul des statistiques pour le plan-argument */
		statis (dir_image[no_arr2].image, dir_desc[no_arr2].type, 
			dir_desc[no_arr2].nligne, dir_desc[no_arr2].ncolonne,
			&(dir_desc[no_arr2].mmin),&(dir_desc[no_arr2].mmax), 
			&(dir_desc[no_arr2].mu), &(dir_desc[no_arr2].ecart)); 
	    }
	}
    }
}

/*****************************************************************************/
/*									     */
/* nom      : convert_pol_en_cart					     */
/*									     */
/* fonction : convertit l'image complexe polaire			     */
/*	      dir_image[no_dep1 et no_dep2].image en une image complexe	     */
/*	      cartesienne dir_image[no_arr1 et no_arr2].image		     */
/*                                                                           */
/* entrees  : int no_dep1	        : no du plan de depart norme         */
/*            int no_dep2		: no du plan de depart argument      */
/*            int no_arr1	        : no du plan d'arrivee reel          */
/*            int no_arr2		: no du plan d'arrivee imaginaire    */
/*                                                                           */
/* globales : dir_desc							     */
/*	      dir_image							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : statis							     */
/*									     */
/*****************************************************************************/
 
int convert_pol_en_cart ()
{
    float *x, *y, *module, *arg, *deb_x, *deb_y;
    register int taille, n;
    int no_dep1, no_dep2, no_arr1, no_arr2;


    if (flag_bother){
	hproc_conv_polcart();
	return;
    }
    if (flag_help) hproc_conv_polcart();
    if (!flag_creer){
	sprintf (buf, mastertabs[32]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	no_dep1 = index_image[0] = macro_cour->from[0];
	no_dep2 = index_image[2] = macro_cour->from[1];
	no_arr1 = index_image[1] = macro_cour->to[0];
	no_arr2 = index_image[3] = macro_cour->to[1];
    }
    else{
	fromto (FROMTO, COMPL12);
	
	no_dep1 = index_image[0];  no_dep2 = index_image[2];
	no_arr1 = index_image[1];  no_arr2 = index_image[3];
    }
    if (flag_break) interruption();
    else{
	if (flag_creer){
	    struct commande *com;
	    com = (struct commande *)new_commande(&macro_cour);
	    sprintf (com->nom, "AUXCONPCA");
	    com->code = 27;
	    com->from[0] = no_dep1;  com->from[1] = no_dep2;
	    com->to[0] = no_arr1;  com->to[1] = no_arr2;
	    com->param = NULL;
	    sprintf (buf, "AUXCONPCA FROM %d %d TO %d %d\n", 
		    no_dep1, no_dep2, no_arr1, no_arr2);
	    write_macro (buf);
	}
	else {
	    sprintf(buf, "(%d,%d)--> (%d,%d)\n",
		  index_image[0],index_image[2],index_image[1],index_image[3]);
	    write_master (buf);
	    if (dir_image[index_image[0]].image == NULL){
		write_erreur(9);
		return;
	    }
	    else if (dir_image[index_image[2]].image == NULL){
		write_erreur(10);
		return;
	    }

	    if (plans_complexes(index_image[0],index_image[2])==TRUE){
		taille = dir_desc[no_dep1].nligne * dir_desc[no_dep1].ncolonne;
		module = (float *) dir_image[no_dep1].image;
		arg = (float *) dir_image[no_dep2].image;
		deb_x = x = (float *)malloc(taille*4);
		deb_y = y = (float *)malloc(taille*4);

		for ( n = 0 ; n < taille ; n++){
		    *x = *module * cos (*arg);
		    *y = *module * sin (*arg);
		    x++;  y++;
		    module++;  arg++;
		}

		if (dir_image[no_arr1].image != NULL)
		    free (dir_image[no_arr1].image);
		if (dir_image[no_arr2].image != NULL)
		    free (dir_image[no_arr2].image);
		dir_image[no_arr1].image = (unsigned char *)deb_x;
		dir_image[no_arr2].image = (unsigned char *)deb_y;

		/* recopie globale des descripteurs */
		dir_desc[no_arr1] = dir_desc[no_dep1];
		dir_desc[no_arr2] = dir_desc[no_dep2];

		/* calcul des statistiques pour le plan-reel */
		statis (dir_image[no_arr1].image, dir_desc[no_arr1].type, 
			dir_desc[no_arr1].nligne, dir_desc[no_arr1].ncolonne,
			&(dir_desc[no_arr1].mmin),&(dir_desc[no_arr1].mmax), 
			&(dir_desc[no_arr1].mu), &(dir_desc[no_arr1].ecart)); 
		/*calcul des statistiques pour le plan-imaginaire */
		statis (dir_image[no_arr2].image, dir_desc[no_arr2].type, 
			dir_desc[no_arr2].nligne, dir_desc[no_arr2].ncolonne,
			&(dir_desc[no_arr2].mmin),&(dir_desc[no_arr2].mmax), 
			&(dir_desc[no_arr2].mu), &(dir_desc[no_arr2].ecart));
	    }
	}
    }
}
    
/*****************************************************************************/
/*									     */
/* nom      : proc_convert						     */
/*									     */
/* fonction : appelle la conversion desiree pour une image de depart	     */
/*	      a un seul plan-image.					     */
/*                                                                           */
/* entrees  : Menu m		        : menu courant		             */
/*            Menu_item		        : item dans le menu	             */
/*                                                                           */
/* globales : index_image		: no des plans-image selectionnes    */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : fromto							     */
/*									     */
/*****************************************************************************/

caddr_t  proc_convert (m, mi)
    Menu m;
    Menu_item mi;

{
    switch ((int) menu_get (mi, MENU_VALUE)) {
        case -1:
	case 0 : convert_byte (); break;
	case 1 : convert_short (); break;
	case 2 : convert_integer (); break;
	case 3 : convert_float (); break;
	case 4 : convert_complex (); break;
        case 5 : convert_cart_en_pol(); break;
        case 6 : convert_pol_en_cart (); break;
    }
}


/*****************************************************************************/

int valide_convert (ff)

    float ff[4];

{
    if (ff[0]>ff[1]) {
    }
    if (ff[2]>ff[3]) {
    }
    else {
	    /* controle des types */
    }   
}

/*****************************************************************************/
/*                							     */
/* nom      : creer_image_bin 						     */
/*									     */
/* fonction : rend "binaire" (0 et 255) l'image pointee par                  */
/*	      dir_image[index_image[0]].image en appliquant un seuil	     */
/*									     */
/* entrees  : int valeur                : valeur du seuil                    */
/*									     */
/* globales : dir_image					                     */
/*            dir_desc                                                       */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : statis							     */
/*								             */
/*****************************************************************************/

creer_image_bin (valeur)

int valeur;
  
{
    int taille;
    unsigned char *image, *debut;
    register unsigned char *b;
    register short *s;
    register int *i, x, y;
    register float *f; 

    taille = dir_desc[index_image[0]].nligne * 
             dir_desc[index_image[0]].ncolonne; 
    debut = image = (unsigned char *)malloc (taille);    
    switch (dir_desc[index_image[0]].type) {
        case -1:
	case 0: b = (unsigned char *) dir_image[index_image[0]].image; break;
        case 1: s = (short *) dir_image[index_image[0]].image; break;
        case 2: i = (int *) dir_image[index_image[0]].image; break;
        case 3: f = (float *) dir_image[index_image[0]].image; break;
    }
    switch (dir_desc[index_image[0]].type) {
	case -1:
	case 0:
	    for ( y = 0 ; y < dir_desc[index_image[0]].nligne ; y++) 
		for ( x = 0 ; x < dir_desc[index_image[0]].ncolonne; x++) {
	            if ( *b > valeur ) *image = 255;
		    else *image = 0;
		    b++;
	            image++;
		}
	    break;
	case 1:
	    for ( y = 0 ; y < dir_desc[index_image[0]].nligne ; y++) 
		for ( x = 0 ; x < dir_desc[index_image[0]].ncolonne; x++) {
	            if ( *s > valeur ) *image = 255;
		    else *image = 0;
		    s++;
	            image++;
		}
	    break;
	case 2:
	    for ( y = 0 ; y < dir_desc[index_image[0]].nligne ; y++) 
		for ( x = 0 ; x < dir_desc[index_image[0]].ncolonne; x++) {
	            if ( *i > valeur ) *image = 255;
		    else *image = 0;
		    i++;
	            image++;
		}
	    break;
	case 3:
	    for ( y = 0 ; y < dir_desc[index_image[0]].nligne ; y++) 
		for ( x = 0 ; x < dir_desc[index_image[0]].ncolonne; x++) {
	            if ( *f > valeur ) *image = 255;
		    else *image = 0;
		    f++;
	            image++;
		}
	    break;
    }
    if (dir_image[index_image[1]].image != NULL)
        free(dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = debut;
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].type = -1;
    statis (dir_image[index_image[1]].image, dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne, dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin), &(dir_desc[index_image[1]].mmax),
	    &(dir_desc[index_image[1]].mu), &(dir_desc[index_image[1]].ecart));
}

/*****************************************************************************/
/*									     */
/* nom      : lire_seuil						     */
/*									     */
/* fonction : declanche la creation d'une image "binaire" avec un seuil	     */
/*	      contenu dans value.				             */
/*                                                                           */
/* entrees  : panel_item item		: item d'interaction	             */
/*            Evant event	        : evenements		             */
/*                                                                           */
/* globales : Frame frameseuil		: frame du slider		     */
/*	      Textsw  master		: fenetre de commandes		     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : creer_image_bin						     */
/*									     */
/*****************************************************************************/

static Panel_setting lire_seuil (item, value, event)
    Panel_item item;
    int value;
    Event *event;

{
    val_seuil = value;
}

/*****************************************************************************/

static Panel_setting lire_bouton (item, event)
    Panel_item	item;
    Event	*event;
{
    window_return ();
    window_destroy (frame_seuil);
    if (item == bouton_ok){
	if (flag_creer){
	    int *val;
	    struct commande *com;
	    com = (struct commande *)new_commande(&macro_cour);
	    sprintf (com->nom, "AUXCONBIN");
	    com->code = 20;
	    com->from[0] = index_image[0];
	    com->to[0] = index_image[1];
	    sprintf (buf,"AUXCONBIN FROM %d TO %d WITH %d\n",
		    index_image[0], index_image[1], val_seuil);
	    write_macro(buf);
	    val = (int *)malloc(sizeof(*val));
	    *val = val_seuil;
	    com->param = (char *)val;
	}
	else{
	    sprintf (buf, mastertabs[33], val_seuil);
	    write_master (buf);
	    creer_image_bin (val_seuil);
	}
    }
    else interruption();
}

/*****************************************************************************/
/*                							     */
/* nom      : init_slider_seuil						     */
/*									     */
/* fonction : initialisation d'un panneau contenant un "slider" pour         */
/*	      l'operation de seuillage.					     */
/*									     */
/* entrees  : int vmin			: valeur minimum du slider           */
/*	      int vmax                  : valeur maximum du slider	     */
/*	      int vmoy			: valeur initiale du slider          */
/*									     */
/* globales : neant						             */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : neant							     */
/*								             */
/*****************************************************************************/

int init_slider_seuil ()
{
    float vmin, vmax, vmoy;
    
    if (flag_creer){
	vmin = -1;
	vmax = 255;
	vmoy = -1;
    }
    else {
	vmin = dir_desc[index_image[0]].mmin;
	vmax = dir_desc[index_image[0]].mmax;
	vmoy = dir_desc[index_image[0]].mu;
    }
    val_seuil = vmoy;
    frame_seuil = window_create(frame, FRAME, WIN_X, 500, WIN_Y, 500,
		       FRAME_NO_CONFIRM, TRUE, 0);
    panel_seuil = window_create(frame_seuil, PANEL,
		       PANEL_ACCEPT_KEYSTROKE, TRUE,
                       PANEL_LABEL_BOLD, TRUE, 0);
    barre_seuil = panel_create_item (panel_seuil, PANEL_SLIDER,
                       PANEL_LABEL_STRING, paneltabs[27],
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_MIN_VALUE, (unsigned int)rint(vmin),
		       PANEL_MAX_VALUE, (unsigned int)rint(vmax),
		       PANEL_VALUE, (unsigned int)rint(vmoy),
                       PANEL_SLIDER_WIDTH, 300,
                       PANEL_NOTIFY_PROC, lire_seuil,
                       0);
    bouton_ok = panel_create_item (panel_seuil, PANEL_BUTTON,
	    PANEL_NOTIFY_PROC, lire_bouton,
	    PANEL_LABEL_IMAGE, panel_button_image (panel_seuil, "OK",7,0),
	    PANEL_ITEM_X, 125, PANEL_ITEM_Y, 30,
	    0);
    bouton_cancel = panel_create_item (panel_seuil, PANEL_BUTTON,
	    PANEL_NOTIFY_PROC, lire_bouton,
	    PANEL_LABEL_IMAGE, panel_button_image (panel_seuil, "Cancel",7,0),
	    PANEL_ITEM_X, 225, PANEL_ITEM_Y, 30,
	    0);
    window_fit (bouton_ok);
    window_fit (bouton_cancel);
    window_fit (panel_seuil);
    window_fit (frame_seuil);
    window_set (frame_seuil, WIN_MOUSE_XY,
       (int)window_get (frame_seuil, WIN_X, 0) + 10,
       (int)window_get (frame_seuil, WIN_Y, 0) + 10,
       0);
    window_loop (frame_seuil);
}

/*****************************************************************************/
/*									     */
/* nom      : proc_seuillage						     */
/*									     */
/* fonction : initialise le panel-slider pour le seuillage.		     */
/*                                                                           */
/* entrees  : Menu   m		        : menu courant                       */
/*            Menu_item mi	        : item dans le menu                  */
/*                                                                           */
/* globales : Frame frame_seuil						     */
/*	      Panel panel_seuil						     */
/*	      description_memoire dir_desc				     */
/*	      int index_image[6]					     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/*	      init_slider_seuil						     */
/*	      fromto							     */
/*									     */
/*****************************************************************************/

caddr_t proc_seuillage (m, mi)
    Menu m;
    Menu_item mi;
{
    int val;

    if (flag_bother){
	hproc_conv_bin();
	return;
    }
    if (flag_help) hproc_conv_bin();
    if (!flag_creer){
	sprintf (buf, mastertabs[34]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else fromto (FROMTO, DEFAUT);
    
    if (flag_break) interruption();
    else{
	if (!flag_creer){
	    sprintf (buf,"%d --> %d \n",
		     index_image[0],index_image[1]);
	    write_master (buf);
	}
	if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	    val = *((int *)macro_cour->param);
	    if (val == -1) val = dir_desc[index_image[0]].mu;
	    sprintf (buf, "(seuil=%d)\n", val);
	    write_master (buf);
	    creer_image_bin (val);
	}
	else{
	    if (dir_image[index_image[0]].image == NULL){
		write_erreur(1);
		return;
	    }
	    init_slider_seuil ();
	}
	    
    }
}
