/*****************************************************************************/
/* module transform.c							     */
/*									     */
/* Author: Alain Jacot-Descombes					     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1989							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <math.h>

#include "define.h"
#include "structure.h"
#include "global.h"

#define PI  3.14159265358979323846
#define PI2 6.28318530717958647692


extern void  hproc_trans_Four_direct();
extern void  hproc_trans_Four_inverse();
extern void  hproc_trans_Four_opt_direct();
extern void  hproc_trans_Four_opt_inverse();

int	four_2d();	/*tranformation fourier puissance de 2*/

/* extern  har2_();	*SPIDER*	transformation haar puissance de 2*/
/* extern  hari2_();	*SPIDER*	inverse de har2*/

int image_real;

/*****************************************************************************/

caddr_t proc_fourier (m, mi)

    Menu m;
    Menu_item mi;

{
    float *imager, *imagef, *imaresr, *imaresi;
    int ligne, colonne, somme, inv, jerr, *lbr, flag_conv, invC, invP;
    int nline, ncols;

    inv = ((int)menu_get(mi, MENU_VALUE)); 
    if (inv > 2) image_real = TRUE;
    else image_real = FALSE;
    if (flag_bother){
	switch (inv) {
	    case -2: hproc_trans_Four_opt_inverse();
		     return;
	    case -1: hproc_trans_Four_inverse(); 
		     return;
	    case 10:
	    case 1 : hproc_trans_Four_direct(); 
		     return;
	    case 20:
	    case 2 : hproc_trans_Four_opt_direct(); 
		     return;
	}
    }	
    if (!flag_creer){
	sprintf (buf, "Fourier "); 
	switch (inv) {
	    case -2: if (flag_help) hproc_trans_Four_opt_inverse();
		     strcat (buf, mastertabs[281]); 
		     break;
	    case -1: if (flag_help) hproc_trans_Four_inverse(); 
		     strcat (buf, "inverse"); 
		     break;
	    case 10:
	    case 1 : if (flag_help) hproc_trans_Four_direct(); 
		     break;
	    case 20:
	    case 2 : if (flag_help) hproc_trans_Four_opt_direct(); 
		     strcat (buf, mastertabs[282]);
		     break;
	}
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
	index_image[3] = macro_cour->to[1];
	if (!image_real){
	    index_image[2] = macro_cour->from[1];
	}
    }
    else{
	 if (!image_real) fromto (FROMTO, COMPL1);
	 else fromto(FROMTO, DEFCOMPL1);
    }
    if (flag_break) {
	interruption();
	return;
    }
    if (!flag_creer){
	if (!image_real)
		sprintf (buf, "(%d,%d)-->(%d,%d)\n",
			    index_image[0],index_image[2],
			    index_image[1],index_image[3]);
	else sprintf (buf, " %d-->(%d,%d)\n",index_image[0], 
			    index_image[1], index_image[3]);
	write_master (buf);
    }
    if (flag_creer){
	struct commande *com;
	com = (struct commande *)new_commande (&macro_cour);
	com->from[0] = index_image[0];
	com->to[0] = index_image[1];
	com->to[1] = index_image[3];	    
	if (!image_real){
	    com->from[1] = index_image[2];
	}
	switch (inv){
	    case 1 :
		sprintf (com->nom, "PROTRAF2D");
		com->code = 50;
		break;
	    case -1:
		sprintf (com->nom, "PROTRAIF2");
		com->code = 51;
		break;
	    case 2 :
		sprintf (com->nom, "PROTRAOF2");
		com->code = 52;
		break;
	    case -2:
		sprintf (com->nom, "PROTRAOIF");
		com->code = 53;
		break;
	    case 10:
		sprintf (com->nom, "PROTRARF2");
		com->code = 54;
		break;
	    case 20:
		sprintf (com->nom, "PROTRAROF");
		com->code = 55;
		break;

	}

	if (image_real) sprintf (buf, "%s FROM %d TO %d %d\n",com->nom, 
			index_image[0],index_image[1], index_image[3]);
	else sprintf (buf, "%s FROM %d %d TO %d %d\n",com->nom, 
			index_image[0],index_image[2],
			index_image[1],index_image[3]);
	write_macro (buf);	
    }
    else { /* !flag_creer */
	if (inv == 10) inv = 1;
	else if (inv == 20) inv = 2;
	if ((!image_real) && (   dir_desc[index_image[0]].nligne != 
				 dir_desc[index_image[2]].nligne
			  || dir_desc[index_image[0]].ncolonne != 
				dir_desc[index_image[2]].ncolonne))
	    write_erreur(2);
	if (power_2(dir_desc[index_image[0]].nligne) == FALSE 
	 || power_2(dir_desc[index_image[0]].ncolonne) == FALSE)
	    write_erreur(15);
	else { /* tout est bon */
	     switch (dir_desc[index_image[0]].type ){
		case 6:
	    	case -1:
		case 0:
		case 1:
		case 2:flag_conv = TRUE;
		       imager = (float *)conv_float(index_image[0]);
		       break;
		case 3:
		case 4:
		case 5:flag_conv = FALSE;
		       imager = (float *)dir_image[index_image[0]].image;
		       break;
	     }
	    if (image_real){
		ligne = (int)dir_desc[index_image[0]].nligne;
		colonne = (int)dir_desc[index_image[0]].ncolonne;
		imagef = (float *) calloc(ligne * colonne,sizeof(float));
	    }
	    else 
		switch (dir_desc[index_image[2]].type ){
		case 6:
		case -1:
		case 0:
		case 1:
		case 2: flag_conv = TRUE;
			imagef=(float *)conv_float(index_image[2]);
		        break;
		case 3:
		case 4:
		case 5:	flag_conv = FALSE;
			imagef=(float *)dir_image[index_image[2]].image;
		        break;
	    }
	    dir_desc[index_image[1]] = dir_desc[index_image[0]];
	    dir_desc[index_image[1]].type = 3;
	    dir_desc[index_image[3]] = dir_desc[index_image[2]];
	    dir_desc[index_image[3]].type = 3;
	    ligne = (int)dir_desc[index_image[1]].nligne;
	    colonne = (int)dir_desc[index_image[1]].ncolonne;
	    four_2d(imager, imagef, &imaresr, &imaresi ,colonne,ligne,inv);
	    if (dir_image[index_image[1]].image != NULL)
		free (dir_image[index_image[1]].image);
	    dir_image[index_image[1]].image = (unsigned char *)imaresr;            
	    if (dir_image[index_image[3]].image != NULL)
		free (dir_image[index_image[3]].image); 
	    dir_image[index_image[3]].image = (unsigned char *)imaresi;
	    if (flag_conv == TRUE) {
		free (imager);
		if (!image_real) free (imagef);
		flag_conv = FALSE;
	    }
        statis (dir_image[index_image[1]].image,
		dir_desc[index_image[1]].type, 
	        dir_desc[index_image[1]].nligne,
	        dir_desc[index_image[1]].ncolonne,
		&(dir_desc[index_image[1]].mmin),
		&(dir_desc[index_image[1]].mmax), 
	        &(dir_desc[index_image[1]].mu),
		&(dir_desc[index_image[1]].ecart));
        statis (dir_image[index_image[3]].image,
		dir_desc[index_image[3]].type, 
	        dir_desc[index_image[3]].nligne,
	        dir_desc[index_image[3]].ncolonne,
		&(dir_desc[index_image[3]].mmin),
		&(dir_desc[index_image[3]].mmax), 
	        &(dir_desc[index_image[3]].mu),
		&(dir_desc[index_image[3]].ecart));
	}
    }
}

/*****************************************************************************/

caddr_t proc_haar (m, mi)

    Menu m;
    Menu_item mi;

{
    float *bp, *image;
    int ligne, colonne, inv, jerr, flag_conv;

    inv = ((int)menu_get(mi, MENU_VALUE));
    if (!flag_creer){
	sprintf (buf, "Transformee de Haar\0"); 
	if (inv == -1) strcat (buf, " inverse\0");
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else fromto (FROMTO, DEFAUT);
    if (flag_break) {
	interruption();
	return;
    }
    if (!flag_creer){
	sprintf (buf, ": Image %d --> Image %d\n\0",
		 index_image[0],index_image[1]);
	write_master (buf);
    }
    if (flag_creer){
	struct commande *com;
	com = (struct commande *)new_commande (&macro_cour);
	com->from[0] = index_image[0];
	com->to[0] = index_image[1];
	if (inv == 1){
	    sprintf (com->nom, "HAAR\0");
	    com->code = 54;
	}
	else{		
	    sprintf (com->nom, "HAARI\0");
	    com->code = 55;
	}
	write_macro (com->nom);
	sprintf (buf, " FROM %d TO %d\n\0", index_image[0], index_image[1]);
	write_macro (buf);	
    }
    else{
	if (dir_desc[index_image[0]].type < 3){
	    image = (float *) conv_float (index_image[0]);
	    flag_conv = TRUE;
	}
	else{
	    image = (float *)dir_image[index_image[0]].image;
	    flag_conv = FALSE;
	}
	if (power_2(dir_desc[index_image[0]].nligne) == FALSE ||
	    power_2(dir_desc[index_image[0]].ncolonne) == FALSE)
	    write_erreur(15);
	else {
	    dir_desc[index_image[1]] = dir_desc[index_image[0]];
	    dir_desc[index_image[1]].type = 3;
	    ligne = (int)dir_desc[index_image[1]].nligne;
	    colonne = (int)dir_desc[index_image[1]].ncolonne;
	    bp = (float *)malloc(colonne*ligne*sizeof(*bp));
#if SPIDER == 1
	    if (inv==1)
/*		har2_(image, bp, &colonne, &ligne, &jerr)	*/;
	    else
/*		hari2_(image, bp, &colonne, &ligne, &jerr);	*/
#else
	    write_erreur (90);
#endif
	    if (dir_image[index_image[1]].image != NULL)
		free (dir_image[index_image[1]].image); 
	    dir_image[index_image[1]].image = (unsigned char *)bp;
	    statis (dir_image[index_image[1]].image,
		    dir_desc[index_image[1]].type, 
		    dir_desc[index_image[1]].nligne,
		    dir_desc[index_image[1]].ncolonne,
		    &(dir_desc[index_image[1]].mmin),
		    &(dir_desc[index_image[1]].mmax), 
		    &(dir_desc[index_image[1]].mu),
		    &(dir_desc[index_image[1]].ecart));
	    if (flag_conv) free (image);
	}
    }
}



   

/*      Program implementing the Fast Fourier Transform

  Ref  : Subroutines four_2d,FFTS0,CSTB,BRTB,BIRV,OPTC of the Spider
         Manual.
         latest and last version.
*/


int FindPowerTwo(Dim)
   int Dim;
  {
      int i,j;
      
      j=Dim;
      i= -1;
      do
	{
	   j = j >> 1;
           i++;
	} while (j > 0);
      return(i);
  }
 





/*  FUNCTION CSTB: cos/sin tables, returns a struct TwoTab.
    ------------------------------------------------------------
    calculates the sine ,cosine tables .
  
    **Parameters**
    Dim         :Data Length.
    Inv         :integer which indicates the  type of transform..
                 negative value => inverse transform.
                 positive value => forward transform.
    CosTab      :Array containing the Cosine Table.
    SinTab      :Array containing the Sine Table.

    **Returns**
    0 if executed without errors.
   -2 if there is not enough space in the memory.
*/

int CSTB(Dim, Inv, CosTab, SineTab)
   int Dim,Inv;
   double **CosTab, **SineTab;
  {
     double Val, Arg;
     int i;
   
     *SineTab=(double*) malloc(Dim*sizeof(double));
     *CosTab=(double*) malloc(Dim*sizeof(double));
   if ((*SineTab == NULL) || (*CosTab == NULL))
    {
        return(-2);
    }
   Val = (PI2) /(double) Dim; 
   if (Inv < 0)
     Val= -Val;
   for (i=0; i < Dim; ++i)
    {
	Arg=i*Val;
       *(*SineTab+i)=sin(Arg);
       *(*CosTab+i)=cos(Arg);
    }
   return(0);
  }
  




/*  FUNCTION BRTB: returns the bit reversal table.
    --------------------------------------------------------------
    generates the bit reversal table .

    **Parameters**
    Dim         : Data Length.
    DimP        : 2 ** DimP = Dim; 
                  Remark:no check in the function BRTB  to see if
                         the above equality is verified. 

    **Returns**
    an array  which is the bit reversal table.
*/

int *BRTB(Dim, DimP)
    int DimP,Dim;
   {
       int *Table, i, i1, j, j2, buf;

      Table=(int*) malloc(Dim*sizeof(int)); /* !!! TEST!!! */
      for (i=0; i < Dim; ++i)
      {
          i1=i;
          buf=0;
          for (j=0; j != DimP; j++)  /* no change for 0th place*/
          { 
              j2=i1 >> 1;
	      buf=(buf << 1) + i1 - (j2 << 1);
              i1=j2;
	  }
          *(Table+i)=buf;
      }  
      return (Table);
   }

  





/*  PROCEDURE FFTS0: radix 2 1-D DFT, returns a struct TwoTab
    -------------------------------------------------------------
    executes the butterfly operations for the radix 2 two
    dimensional discrete Fourier transform (DFT).

    **Parameters**
    RealTab     : 1-D Data Array (real part).
                  overwritten with output values.
    ImagTab     : 1-D Data Array (imaginary part).The input array 
                  is overwritten with output values. 
    CosTab      : Cosine Table.
    SineTab     : Sine Table.
    BitTable    : Array containing the bit reversal table.
    Inv         :integer which indicates the  type of transform..
                 negative value => inverse transform.
                 positive value => forward transform.

*/

void FFTS0(RealTab, ImagTab, Dim, SineTab, CosTab, DimP,BitTable,Inv)
    double *RealTab, *ImagTab;
    double *SineTab, *CosTab;
    int Dim, DimP, *BitTable, Inv;
   {
        register int index_sc,nb_stage,Dim1;
        register int index1,index2,k,i,j;
        double tab1r,tab1i,tab2r,tab2i,S,C,RT1,RT2,IT1,IT2,f;
        char car;

        Dim1=Dim >> 1;
        k=0;
        j=0;
        for (nb_stage=0; nb_stage != DimP; nb_stage++)
           {
              do
                {
                   index_sc= *(BitTable+j);
                   S= *(SineTab+index_sc);
                   C= *(CosTab+index_sc);
                   for (i=0; i < Dim1; i++) 
                      {
                  	 index1= k;
                         index2=index1+Dim1;

                         RT1=  *(RealTab+index1);
                         RT2=  *(RealTab+index2);
                         IT1=  *(ImagTab+index1);
                         IT2=  *(ImagTab+index2);
                         tab1r= RT2*C + IT2*S;
                         tab1i= IT2*C - RT2*S;
                         *(RealTab+index2)= RT1 - tab1r;
                         *(ImagTab+index2)= IT1 - tab1i;
                         *(RealTab+index1)= RT1 + tab1r;
                         *(ImagTab+index1)= IT1 + tab1i;
                     
                         k++;
		      }
                     k+=Dim1;
                     j+=2;     
		  } while (k < (Dim-1));
              k=0;
              j=0;
              Dim1 = Dim1 >> 1;
	   }
         if (Inv < 0)     
            for (i=0; i < Dim; ++i)
               {
                 *(RealTab+i)= *(RealTab+i)/Dim;
                 *(ImagTab+i)= *(ImagTab+i)/Dim;
               }  
         for (i = 1 ; i < Dim-1 ; i++)
	    {
               j= *(BitTable+i);
               if (j > i)
                 {
	            f = *(RealTab+i);
                    *(RealTab+i) = *(RealTab+j);
                    *(RealTab+j) = f;
                    f = *(ImagTab+i);
                    *(ImagTab+i) = *(ImagTab+j);
                    *(ImagTab+j) = f;
                 }
            }
      
   }





/*  FUNCTION four_2d: radix 2 2-D DFT, returns an error code.
    -------------------------------------------------------------
    executes the radix 2 two dimensional discrete Fourier 
    transform (DFT).

    **Parameters**
    InTabReal   : 1-D input array containing the real part of the 
                  image.
    InTabImagin : 1-D input array containing the imaginary part of 
                  the image.
    OutTabReal  : 1-D output array containing the real part of the 
                  image.
    OutTabImagin: 1-D output array containing the imaginary part of
                  the image. 
    DimX        : Horizontal dimension of the input/output images,
                  expressed in terms of powers of 2. 
    DimY        : Vertical dimension of the input/output images,
                  expressed in terms of powers of 2.
    TypTransf   : Parameter to specify the transform..
                  TypTransf = 1 --> forward transform.
                  TypTransf = -1 --> inverse transform.
                  TypTransf = 2 --> optical fourier forward
                                    transform.
                  TypTransf = -2 --> optical fourier inverse
                                   transform.

    **ErrorCode**
   -  0  => No Error.
*/             

int four_2d(RInTab, IInTab, ROutTab, IOutTab, DimX, DimY, TypTrans)

      float *RInTab, *IInTab;
      float **ROutTab, **IOutTab;
      int DimX, DimY, TypTrans;
     

     { /*begin ffts2 */
          void FileImageR();

          int DimXP, DimYP, DimXH, DimYH, DimXxDimY, *BitRevTable;
          register int i, j, k, k0, k1, k2, k3, l;
          register double  optfac0, optfac1, ValR, ValI, FactNorm, FactNorm2, fn;
          double *CosT, *SinT, *INtab, *RNtab, *Itab, *Rtab,  *I1tab, *R1tab, buffer;
          double *InTabReal, *InTabImagin;
	  double **OutTabReal, **OutTabImagin;

          DimXxDimY=DimX*DimY;

          *ROutTab=(float*) malloc(DimX*DimY*sizeof(float));
          *IOutTab=(float*) malloc(DimX*DimY*sizeof(float));
 
          InTabReal=(double*) malloc(DimX*DimY*sizeof(double));
          InTabImagin=(double*) malloc(DimX*DimY*sizeof(double));

	  for(i= 0; (i < DimXxDimY); ++i){
	      *(InTabReal + i) = (double) *(RInTab + i);
	      *(InTabImagin + i) = (double) *(IInTab + i);
 	  }

          RNtab=(double*) malloc(DimX*DimY*sizeof(double));
          INtab=(double*) malloc(DimX*DimY*sizeof(double));
          if ((RNtab == NULL) || (INtab == NULL)) return(-5);
          
          FactNorm2= (sqrt((double)DimX * DimY));
          FactNorm= 1.00000000000000000 / FactNorm2;
          fn= FactNorm; 
          DimXP=FindPowerTwo(DimX);
          if (DimX != DimY) DimYP=FindPowerTwo(DimY);
          else DimYP=DimXP;
          if (CSTB(DimX, TypTrans, &CosT, &SinT) == -2) return(-4);

          Itab=(double*) malloc(DimX*sizeof(double));
          Rtab=(double*) malloc(DimX*sizeof(double));
          if ((Rtab == NULL) || (Itab == NULL)) return(-3);

          DimXH=DimX/2 ;
          DimYH=DimY/2 ;
 
          BitRevTable=BRTB(DimX,DimXP);
          switch (TypTrans){  
                 case 2:  /* tf optique direct suivant les lignes */
                          optfac0= -1.0000000000000000;
                          for (j=0; j < DimY; ++j)  
                             {
                                k1= DimX*j;
                                k2= k1+DimX;

                                optfac0= -optfac0;
                                optfac1= optfac0;
                                for (i=0; i < DimX; ++i)
                                   {  
                                      k= k1+i;
                                      *(Rtab+i)= *(InTabReal+k) * optfac1;
                                      *(Itab+i)= *(InTabImagin+k) * optfac1;
                                      optfac1= -optfac1;
         	                   }  
                                FFTS0(Rtab, Itab, DimX, SinT, CosT, DimXP, BitRevTable,TypTrans);
                                *(RNtab+k1)= *(Rtab);
                                *(INtab+k1)= *(Itab);
                                for (i=1; i < DimXH; ++i)
                                   {
                                      k= k1+i;
                                      l= k2-i;
                                     
                                      buffer= *(Rtab+i);
                                      *(RNtab+k)= buffer;
                                      *(RNtab+l)= buffer;
                                      buffer= *(Itab+i);
                                      *(INtab+k)= buffer;
                                      *(INtab+l)= - buffer;
	 	                   }
                                k=k1+DimXH;
                                *(RNtab+k)= *(Rtab+DimXH);
                                *(INtab+k)= *(Itab+DimXH);
       	                      }
	                   break;
                            
                  case 1:  /* tf pour les autres suivant les lignes */
	                   for (j=0; j < DimY; ++j)  
                              {
                                 k1= DimX*j;
                                 k2= k1+DimX;
                                    
                                 for (i=0; i < DimX; ++i)
                                    {
                                       k= k1+i;
                                       
                                       *(Rtab+i)= *(InTabReal+k);
                                       *(Itab+i)= *(InTabImagin+k);
		                    }
                                 FFTS0(Rtab, Itab, DimX, SinT, CosT, DimXP, BitRevTable,TypTrans);
                                 *(RNtab+k1)= *(Rtab);
                                 *(INtab+k1)= *(Itab);
                                 for (i=1; i < DimXH; ++i)
                                    {
                                       k= k1+i;
                                       l= k2-i;
                                
                                       buffer= *(Rtab+i);
                                       *(RNtab+k)=buffer;
                                       *(RNtab+l)= buffer;
                                       buffer= *(Itab+i);
                                       *(INtab+k)= buffer;
                                       *(INtab+l)= - buffer;
		                    }
                                 k=k1+DimXH;
                                 *(RNtab+k)= *(Rtab+DimXH);
                                 *(INtab+k)= *(Itab+DimXH);
                              }          
                           break;
                                                             
               	 case -2: optfac0= 1.0000000000;
                          optfac1=optfac0;
                           for (i=0; i < DimX; ++i)
                              {
                                 *(Rtab+i)= *(InTabReal+i)*optfac1;
                                 *(Itab+i)= *(InTabImagin+i)*optfac1;
                                 optfac1= -optfac1;
		               }
                           FFTS0(Rtab, Itab, DimX, SinT, CosT, DimXP, BitRevTable,TypTrans);
                           for (i=0; i < DimX; ++i)
                              {
                                 *(RNtab+i)= *(Rtab+i);
                                 *(INtab+i)= *(Itab+i);
        	              }

                          for (j=1; j < DimYH; ++j)  
                              {
                                 optfac0= -optfac0;
                                 optfac1= optfac0;
                                 k1= DimX*j;   /*convert * to + ??? */
                                 k0=DimXxDimY-k1;
                                 for (i=0; i < DimX; ++i)
                                    {
                                       k= k1+i;
                                       *(Rtab+i)= *(InTabReal+k)*optfac1;
                                       *(Itab+i)= *(InTabImagin+k)*optfac1;
                                       optfac1= -optfac1;
		                    }
                                 FFTS0(Rtab, Itab, DimX, SinT, CosT, DimXP, BitRevTable,TypTrans);
                                 for (i=0; i < DimX; ++i)
                                    {
                                       k= k1+i;
                                       k2= k0+i;
                                       buffer= *(Rtab+i);
                                       *(RNtab+k)= buffer;
                                       *(RNtab+k2)= buffer;
                                       buffer= *(Itab+i);
                                       *(INtab+k)= buffer;
                                       *(INtab+k2)= - buffer;
		                    }
			      }
                                 
                              optfac0= -optfac0;
                              optfac1= optfac0;
                              k1= DimX*DimYH;
                              for (i=0; i < DimX; ++i)
                                 {
                                    k= k1+i;
                                    *(Rtab+i)= *(InTabReal+k)*optfac1;
                                    *(Itab+i)= *(InTabImagin+k)*optfac1;
                                    optfac1= -optfac1;
	                         }
                              FFTS0(Rtab, Itab, DimX, SinT, CosT, DimXP, BitRevTable,TypTrans);
                              for (i=0; i < DimX; ++i)
                                 {
                                    k= k1+i;
                                    *(RNtab+k)= *(Rtab+i);
                                    *(INtab+k)= *(Itab+i);
                                 }
                           break;

               	 default:  for (i=0; i < DimX; ++i)
                              {
                                 *(Rtab+i)= *(InTabReal+i);
                                 *(Itab+i)= *(InTabImagin+i);
		               }
                           FFTS0(Rtab, Itab, DimX, SinT, CosT, DimXP, BitRevTable,TypTrans);
                           for (i=0; i < DimX; ++i)
                              {
                                 *(RNtab+i)= *(Rtab+i);
                                 *(INtab+i)= *(Itab+i);
        	              }

                          for (j=1; j < DimYH; ++j)  
                              {
                                 k1= DimX*j; /* convert  * to + ??? */
                                 k0=DimXxDimY-k1;
                                 for (i=0; i < DimX; ++i)
                                    {
                                       k= k1+i;
                                       *(Rtab+i)= *(InTabReal+k);
                                       *(Itab+i)= *(InTabImagin+k);
		                    }
                                 FFTS0(Rtab, Itab, DimX, SinT, CosT, DimXP, BitRevTable,TypTrans);
                                 for (i=0; i < DimX; ++i)
                                    {
                                       k= k1+i;
                                       k2=k0+i;
                                       buffer= *(Rtab+i);
                                       *(RNtab+k)= buffer;
                                       *(RNtab+k2)= buffer;
                                       buffer= *(Itab+i);
                                       *(INtab+k)= buffer;
                                       *(INtab+k2)= - buffer;
		                    }
			      }

                              k1= DimX*DimYH;
                              for (i=0; i < DimX; ++i)
                                 {
                                    k= k1+i;
                                    *(Rtab+i)= *(InTabReal+k);
                                    *(Itab+i)= *(InTabImagin+k);
	                         }
                              FFTS0(Rtab, Itab, DimX, SinT, CosT, DimXP, BitRevTable,TypTrans);
                              for (i=0; i < DimX; ++i)
                                 {
                                    k= k1+i;
                                    *(RNtab+k)= *(Rtab+i);
                                    *(INtab+k)= *(Itab+i);
                                 }
                           break;
	  }


          BitRevTable=BRTB(DimY,DimYP);
          if (DimX != DimY) CSTB(DimY,TypTrans,&CosT,&SinT);    
          switch (TypTrans){ 
                 case -1: 
                           for (j=0; j < DimX; ++j)  
                              {
                                 *(Rtab)= *(RNtab+j);
                                 *(Itab)= *(INtab+j);
                                 for (i=1; i < DimYH; ++i)
                                    {
                                       k=DimY-i;
                                       k1= DimX*i+j;
                                       buffer= *(RNtab+k1);
                                       *(Rtab+i)=  buffer ;
                                       *(Rtab+k)=  buffer;
                                       buffer= *(INtab+k1);
                                       *(Itab+i)=  buffer ; 
                                       *(Itab+k)=  - buffer ; 
	                            }  
                                 i=DimX*DimYH+j;    
                                 *(Rtab+DimYH)= *(RNtab+i);
                                 *(Itab+DimYH)= *(INtab+i);
                                 FFTS0(Rtab, Itab, DimY, SinT, CosT, DimYP,BitRevTable,TypTrans);                                          
                                 *(RNtab+j)= *(Rtab) * FactNorm2;
                                 *(INtab+j)= *(Itab) * FactNorm2;  
                                 for (i=1; i < DimX; ++i)
                                    {
                                       k= DimX*i;
                                       k1= k+j;
                                          
                                       *(RNtab+k1)= *(Rtab+i) * FactNorm2;
                                       *(INtab+k1)= *(Itab+i) * FactNorm2;   
		                    }  
       	                      }
                           break;     
	         

                 case -2:  
                           optfac0=  -FactNorm2;   
                           for (j=0; j < DimX; ++j)  
                              {
                                 optfac0= -optfac0;
                                 optfac1= optfac0;
                                 *(Rtab)= *(RNtab+j);
                                 *(Itab)= *(INtab+j);
                                 for (i=1; i < DimYH; ++i)
                                    {
                                       k=DimY-i;
                                       k1= DimX*i+j;

                                       buffer= *(RNtab+k1);
                                       *(Rtab+i)=  buffer ;
                                       *(Rtab+k)=  buffer;
                                       buffer= *(INtab+k1);
                                       *(Itab+i)=  buffer ; 
                                       *(Itab+k)=  - buffer ; 
	                            }  
                                 i=DimX*DimYH+j;     
                                 *(Rtab+DimYH)= *(RNtab+i);
                                 *(Itab+DimYH)= *(INtab+i);
                                 FFTS0(Rtab, Itab, DimY, SinT, CosT, DimYP,BitRevTable,TypTrans);
                                 for (i=0; i < DimY; ++i)
                                    {
                                       k= DimX*i+j;         
                                       *(RNtab+k)= *(Rtab+i)  * optfac1 ;
                                       *(INtab+k)= *(Itab+i)  * FactNorm2 ;
                                       optfac1= -optfac1;
                                          
		                    }  
       	                      }
                           break; 

                  case 2:       
                           FactNorm=fn;
                           for (i=0; i < DimY; ++i)
                              {
                                 k= DimX*i;
                                 *(Rtab+i)= *(RNtab+k);
                                 *(Itab+i)= *(INtab+k);
	                      }
                           FFTS0(Rtab, Itab, DimY, SinT, CosT, DimYP, BitRevTable,TypTrans);
                           FactNorm2= FactNorm;
                           for (i=0; i < DimY; ++i)
                              {
                                 k= DimX*i;         
                                 *(RNtab+k)= *(Rtab+i) * FactNorm2;      
                                 *(INtab+k)= *(Itab+i) * FactNorm2;
                                 FactNorm2= -FactNorm2;   
	                      }
                           for (j=1; j < DimXH; ++j){
                                 FactNorm= -FactNorm;
                                 for (i=0; i < DimY; ++i)
                                    {
                                       k= DimX*i+j;
                                       *(Rtab+i)= *(RNtab+k);
                                       *(Itab+i)= *(INtab+k);
		                    }
                                 FFTS0(Rtab, Itab, DimY, SinT, CosT, DimYP, BitRevTable,TypTrans);
                                 l= DimX-j;

                                 buffer= *(Rtab) * FactNorm;
                                 *(RNtab+j)=buffer;
                                 *(RNtab+l)= buffer;
                                 buffer= *(Itab) * FactNorm;   
                                 *(INtab+j)= buffer;
                                 *(INtab+l)= -buffer;  
                                 FactNorm2= -FactNorm;
                                 for (i=1; i < DimY; ++i)
                                    {
                                       k= DimX*i+j;
                                       k1=DimX*(DimY-i)+l;

                                       buffer= *(Rtab+i) * FactNorm2;      
                                       *(RNtab+k)= buffer;      
                                       *(RNtab+k1)= buffer;
                                       buffer= *(Itab+i) * FactNorm2;      
                                       *(INtab+k1)= - buffer;   
                                       *(INtab+k)= buffer;
                                       FactNorm2= -FactNorm2;
		                    }  
			   }
                           for (i=0; i < DimY; ++i){
                               k= DimX*i+DimXH;
                               *(Rtab+i)= *(RNtab+k);
                               *(Itab+i)= *(INtab+k);
		           }
                           FFTS0(Rtab, Itab, DimY, SinT, CosT, DimYP, BitRevTable,TypTrans);
                           FactNorm= -FactNorm;
                           *(RNtab+DimXH)= *(Rtab) * FactNorm;   
                           *(INtab+DimXH)= *(Itab) * FactNorm;   
                           FactNorm2= -FactNorm;
                           for (i=1; i < DimY; ++i){
                              k= DimX*i+DimXH;
                              *(RNtab+k)= *(Rtab+i) * FactNorm2;  
                              *(INtab+k)= *(Itab+i) * FactNorm2;
                              FactNorm2= -FactNorm2;   
		           }      
                           break;
	                       
                 default:       
                           k3 = DimX*DimY;
                           for (i=0; i < DimY; ++i)
                              {
                                 k= DimX*i;
                                 *(Rtab+i)= *(RNtab+k);
                                 *(Itab+i)= *(INtab+k);
	                      }
                           FFTS0(Rtab, Itab, DimY, SinT, CosT, DimYP, BitRevTable,TypTrans);
                           for (i=0; i < DimY; ++i)
                              {
                                 k= DimX*i;         
                                 *(RNtab+k)= *(Rtab+i) * FactNorm;      
                                 *(INtab+k)= *(Itab+i) * FactNorm;   
	                      }
                           for (j=1; j < DimXH; ++j){
                                 for (i=0; i < DimY; ++i)
                                    {
                                       k= DimX*i+j;
                                       *(Rtab+i)= *(RNtab+k);
                                       *(Itab+i)= *(INtab+k);
		                    }
                                 FFTS0(Rtab, Itab, DimY, SinT, CosT, DimYP, BitRevTable,TypTrans);
                                 l= DimX-j;

                                 buffer= *(Rtab) * FactNorm;
                                 *(RNtab+j)=buffer;
                                 *(RNtab+l)= buffer;
                                 buffer= *(Itab) * FactNorm;   
                                 *(INtab+j)= buffer;
                                 *(INtab+l)= -buffer;  
                                 for (i=1; i < DimY; ++i)
                                    {
                                       k0= DimX*i;
                                       k= k0+j;
                                       k1= k3-k0+l;

                                       buffer= *(Rtab+i) * FactNorm;      
                                       *(RNtab+k)= buffer;      
                                       *(RNtab+k1)= buffer;
                                       buffer= *(Itab+i) * FactNorm;      
                                       *(INtab+k1)= - buffer;   
                                       *(INtab+k)= buffer;
		                    }  
			   }
                           for (i=0; i < DimY; ++i){
                               k= DimX*i+DimXH;
                               *(Rtab+i)= *(RNtab+k);
                               *(Itab+i)= *(INtab+k);
		           }
                           FFTS0(Rtab, Itab, DimY, SinT, CosT, DimYP, BitRevTable,TypTrans);
                           *(RNtab+DimXH)= *(Rtab) * FactNorm;   
                           *(INtab+DimXH)= *(Itab) * FactNorm;   
                           for (i=1; i < DimY; ++i){
                              k= DimX*i+DimXH;
                              *(RNtab+k)= *(Rtab+i) * FactNorm;  
                              *(INtab+k)= *(Itab+i) * FactNorm;   
		           }      
                           break;

	  }

	  for ( i = 0; (i < DimXxDimY); ++i){
	      *(*IOutTab + i)= (float) *(INtab + i);
	      *(*ROutTab + i)= (float) *(RNtab + i);
	  }
	  free(INtab);
	  free(RNtab);
	  free(InTabReal);
	  free(InTabImagin);
	  
          return(0);
     }





